/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.xmlrpc.Fault;
import com.liferay.portal.xmlrpc.XmlRpcMethodUtil;
import com.liferay.portal.xmlrpc.XmlRpcUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XmlRpcServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(XmlRpcServlet.class);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        PortalUtil.sendError((int)404, (Exception)new IllegalArgumentException("The GET method is not supported"), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Fault xmlRpcResponse = null;
        try {
            long companyId = PortalInstances.getCompanyId(httpServletRequest);
            String xml = StringUtil.read((InputStream)httpServletRequest.getInputStream());
            Tuple methodTuple = XmlRpcUtil.parseMethod(xml);
            String methodName = (String)methodTuple.getObject(0);
            Object[] args = (Object[])methodTuple.getObject(1);
            xmlRpcResponse = this.invokeMethod(companyId, this.getToken(httpServletRequest), methodName, args);
        }
        catch (IOException ioException) {
            xmlRpcResponse = XmlRpcUtil.createFault(-32700, "XML is not well formed");
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
        }
        catch (XmlRpcException xmlRpcException) {
            _log.error((Throwable)xmlRpcException);
        }
        if (xmlRpcResponse == null) {
            xmlRpcResponse = XmlRpcUtil.createFault(-32400, "Unknown error occurred");
        }
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("text/xml");
        httpServletResponse.setStatus(200);
        try {
            ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)xmlRpcResponse.toXml());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            httpServletResponse.setStatus(412);
        }
    }

    protected String getToken(HttpServletRequest httpServletRequest) {
        String token = httpServletRequest.getPathInfo();
        return HttpComponentsUtil.fixPath((String)token);
    }

    protected Response invokeMethod(long companyId, String token, String methodName, Object[] arguments) throws XmlRpcException {
        Method method = XmlRpcMethodUtil.getMethod(token, methodName);
        if (method == null) {
            return XmlRpcUtil.createFault(-32601, "Requested method not found");
        }
        if (!method.setArguments(arguments)) {
            return XmlRpcUtil.createFault(-32602, "Method arguments are invalid");
        }
        return method.execute(companyId);
    }
}

