/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class PreferencesValueUtil {
    private static final String _NULL_ELEMENT = "NULL_ELEMENT";
    private static final String _NULL_VALUE = "NULL_VALUE";

    public static String getActualValue(String value) {
        if (value == null || value.equals(_NULL_VALUE)) {
            return null;
        }
        return PreferencesValueUtil._fromCompactSafe(value);
    }

    public static String[] getActualValues(String[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 1) {
            String actualValue = PreferencesValueUtil.getActualValue(values[0]);
            if (actualValue == null) {
                return null;
            }
            if (actualValue.equals(_NULL_ELEMENT)) {
                return new String[]{null};
            }
            return new String[]{actualValue};
        }
        String[] actualValues = new String[values.length];
        for (int i = 0; i < actualValues.length; ++i) {
            actualValues[i] = PreferencesValueUtil.getActualValue(values[i]);
        }
        return actualValues;
    }

    public static String getXMLSafeValue(String value) {
        if (value == null) {
            return _NULL_VALUE;
        }
        return PreferencesValueUtil.toCompactSafe(value);
    }

    public static String[] getXMLSafeValues(String[] values) {
        if (values == null) {
            return new String[]{_NULL_VALUE};
        }
        if (values.length == 1 && values[0] == null) {
            return new String[]{_NULL_ELEMENT};
        }
        String[] xmlSafeValues = new String[values.length];
        for (int i = 0; i < xmlSafeValues.length; ++i) {
            xmlSafeValues[i] = PreferencesValueUtil.getXMLSafeValue(values[i]);
        }
        return xmlSafeValues;
    }

    public static boolean isNull(String[] values) {
        return ArrayUtil.isEmpty((Object[])values) || values.length == 1 && PreferencesValueUtil.getActualValue(values[0]) == null;
    }

    public static String toCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "\r"}, (String[])new String[]{"[$NEW_LINE$]", "[$NEW_LINE$]", "[$NEW_LINE$]"});
    }

    private static String _fromCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String)"[$NEW_LINE$]", (String)"\n");
    }
}

