/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;

public class OmniadminUtil {
    private static final Log _log = LogFactoryUtil.getLog(OmniadminUtil.class);

    public static boolean isOmniadmin(long userId) {
        if (userId <= 0L) {
            return false;
        }
        try {
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            if (user == null) {
                return false;
            }
            return OmniadminUtil.isOmniadmin(user);
        }
        catch (SystemException systemException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)systemException);
            }
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOmniadmin(User user) {
        int i;
        block18: {
            try {
                if (PropsValues.OMNIADMIN_USERS.length > 0) {
                    i = 0;
                    break block18;
                }
                if (user.isGuestUser()) return false;
                if (user.getCompanyId() != PortalInstancePool.getDefaultCompanyId()) {
                    return false;
                }
                try (SafeCloseable safeCloseable = CompanyThreadLocal.setWithSafeCloseable((Long)PortalInstancePool.getDefaultCompanyId());){
                    boolean bl = RoleLocalServiceUtil.hasUserRole((long)user.getUserId(), (long)user.getCompanyId(), (String)"Administrator", (boolean)true);
                    return bl;
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to check if a user is an omniadmin", (Throwable)exception);
                return false;
            }
        }
        while (i < PropsValues.OMNIADMIN_USERS.length) {
            if (PropsValues.OMNIADMIN_USERS[i] == user.getUserId()) {
                if (user.getCompanyId() == PortalInstancePool.getDefaultCompanyId()) return true;
                return false;
            }
            ++i;
        }
        return false;
    }
}

