/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.FileEntryLockException;
import com.liferay.document.library.kernel.exception.InvalidFolderException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.processor.DLProcessorHelperUtil;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.document.library.kernel.util.comparator.FolderNameComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelTitleComparator;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.ResourceConstants;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.RepositoryPersistence;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.temporaryrepository.TemporaryFileEntryRepository;
import com.liferay.portlet.documentlibrary.service.base.DLAppServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.DLAppUtil;
import com.liferay.portlet.documentlibrary.util.DLPortletResourcePermissionUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DLAppServiceImpl
extends DLAppServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLAppServiceImpl.class);
    @BeanReference(type=AssetCategoryLocalService.class)
    private AssetCategoryLocalService _assetCategoryLocalService;
    @BeanReference(type=AssetTagLocalService.class)
    private AssetTagLocalService _assetTagLocalService;
    @BeanReference(type=AssetVocabularyLocalService.class)
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @BeanReference(type=DLAppHelperLocalService.class)
    private DLAppHelperLocalService _dlAppHelperLocalService;
    @BeanReference(type=RatingsEntryLocalService.class)
    private RatingsEntryLocalService _ratingsEntryLocalService;
    @BeanReference(type=RepositoryPersistence.class)
    private RepositoryPersistence _repositoryPersistence;
    @BeanReference(type=ResourcePermissionLocalService.class)
    private ResourcePermissionLocalService _resourcePermissionLocalService;

    @Deprecated
    public FileEntry addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        return this.addFileEntry(null, repositoryId, folderId, sourceFileName, mimeType, title, "", description, changeLog, file, null, null, null, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, byte[] bytes, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.addFileEntry(externalReferenceCode, repositoryId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, displayDate, expirationDate, reviewDate, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry addFileEntry(String externalReferenceCode, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.addFileEntry(externalReferenceCode, repositoryId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, null, 0L, displayDate, expirationDate, reviewDate, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.addFileEntry(externalReferenceCode, this.getUserId(), folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, displayDate, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry addFileEntry(String externalReferenceCode, long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (inputStream == null) {
            inputStream = new UnsyncByteArrayInputStream(new byte[0]);
            size = 0L;
        }
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)DLAppUtil.getExtension(title, sourceFileName));
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    FileEntry fileEntry = this.addFileEntry(externalReferenceCode, repositoryId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, file, displayDate, expirationDate, reviewDate, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioException);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.addFileEntry(externalReferenceCode, this.getUserId(), folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut addFileShortcut(long repositoryId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.addFileShortcut(this.getUserId(), folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(String externalReferenceCode, long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        Folder folder = repository.addFolder(externalReferenceCode, this.getUserId(), parentFolderId, name, description, serviceContext);
        this._dlAppHelperLocalService.addFolder(this.getUserId(), folder, serviceContext);
        return folder;
    }

    public FileEntry addTempFileEntry(long groupId, long folderId, String folderName, String fileName, File file, String mimeType) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)folderName, (String)fileName, (File)file, (String)mimeType);
    }

    public FileEntry addTempFileEntry(long groupId, long folderId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)folderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void cancelCheckOut(long fileEntryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        FileVersion draftFileVersion = repository.cancelCheckOut(fileEntryId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(1);
        this._dlAppHelperLocalService.cancelCheckOut(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), draftFileVersion, serviceContext);
    }

    public void checkInFileEntry(long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        repository.checkInFileEntry(this.getUserId(), fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileVersion.getFileVersionId());
    }

    public void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        repository.checkInFileEntry(this.getUserId(), fileEntryId, lockUuid, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileVersion.getFileVersionId());
    }

    public void checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, serviceContext);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileEntryId);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
        FileVersion fileVersion = fileEntry.getLatestFileVersion();
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileVersion, fileEntryId);
        return fileEntry;
    }

    public FileEntry copyFileEntry(long fileEntryId, long destinationFolderId, long destinationRepositoryId, long fileEntryTypeId, long[] groupIds, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository sourceRepository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        return this.copyFileEntry(this.getRepository(destinationRepositoryId), sourceRepository.getFileEntry(fileEntryId), destinationFolderId, fileEntryTypeId, groupIds, serviceContext);
    }

    public FileShortcut copyFileShortcut(long fileShortcutId, long destinationFolderId, long destinationRepositoryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository destinationRepository = RepositoryProviderUtil.getRepository((long)destinationRepositoryId);
        FileShortcut fileShortcut = this.getFileShortcut(fileShortcutId);
        FileShortcut targetFileShortcut = destinationRepository.addFileShortcut(this.getUserId(), destinationFolderId, fileShortcut.getToFileEntryId(), serviceContext);
        this._copyResourcePermissions(fileShortcut.getCompanyId(), DLFileShortcut.class.getName(), fileShortcut.getFileShortcutId(), targetFileShortcut.getFileShortcutId());
        return targetFileShortcut;
    }

    public Folder copyFolder(long sourceRepositoryId, long sourceFolderId, long destinationRepositoryId, long destinationParentFolderId, Map<Long, Long> fileEntryTypeIds, long[] groupIds, ServiceContext serviceContext) throws PortalException {
        if (sourceRepositoryId == destinationRepositoryId) {
            this._validateFolders(sourceRepositoryId, sourceFolderId, destinationParentFolderId);
        }
        return this.copyFolder(sourceFolderId, destinationParentFolderId, this.getRepository(sourceRepositoryId), this.getRepository(destinationRepositoryId), fileEntryTypeIds, groupIds, serviceContext);
    }

    public Folder copyFolder(long repositoryId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        Folder sourceFolder = repository.getFolder(sourceFolderId);
        Folder targetFolder = repository.addFolder(null, this.getUserId(), parentFolderId, name, description, serviceContext);
        this._dlAppHelperLocalService.addFolder(this.getUserId(), targetFolder, serviceContext);
        this.copyFolder(repository, sourceFolder, targetFolder, serviceContext);
        return targetFolder;
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        this._dlAppHelperLocalService.deleteFileEntry(repository.getFileEntry(fileEntryId));
        repository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileEntryByTitle(long repositoryId, long folderId, String title) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        this._dlAppHelperLocalService.deleteFileEntry(repository.getFileEntry(folderId, title));
        repository.deleteFileEntry(folderId, title);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)fileShortcutId);
        repository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileVersionRepository((long)fileVersionId);
        repository.deleteFileVersion(fileVersionId);
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        repository.deleteFileVersion(fileEntryId, version);
    }

    public void deleteFolder(long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        Folder folder = repository.getFolder(folderId);
        List fileEntries = repository.getRepositoryFileEntries(0L, folderId, -1, -1, null);
        for (FileEntry fileEntry : fileEntries) {
            this._dlAppHelperLocalService.deleteFileEntry(fileEntry);
        }
        repository.deleteFolder(folderId);
        this._dlAppHelperLocalService.deleteFolder(folder);
    }

    public void deleteFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.deleteFolder(parentFolderId, name);
    }

    public void deleteTempFileEntry(long groupId, long folderId, String folderName, String fileName) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)this.getUserId(), (String)folderName, (String)fileName);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, start, end, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, fileEntryTypeId, -1, -1);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, fileEntryTypeId, start, end, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, fileEntryTypeId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, String[] mimeTypes) throws PortalException {
        return this.getFileEntries(repositoryId, folderId, mimeTypes, -1, -1, (OrderByComparator<FileEntry>)new RepositoryModelTitleComparator(true));
    }

    public List<FileEntry> getFileEntries(long repositoryId, long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntries(folderId, mimeTypes, start, end, orderByComparator);
    }

    public List<Object> getFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, int start, int end) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcutsCount(folderId, status);
    }

    public int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
    }

    public int getFileEntriesCount(long repositoryId, long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long repositoryId, long folderId, long fileEntryTypeId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long repositoryId, long folderId, String[] mimeTypes) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFileEntriesCount(folderId, mimeTypes);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        return repository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long groupId, long folderId, String title) throws PortalException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
            return repository.getFileEntry(folderId, title);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (folderId == 0L) {
                throw noSuchFileEntryException;
            }
            com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
            return repository.getFileEntry(folderId, title);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public FileEntry getFileEntryByExternalReferenceCode(long groupId, String externalReferenceCode) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getFileEntryByExternalReferenceCode(externalReferenceCode);
    }

    public FileEntry getFileEntryByFileName(long groupId, long folderId, String fileName) throws PortalException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
            return repository.getFileEntryByFileName(folderId, fileName);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (folderId == 0L) {
                throw noSuchFileEntryException;
            }
            com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
            return repository.getFileEntryByFileName(folderId, fileName);
        }
    }

    public FileEntry getFileEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        FileEntry fileEntry = this.fetchFileEntryByUuidAndRepositoryId(uuid, groupId);
        if (fileEntry != null) {
            return fileEntry;
        }
        List repositories = this._repositoryPersistence.findByGroupId(groupId);
        for (Repository repository : repositories) {
            if (Objects.equals(repository.getClassName(), TemporaryFileEntryRepository.class.getName())) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Skipping temporary file entry repository");
                continue;
            }
            fileEntry = this.fetchFileEntryByUuidAndRepositoryId(uuid, repository.getRepositoryId());
            if (fileEntry == null) continue;
            return fileEntry;
        }
        throw new NoSuchFileEntryException(StringBundler.concat((Object[])new Object[]{"No DLFileEntry exists with the key {uuid=", uuid, ", groupId=", groupId, "}"}));
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)fileShortcutId);
        return repository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileVersionRepository((long)fileVersionId);
        return repository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        return repository.getFolder(folderId);
    }

    public Folder getFolder(long repositoryId, long parentFolderId, String name) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolder(parentFolderId, name);
    }

    public Folder getFolderByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getFolderByExternalReferenceCode(externalReferenceCode);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, -1, -1);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, includeMountFolders, start, end, (OrderByComparator<Folder>)new FolderNameComparator(true));
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, status, includeMountFolders, start, end, orderByComparator);
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException {
        return this.getFolders(repositoryId, parentFolderId, start, end, (OrderByComparator<Folder>)new FolderNameComparator(true));
    }

    public List<Folder> getFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFolders(parentFolderId, true, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, includeMountFolders, start, end, (OrderByComparator<?>)new RepositoryModelTitleComparator(true));
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, null, includeMountFolders, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimeTypes, includeMountFolders, includeOwner, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntriesAndFileShortcuts(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcuts(repositoryId, folderId, status, mimeTypes, includeMountFolders, true, start, end, orderByComparator);
    }

    @ThreadLocalCachable
    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, null, includeMountFolders);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws PortalException {
        return this.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, mimeTypes, includeMountFolders, true);
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes, includeMountFolders, includeOwner);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId) throws PortalException {
        return this.getFoldersCount(repositoryId, parentFolderId, true);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, boolean includeMountFolders) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersCount(parentFolderId, includeMountFolders);
    }

    public int getFoldersCount(long repositoryId, long parentFolderId, int status, boolean includeMountFolders) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersCount(parentFolderId, status, includeMountFolders);
    }

    public int getFoldersFileEntriesCount(long repositoryId, List<Long> folderIds, int status) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getFoldersFileEntriesCount(folderIds, status);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, int start, int end) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, 0L, start, end, (OrderByComparator<FileEntry>)new RepositoryModelModifiedDateComparator());
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, 0L, start, end, orderByComparator);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end) throws PortalException {
        return this.getGroupFileEntries(groupId, userId, rootFolderId, start, end, (OrderByComparator<FileEntry>)new RepositoryModelModifiedDateComparator());
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntries(userId, rootFolderId, start, end, orderByComparator);
    }

    public List<FileEntry> getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, orderByComparator);
    }

    public int getGroupFileEntriesCount(long groupId, long userId) throws PortalException {
        return this.getGroupFileEntriesCount(groupId, userId, 0L);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntriesCount(userId, rootFolderId);
    }

    public int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
    }

    public List<FileShortcut> getGroupFileShortcuts(long groupId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(groupId);
        return repository.getRepositoryFileShortcuts(groupId);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId) throws PortalException {
        return this.getMountFolders(repositoryId, parentFolderId, -1, -1);
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end) throws PortalException {
        return this.getMountFolders(repositoryId, parentFolderId, start, end, (OrderByComparator<Folder>)new FolderNameComparator(true));
    }

    public List<Folder> getMountFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getMountFolders(parentFolderId, start, end, orderByComparator);
    }

    public int getMountFoldersCount(long repositoryId, long parentFolderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getMountFoldersCount(parentFolderId);
    }

    public void getSubfolderIds(long repositoryId, List<Long> folderIds, long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long repositoryId, long folderId) throws PortalException {
        return this.getSubfolderIds(repositoryId, folderId, true);
    }

    public List<Long> getSubfolderIds(long repositoryId, long folderId, boolean recurse) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.getSubfolderIds(folderId, recurse);
    }

    @CTAware(onProduction=true)
    public String[] getTempFileNames(long groupId, long folderId, String folderName) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"ADD_DOCUMENT");
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)this.getUserId(), (String)folderName);
    }

    public Lock lockFolder(long repositoryId, long folderId) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.lockFolder(folderId);
    }

    public Lock lockFolder(long repositoryId, long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        Folder toFolder;
        com.liferay.portal.kernel.repository.Repository fromRepository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        com.liferay.portal.kernel.repository.Repository toRepository = this.getFolderRepository(newFolderId, serviceContext.getScopeGroupId());
        if (newFolderId != 0L && (toFolder = toRepository.getFolder(newFolderId)).isMountPoint()) {
            toRepository = this.getRepository(toFolder.getRepositoryId());
        }
        if (fromRepository.getRepositoryId() == toRepository.getRepositoryId()) {
            return fromRepository.moveFileEntry(this.getUserId(), fileEntryId, newFolderId, serviceContext);
        }
        return this.moveFileEntry(fileEntryId, newFolderId, fromRepository, toRepository, serviceContext);
    }

    public Folder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        Folder toFolder;
        com.liferay.portal.kernel.repository.Repository fromRepository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        com.liferay.portal.kernel.repository.Repository toRepository = this.getFolderRepository(parentFolderId, serviceContext.getScopeGroupId());
        if (parentFolderId != 0L && (toFolder = toRepository.getFolder(parentFolderId)).isMountPoint()) {
            toRepository = this.getRepository(toFolder.getRepositoryId());
        }
        if (fromRepository.getRepositoryId() == toRepository.getRepositoryId()) {
            return fromRepository.moveFolder(this.getUserId(), folderId, parentFolderId, serviceContext);
        }
        return this.moveFolder(folderId, parentFolderId, fromRepository, toRepository, serviceContext);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        Lock lock = LockManagerUtil.getLockByUuidAndCompanyId((String)lockUuid, (long)companyId);
        long fileEntryId = GetterUtil.getLong((String)lock.getKey());
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        return repository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        Lock lock = LockManagerUtil.getLockByUuidAndCompanyId((String)lockUuid, (long)companyId);
        long folderId = GetterUtil.getLong((String)lock.getKey());
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFolderRepository((long)folderId);
        return repository.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        repository.revertFileEntry(this.getUserId(), fileEntryId, version, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
    }

    public Hits search(long repositoryId, long creatorUserId, int status, int start, int end) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.search(creatorUserId, status, start, end);
    }

    public Hits search(long repositoryId, long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(long repositoryId, SearchContext searchContext) throws SearchException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
            PermissionChecker permissionChecker = this.getPermissionChecker();
            searchContext.setCompanyId(permissionChecker.getCompanyId());
            searchContext.setUserId(permissionChecker.getUserId());
            return repository.search(searchContext);
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    public Hits search(long repositoryId, SearchContext searchContext, Query query) throws SearchException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
            PermissionChecker permissionChecker = this.getPermissionChecker();
            searchContext.setCompanyId(permissionChecker.getCompanyId());
            searchContext.setUserId(permissionChecker.getUserId());
            return repository.search(searchContext, query);
        }
        catch (Exception exception) {
            throw new SearchException((Throwable)exception);
        }
    }

    public void subscribeFileEntryType(long groupId, long fileEntryTypeId) throws PortalException {
        PortletResourcePermission portletResourcePermission = DLPortletResourcePermissionUtil.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.subscribeFileEntryType(this.getUserId(), groupId, fileEntryTypeId);
    }

    public void subscribeFolder(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.dlAppLocalService.subscribeFolder(this.getUserId(), groupId, folderId);
    }

    public void unlockFolder(long repositoryId, long folderId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.unlockFolder(folderId, lockUuid);
    }

    public void unlockFolder(long repositoryId, long parentFolderId, String name, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        repository.unlockFolder(parentFolderId, name, lockUuid);
    }

    public void unsubscribeFileEntryType(long groupId, long fileEntryTypeId) throws PortalException {
        PortletResourcePermission portletResourcePermission = DLPortletResourcePermissionUtil.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.dlAppLocalService.unsubscribeFileEntryType(this.getUserId(), groupId, fileEntryTypeId);
    }

    public void unsubscribeFolder(long groupId, long folderId) throws PortalException {
        ModelResourcePermissionUtil.check((ModelResourcePermission)ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)Folder.class.getName()), (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)folderId, (String)"SUBSCRIBE");
        this.dlAppLocalService.unsubscribeFolder(this.getUserId(), groupId, folderId);
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, byte[] bytes, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry;
        File file = null;
        try {
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                file = FileUtil.createTempFile((byte[])bytes);
            }
            fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, displayDate, expirationDate, reviewDate, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, null, 0L, displayDate, expirationDate, reviewDate, serviceContext);
        }
        mimeType = DLAppUtil.getMimeType(sourceFileName, mimeType, title, file);
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, displayDate, expirationDate, reviewDate, serviceContext);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getLatestFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)mimeType) || mimeType.equals("application/octet-stream")) {
            if (size == 0L) {
                mimeType = MimeTypesUtil.getExtensionContentType((String)DLAppUtil.getExtension(title, sourceFileName));
            } else {
                File file = null;
                try {
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    FileEntry fileEntry = this.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, displayDate, expirationDate, reviewDate, serviceContext);
                    return fileEntry;
                }
                catch (IOException ioException) {
                    throw new SystemException("Unable to write temporary file", (Throwable)ioException);
                }
                finally {
                    FileUtil.delete((File)file);
                }
            }
        }
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        FileEntry fileEntry = repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getLatestFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntryAndCheckIn(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        if (file == null || !file.exists() || file.length() == 0L) {
            return this.updateFileEntryAndCheckIn(fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, null, 0L, displayDate, expirationDate, reviewDate, serviceContext);
        }
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        this._withDLAppHelperDisabled((UnsafeRunnable<PortalException>)((UnsafeRunnable)() -> repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, file, displayDate, expirationDate, reviewDate, serviceContext)));
        repository.checkInFileEntry(this.getUserId(), fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileEntry updateFileEntryAndCheckIn(long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date displayDate, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileEntryRepository((long)fileEntryId);
        this._withDLAppHelperDisabled((UnsafeRunnable<PortalException>)((UnsafeRunnable)() -> repository.updateFileEntry(this.getUserId(), fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, displayDate, expirationDate, reviewDate, serviceContext)));
        repository.checkInFileEntry(this.getUserId(), fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        FileEntry fileEntry = repository.getFileEntry(fileEntryId);
        this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), fileEntry, null, fileEntry.getFileVersion(), serviceContext);
        return fileEntry;
    }

    public FileShortcut updateFileShortcut(long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getFileShortcutRepository((long)fileShortcutId);
        return repository.updateFileShortcut(this.getUserId(), fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getFolderRepository(folderId, serviceContext.getScopeGroupId());
        Folder folder = repository.updateFolder(folderId, name, description, serviceContext);
        if (folderId != 0L) {
            this._dlAppHelperLocalService.updateFolder(this.getUserId(), folder, serviceContext);
        }
        return folder;
    }

    public boolean verifyFileEntryCheckOut(long repositoryId, long fileEntryId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyFileEntryLock(long repositoryId, long fileEntryId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.verifyFileEntryLock(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long repositoryId, long folderId, String lockUuid) throws PortalException {
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        return repository.verifyInheritableLock(folderId, lockUuid);
    }

    protected FileEntry copyFileEntry(com.liferay.portal.kernel.repository.Repository toRepository, FileEntry fileEntry, long targetFolderId, long fileEntryTypeId, long[] groupIds, ServiceContext serviceContext) throws PortalException {
        List fileVersions = fileEntry.getFileVersions(-1);
        FileVersion latestFileVersion = (FileVersion)fileVersions.get(fileVersions.size() - 1);
        String sourceFileName = DLAppUtil.getSourceFileName(latestFileVersion);
        DLValidatorUtil.validateFileSize((long)toRepository.getRepositoryId(), (String)sourceFileName, (String)latestFileVersion.getMimeType(), (long)latestFileVersion.getSize());
        this._populateServiceContext(serviceContext, DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId(), fileEntryTypeId, groupIds, toRepository.getRepositoryId());
        FileEntry targetFileEntry = toRepository.addFileEntry(null, this.getUserId(), targetFolderId, sourceFileName, latestFileVersion.getMimeType(), latestFileVersion.getTitle(), latestFileVersion.getTitle(), latestFileVersion.getDescription(), "", latestFileVersion.getContentStream(false), latestFileVersion.getSize(), latestFileVersion.getDisplayDate(), latestFileVersion.getExpirationDate(), latestFileVersion.getReviewDate(), serviceContext);
        for (RatingsEntry ratingsEntry : this._ratingsEntryLocalService.getEntries(DLFileEntryConstants.getClassName(), fileEntry.getFileEntryId())) {
            this._ratingsEntryLocalService.updateEntry(ratingsEntry.getUserId(), DLFileEntryConstants.getClassName(), targetFileEntry.getFileEntryId(), ratingsEntry.getScore(), serviceContext);
        }
        for (int i = fileVersions.size() - 2; i >= 0; --i) {
            FileVersion fileVersion = (FileVersion)fileVersions.get(i);
            sourceFileName = DLAppUtil.getSourceFileName(fileVersion);
            FileVersion previousFileVersion = (FileVersion)fileVersions.get(i + 1);
            try {
                targetFileEntry = toRepository.updateFileEntry(this.getUserId(), targetFileEntry.getFileEntryId(), sourceFileName, fileVersion.getMimeType(), fileVersion.getTitle(), fileVersion.getTitle(), fileVersion.getDescription(), "", DLVersionNumberIncrease.fromMajorVersion((boolean)DLAppUtil.isMajorVersion(previousFileVersion, fileVersion)), fileVersion.getContentStream(false), fileVersion.getSize(), fileVersion.getDisplayDate(), fileVersion.getExpirationDate(), fileVersion.getReviewDate(), serviceContext);
                FileVersion destinationFileVersion = targetFileEntry.getFileVersion();
                this._dlAppHelperLocalService.updateFileEntry(this.getUserId(), targetFileEntry, null, destinationFileVersion, serviceContext);
                continue;
            }
            catch (PortalException portalException) {
                toRepository.deleteFileEntry(targetFileEntry.getFileEntryId());
                throw portalException;
            }
        }
        this._copyResourcePermissions(fileEntry.getCompanyId(), DLFileEntry.class.getName(), fileEntry.getFileEntryId(), targetFileEntry.getFileEntryId());
        return targetFileEntry;
    }

    protected FileEntry copyFileEntry(com.liferay.portal.kernel.repository.Repository toRepository, FileEntry fileEntry, long targetFolderId, ServiceContext serviceContext) throws PortalException {
        return this.copyFileEntry(toRepository, fileEntry, targetFolderId, 0L, null, serviceContext);
    }

    protected Folder copyFolder(long sourceFolderId, long parentFolderId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, Map<Long, Long> fileEntryTypeIds, long[] groupIds, ServiceContext serviceContext) throws PortalException {
        Folder targetFolder = null;
        try {
            Folder sourceFolder = fromRepository.getFolder(sourceFolderId);
            targetFolder = toRepository.addFolder(null, this.getUserId(), parentFolderId, sourceFolder.getName(), sourceFolder.getDescription(), serviceContext);
            this._dlAppHelperLocalService.addFolder(this.getUserId(), targetFolder, serviceContext);
            for (RatingsEntry ratingsEntry : this._ratingsEntryLocalService.getEntries(DLFolderConstants.getClassName(), sourceFolder.getFolderId())) {
                this._ratingsEntryLocalService.updateEntry(ratingsEntry.getUserId(), DLFolderConstants.getClassName(), targetFolder.getFolderId(), ratingsEntry.getScore(), serviceContext);
            }
            this.copyFolderDependencies(sourceFolder, targetFolder, fromRepository, toRepository, fileEntryTypeIds, groupIds, serviceContext);
            return targetFolder;
        }
        catch (PortalException portalException) {
            if (targetFolder != null) {
                toRepository.deleteFolder(targetFolder.getFolderId());
            }
            throw portalException;
        }
    }

    protected void copyFolder(com.liferay.portal.kernel.repository.Repository repository, Folder sourceFolder, Folder targetFolder, ServiceContext serviceContext) throws PortalException {
        LinkedList<Folder[]> folders = new LinkedList<Folder[]>();
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        Folder curSourceFolder = sourceFolder;
        Folder curTargetFolder = targetFolder;
        while (true) {
            Object srcFileEntry2;
            List srcFileEntries = repository.getFileEntries(curSourceFolder.getFolderId(), -1, -1, null);
            for (Object srcFileEntry2 : srcFileEntries) {
                try {
                    FileEntry fileEntry = repository.copyFileEntry(this.getUserId(), curTargetFolder.getGroupId(), srcFileEntry2.getFileEntryId(), curTargetFolder.getFolderId(), serviceContext);
                    fileEntries.add(fileEntry);
                }
                catch (Exception exception) {
                    _log.error((Throwable)exception);
                }
            }
            List srcSubfolders = repository.getFolders(curSourceFolder.getFolderId(), false, -1, -1, null);
            srcFileEntry2 = srcSubfolders.iterator();
            while (srcFileEntry2.hasNext()) {
                Folder srcSubfolder = (Folder)srcFileEntry2.next();
                Folder destSubfolder = repository.addFolder(null, this.getUserId(), curTargetFolder.getFolderId(), srcSubfolder.getName(), srcSubfolder.getDescription(), serviceContext);
                this._dlAppHelperLocalService.addFolder(this.getUserId(), destSubfolder, serviceContext);
                folders.offer(new Folder[]{srcSubfolder, destSubfolder});
            }
            Folder[] next = (Folder[])folders.poll();
            if (next == null) break;
            curSourceFolder = next[0];
            curTargetFolder = next[1];
        }
        this._copyResourcePermissions(sourceFolder.getCompanyId(), DLFolder.class.getName(), sourceFolder.getFolderId(), targetFolder.getFolderId());
        TransactionCommitCallbackUtil.registerCallback(() -> {
            for (FileEntry fileEntry : fileEntries) {
                DLProcessorHelperUtil.trigger((FileEntry)fileEntry, null);
            }
            return null;
        });
    }

    protected void copyFolderDependencies(Folder sourceFolder, Folder targetFolder, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, Map<Long, Long> fileEntryTypeIds, long[] groupIds, ServiceContext serviceContext) throws PortalException {
        List repositoryEntries = fromRepository.getFoldersAndFileEntriesAndFileShortcuts(sourceFolder.getFolderId(), -1, true, -1, -1, null);
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            if (repositoryEntry instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)repositoryEntry;
                long[] assetCategoryIds = serviceContext.getAssetCategoryIds();
                String[] assetTagNames = serviceContext.getAssetTagNames();
                long fileEntryTypeId = ParamUtil.getLong((ServiceContext)serviceContext, (String)"fileEntryTypeId");
                this.copyFileEntry(toRepository, fileEntry, targetFolder.getFolderId(), (long)fileEntryTypeIds.getOrDefault(fileEntry.getFileEntryId(), 0L), groupIds, serviceContext);
                serviceContext.setAssetCategoryIds(assetCategoryIds);
                serviceContext.setAssetTagNames(assetTagNames);
                serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(fileEntryTypeId));
                continue;
            }
            if (repositoryEntry instanceof FileShortcut) {
                if (!targetFolder.isSupportsShortcuts()) continue;
                FileShortcut fileShortcut = (FileShortcut)repositoryEntry;
                toRepository.addFileShortcut(this.getUserId(), targetFolder.getFolderId(), fileShortcut.getToFileEntryId(), serviceContext);
                continue;
            }
            if (!(repositoryEntry instanceof Folder)) continue;
            Folder currentFolder = (Folder)repositoryEntry;
            Folder newFolder = toRepository.addFolder(null, this.getUserId(), targetFolder.getFolderId(), currentFolder.getName(), currentFolder.getDescription(), serviceContext);
            this._dlAppHelperLocalService.addFolder(this.getUserId(), newFolder, serviceContext);
            for (RatingsEntry ratingsEntry : this._ratingsEntryLocalService.getEntries(DLFolderConstants.getClassName(), currentFolder.getFolderId())) {
                this._ratingsEntryLocalService.updateEntry(ratingsEntry.getUserId(), DLFolderConstants.getClassName(), newFolder.getFolderId(), ratingsEntry.getScore(), serviceContext);
            }
            this.copyFolderDependencies(currentFolder, newFolder, fromRepository, toRepository, fileEntryTypeIds, groupIds, serviceContext);
        }
    }

    protected void deleteFileEntry(long oldFileEntryId, long newFileEntryId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository) throws PortalException {
        try {
            this._dlAppHelperLocalService.deleteFileEntry(fromRepository.getFileEntry(oldFileEntryId));
            fromRepository.deleteFileEntry(oldFileEntryId);
        }
        catch (PortalException portalException) {
            FileEntry fileEntry = toRepository.getFileEntry(newFileEntryId);
            toRepository.deleteFileEntry(newFileEntryId);
            this._dlAppHelperLocalService.deleteFileEntry(fileEntry);
            throw portalException;
        }
    }

    protected FileEntry fetchFileEntryByUuidAndRepositoryId(String uuid, long repositoryId) throws PortalException {
        try {
            com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
            return repository.getFileEntryByUuid(uuid);
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
            return null;
        }
        catch (RepositoryException repositoryException) {
            throw new NoSuchFileEntryException((Throwable)repositoryException);
        }
    }

    protected com.liferay.portal.kernel.repository.Repository getFolderRepository(long folderId, long groupId) throws PortalException {
        if (folderId == 0L) {
            return this.getRepository(groupId);
        }
        return RepositoryProviderUtil.getFolderRepository((long)folderId);
    }

    protected com.liferay.portal.kernel.repository.Repository getRepository(long repositoryId) throws PortalException {
        try {
            return RepositoryProviderUtil.getRepository((long)repositoryId);
        }
        catch (InvalidRepositoryIdException invalidRepositoryIdException) {
            throw new NoSuchGroupException(StringBundler.concat((Object[])new Object[]{"No Group exists with the key {repositoryId=", repositoryId, "}"}), (Throwable)invalidRepositoryIdException);
        }
    }

    protected FileEntry moveFileEntry(long fileEntryId, long newFolderId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, ServiceContext serviceContext) throws PortalException {
        FileEntry sourceFileEntry = fromRepository.getFileEntry(fileEntryId);
        if (sourceFileEntry.isCheckedOut()) {
            throw new FileEntryLockException.MustBeUnlocked();
        }
        FileEntry destinationFileEntry = this.copyFileEntry(toRepository, sourceFileEntry, newFolderId, serviceContext);
        this.deleteFileEntry(fileEntryId, destinationFileEntry.getFileEntryId(), fromRepository, toRepository);
        return destinationFileEntry;
    }

    protected Folder moveFolder(long folderId, long parentFolderId, com.liferay.portal.kernel.repository.Repository fromRepository, com.liferay.portal.kernel.repository.Repository toRepository, ServiceContext serviceContext) throws PortalException {
        Folder newFolder = this.copyFolder(folderId, parentFolderId, fromRepository, toRepository, new HashMap<Long, Long>(), null, serviceContext);
        fromRepository.deleteFolder(folderId);
        return newFolder;
    }

    private void _copyResourcePermissions(long companyId, String className, long sourceResourcePrimKey, long targetResourcePrimKey) throws PortalException {
        for (int scope : ResourceConstants.SCOPES) {
            this._resourcePermissionLocalService.deleteResourcePermissions(companyId, className, scope, targetResourcePrimKey);
        }
        this._resourcePermissionLocalService.copyModelResourcePermissions(companyId, className, sourceResourcePrimKey, targetResourcePrimKey);
    }

    private long[] _getAssetCategoryIds(String className, long classPK, long[] groupIds, long repositoryId) {
        long[] assetCategoryIds = this._assetCategoryLocalService.getCategoryIds(className, classPK);
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return assetCategoryIds;
        }
        HashSet<Long> allowedAssetCategoryIds = new HashSet<Long>();
        for (long assetCategoryId : assetCategoryIds) {
            if (!this._isAssetCategoryIdAllowed(assetCategoryId, repositoryId, groupIds)) continue;
            allowedAssetCategoryIds.add(assetCategoryId);
        }
        return ArrayUtil.toLongArray(allowedAssetCategoryIds);
    }

    private String[] _getAssetTagNames(String className, long classPK, long[] groupIds) {
        String[] assetTagNames = this._assetTagLocalService.getTagNames(className, classPK);
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return assetTagNames;
        }
        HashSet<String> allowedAssetTagNames = new HashSet<String>();
        for (String assetTagName : assetTagNames) {
            if (!this._isAssetTagNameAllowed(groupIds, assetTagName)) continue;
            allowedAssetTagNames.add(assetTagName);
        }
        return ArrayUtil.toStringArray(allowedAssetTagNames);
    }

    private boolean _isAssetCategoryIdAllowed(long categoryId, long groupId, long[] groupsIds) {
        AssetCategory assetCategory = this._assetCategoryLocalService.fetchCategory(categoryId);
        if (assetCategory == null || !ArrayUtil.contains((long[])groupsIds, (long)assetCategory.getGroupId())) {
            return false;
        }
        AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
        return assetVocabulary.getVisibilityType() != 1 || assetVocabulary.getGroupId() == groupId;
    }

    private boolean _isAssetTagNameAllowed(long[] groupIds, String tagName) {
        long[] lArray = groupIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long groupId = lArray[i];
            if (!this._assetTagLocalService.hasTag(groupId.longValue(), tagName)) continue;
            return true;
        }
        return false;
    }

    private void _populateServiceContext(ServiceContext serviceContext, String className, long classPK, long fileEntryTypeId, long[] groupIds, long repositoryId) {
        serviceContext.setAssetCategoryIds(this._getAssetCategoryIds(className, classPK, groupIds, repositoryId));
        serviceContext.setAssetTagNames(this._getAssetTagNames(className, classPK, groupIds));
        if (!Objects.equals(fileEntryTypeId, 0L)) {
            serviceContext.setAttribute("fileEntryTypeId", (Serializable)Long.valueOf(fileEntryTypeId));
        }
    }

    private void _validateFolders(long repositoryId, long sourceFolderId, long destinationParentFolderId) throws PortalException {
        if (sourceFolderId == destinationParentFolderId) {
            throw new InvalidFolderException(2, destinationParentFolderId);
        }
        com.liferay.portal.kernel.repository.Repository repository = this.getRepository(repositoryId);
        Folder folder = repository.getFolder(sourceFolderId);
        if (folder.getParentFolderId() == destinationParentFolderId) {
            throw new DuplicateFolderNameException();
        }
        List subfolderIds = repository.getSubfolderIds(sourceFolderId, true);
        if (subfolderIds.contains(destinationParentFolderId)) {
            throw new InvalidFolderException(1, destinationParentFolderId);
        }
    }

    private void _withDLAppHelperDisabled(UnsafeRunnable<PortalException> unsafeRunnable) throws PortalException {
        boolean enabled = DLAppHelperThreadLocal.isEnabled();
        try {
            DLAppHelperThreadLocal.setEnabled((boolean)false);
            unsafeRunnable.run();
        }
        finally {
            DLAppHelperThreadLocal.setEnabled((boolean)enabled);
        }
    }
}

