/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.sharepoint;

import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.sharepoint.BaseSharepointStorageImpl;
import com.liferay.portal.sharepoint.SharepointRequest;
import com.liferay.portal.sharepoint.SharepointUtil;
import com.liferay.portal.sharepoint.Tree;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class DLSharepointStorageImpl
extends BaseSharepointStorageImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLSharepointStorageImpl.class);

    @Override
    public void addDocumentElements(SharepointRequest sharepointRequest, Element element) throws Exception {
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        if (parentFolderId == 0L) {
            return;
        }
        List fileEntries = DLAppServiceUtil.getFileEntries((long)groupId, (long)parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            String documentPath = StringBundler.concat((String[])new String[]{parentFolderPath, "/", fileEntry.getTitle()});
            this.addDocumentElement(element, documentPath, fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getUserName());
        }
    }

    @Override
    public void createFolder(SharepointRequest sharepointRequest) throws Exception {
        String folderPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(folderPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String folderName = this.getResourceName(folderPath);
        String description = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        DLAppServiceUtil.addFolder(null, (long)groupId, (long)parentFolderId, (String)folderName, (String)description, (ServiceContext)serviceContext);
    }

    @Override
    public InputStream getDocumentInputStream(SharepointRequest sharepointRequest) throws Exception {
        FileEntry fileEntry = this.getFileEntry(sharepointRequest);
        return fileEntry.getContentStream();
    }

    @Override
    public Tree getDocumentsTree(SharepointRequest sharepointRequest) throws Exception {
        Tree documentsTree = new Tree();
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        List fileEntries = DLAppServiceUtil.getFileEntries((long)groupId, (long)parentFolderId);
        for (FileEntry fileEntry : fileEntries) {
            documentsTree.addChild(this.getFileEntryTree(fileEntry, parentFolderPath));
        }
        return documentsTree;
    }

    @Override
    public Tree getDocumentTree(SharepointRequest sharepointRequest) throws Exception {
        String documentPath = sharepointRequest.getRootPath();
        return this.getFileEntryTree(this.getFileEntry(sharepointRequest), this.getParentFolderPath(documentPath));
    }

    @Override
    public Tree getFoldersTree(SharepointRequest sharepointRequest) throws Exception {
        Tree foldersTree = new Tree();
        String parentFolderPath = sharepointRequest.getRootPath();
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        List folders = DLAppServiceUtil.getFolders((long)groupId, (long)parentFolderId, (boolean)false);
        for (Folder folder : folders) {
            foldersTree.addChild(this.getFolderTree(folder, parentFolderPath));
        }
        foldersTree.addChild(this.getFolderTree(parentFolderPath));
        return foldersTree;
    }

    @Override
    public Tree getFolderTree(SharepointRequest sharepointRequest) throws Exception {
        String folderPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(folderPath);
        long folderId = this.getLastFolderId(SharepointUtil.getGroupId(folderPath), folderPath, 0L);
        return this.getFolderTree(DLAppServiceUtil.getFolder((long)folderId), parentFolderPath);
    }

    @Override
    public void getParentFolderIds(long groupId, String path, List<Long> folderIds) throws Exception {
        String[] pathArray = SharepointUtil.getPathArray(path);
        if (pathArray.length == 0) {
            return;
        }
        long parentFolderId = folderIds.get(folderIds.size() - 1);
        Folder folder = DLAppServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)HttpComponentsUtil.decodePath((String)pathArray[0]));
        folderIds.add(folder.getFolderId());
        if (pathArray.length > 1) {
            path = this.removeFoldersFromPath(path, 1);
            this.getParentFolderIds(groupId, path, folderIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree[] moveDocument(SharepointRequest sharepointRequest) throws Exception {
        Tree movedDirsTree;
        Tree movedDocsTree;
        block12: {
            ServiceContext serviceContext;
            String newName;
            long newParentFolderId;
            String newParentFolderPath;
            Folder folder;
            block11: {
                FileEntry fileEntry;
                block10: {
                    String parentFolderPath = sharepointRequest.getRootPath();
                    long groupId = SharepointUtil.getGroupId(parentFolderPath);
                    folder = null;
                    fileEntry = null;
                    try {
                        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
                        folder = DLAppServiceUtil.getFolder((long)parentFolderId);
                    }
                    catch (Exception exception1) {
                        if (!(exception1 instanceof NoSuchFolderException)) break block10;
                        try {
                            fileEntry = this.getFileEntry(sharepointRequest);
                        }
                        catch (Exception exception2) {
                            if (!_log.isDebugEnabled()) break block10;
                            _log.debug((Throwable)exception2);
                        }
                    }
                }
                movedDocsTree = new Tree();
                movedDirsTree = new Tree();
                String newPath = sharepointRequest.getParameterValue("newUrl");
                newParentFolderPath = this.getParentFolderPath(newPath);
                long newGroupId = SharepointUtil.getGroupId(newParentFolderPath);
                newParentFolderId = this.getLastFolderId(newGroupId, newParentFolderPath, 0L);
                newName = this.getResourceName(newPath);
                serviceContext = new ServiceContext();
                if (fileEntry == null) break block11;
                File file = null;
                try {
                    long fileEntryId = fileEntry.getFileEntryId();
                    long folderId = fileEntry.getFolderId();
                    String mimeType = fileEntry.getMimeType();
                    String description = fileEntry.getDescription();
                    String changeLog = "";
                    InputStream inputStream = fileEntry.getContentStream();
                    file = FileUtil.createTempFile((InputStream)inputStream);
                    serviceContext.setAssetTagNames(AssetTagLocalServiceUtil.getTagNames((String)DLFileEntryConstants.getClassName(), (long)fileEntry.getFileEntryId()));
                    fileEntry = DLAppServiceUtil.updateFileEntry((long)fileEntryId, (String)newName, (String)mimeType, (String)newName, (String)"", (String)description, (String)changeLog, (DLVersionNumberIncrease)DLVersionNumberIncrease.fromMajorVersion((boolean)false), (File)file, (Date)fileEntry.getDisplayDate(), (Date)fileEntry.getExpirationDate(), (Date)fileEntry.getReviewDate(), (ServiceContext)serviceContext);
                    if (folderId != newParentFolderId) {
                        fileEntry = DLAppServiceUtil.moveFileEntry((long)fileEntryId, (long)newParentFolderId, (ServiceContext)serviceContext);
                    }
                    Tree documentTree = this.getFileEntryTree(fileEntry, newParentFolderPath);
                    movedDocsTree.addChild(documentTree);
                }
                catch (Throwable throwable) {
                    FileUtil.delete(file);
                    throw throwable;
                }
                FileUtil.delete((File)file);
                break block12;
            }
            if (folder != null) {
                long folderId = folder.getFolderId();
                String description = folder.getDescription();
                if (newParentFolderId != folder.getParentFolderId()) {
                    folder = DLAppServiceUtil.moveFolder((long)folderId, (long)newParentFolderId, (ServiceContext)serviceContext);
                }
                if (!newName.equals(folder.getName())) {
                    DLAppServiceUtil.updateFolder((long)folderId, (String)newName, (String)description, (ServiceContext)serviceContext);
                }
                movedDirsTree.addChild(this.getFolderTree(folder, newParentFolderPath));
            }
        }
        return new Tree[]{movedDocsTree, movedDirsTree};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putDocument(SharepointRequest sharepointRequest) throws Exception {
        HttpServletRequest httpServletRequest = sharepointRequest.getHttpServletRequest();
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String title = this.getResourceName(documentPath);
        String description = "";
        String changeLog = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        String contentType = GetterUtil.get((String)httpServletRequest.getHeader("Content-Type"), (String)"application/octet-stream");
        String extension = FileUtil.getExtension((String)title);
        File file = null;
        try {
            file = FileUtil.createTempFile((String)extension);
            FileUtil.write((File)file, (byte[])sharepointRequest.getBytes());
            if (contentType.equals("application/octet-stream")) {
                contentType = MimeTypesUtil.getContentType((File)file, (String)title);
            }
            try {
                FileEntry fileEntry = this.getFileEntry(sharepointRequest);
                description = fileEntry.getDescription();
                serviceContext.setAssetTagNames(AssetTagLocalServiceUtil.getTagNames((String)DLFileEntryConstants.getClassName(), (long)fileEntry.getFileEntryId()));
                DLAppServiceUtil.updateFileEntry((long)fileEntry.getFileEntryId(), (String)title, (String)contentType, (String)title, (String)"", (String)description, (String)changeLog, (DLVersionNumberIncrease)DLVersionNumberIncrease.fromMajorVersion((boolean)false), (File)file, (Date)fileEntry.getDisplayDate(), (Date)fileEntry.getExpirationDate(), (Date)fileEntry.getReviewDate(), (ServiceContext)serviceContext);
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchFileEntryException);
                }
                DLAppServiceUtil.addFileEntry(null, (long)groupId, (long)parentFolderId, (String)title, (String)contentType, null, null, (String)description, (String)changeLog, (File)file, null, null, null, (ServiceContext)serviceContext);
            }
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    @Override
    public Tree[] removeDocument(SharepointRequest sharepointRequest) {
        Tree failedDirsTree;
        Tree removedDirsTree;
        Tree failedDocsTree;
        Tree removedDocsTree;
        block18: {
            FileEntry fileEntry;
            Folder folder;
            String parentFolderPath;
            block17: {
                parentFolderPath = sharepointRequest.getRootPath();
                long groupId = SharepointUtil.getGroupId(parentFolderPath);
                folder = null;
                fileEntry = null;
                try {
                    long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
                    folder = DLAppServiceUtil.getFolder((long)parentFolderId);
                }
                catch (Exception exception1) {
                    if (!(exception1 instanceof NoSuchFolderException)) break block17;
                    try {
                        fileEntry = this.getFileEntry(sharepointRequest);
                    }
                    catch (Exception exception2) {
                        if (!_log.isDebugEnabled()) break block17;
                        _log.debug((Throwable)exception2);
                    }
                }
            }
            removedDocsTree = new Tree();
            failedDocsTree = new Tree();
            removedDirsTree = new Tree();
            failedDirsTree = new Tree();
            if (fileEntry != null) {
                Tree documentTree = new Tree();
                try {
                    documentTree = this.getFileEntryTree(fileEntry, parentFolderPath);
                    DLAppServiceUtil.deleteFileEntry((long)fileEntry.getFileEntryId());
                    removedDocsTree.addChild(documentTree);
                }
                catch (Exception exception1) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception1);
                    }
                    try {
                        failedDocsTree.addChild(documentTree);
                        break block18;
                    }
                    catch (Exception exception2) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)exception2);
                        }
                        break block18;
                    }
                }
            }
            if (folder != null) {
                Tree folderTree = new Tree();
                try {
                    folderTree = this.getFolderTree(folder, parentFolderPath);
                    DLAppServiceUtil.deleteFolder((long)folder.getFolderId());
                    removedDirsTree.addChild(folderTree);
                }
                catch (Exception exception1) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception1);
                    }
                    try {
                        failedDirsTree.addChild(folderTree);
                    }
                    catch (Exception exception2) {
                        if (!_log.isDebugEnabled()) break block18;
                        _log.debug((Throwable)exception2);
                    }
                }
            }
        }
        return new Tree[]{removedDocsTree, removedDirsTree, failedDocsTree, failedDirsTree};
    }

    protected FileEntry getFileEntry(SharepointRequest sharepointRequest) throws Exception {
        String documentPath = sharepointRequest.getRootPath();
        String parentFolderPath = this.getParentFolderPath(documentPath);
        long groupId = SharepointUtil.getGroupId(parentFolderPath);
        long parentFolderId = this.getLastFolderId(groupId, parentFolderPath, 0L);
        String title = this.getResourceName(documentPath);
        return DLAppServiceUtil.getFileEntry((long)groupId, (long)parentFolderId, (String)title);
    }

    protected Tree getFileEntryTree(FileEntry fileEntry, String parentFolderPath) {
        String documentPath = StringBundler.concat((String[])new String[]{parentFolderPath, "/", fileEntry.getTitle()});
        return this.getDocumentTree(documentPath, fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize(), fileEntry.getUserName(), fileEntry.getVersion());
    }

    protected Tree getFolderTree(Folder folder, String parentFolderPath) {
        String folderPath = StringBundler.concat((String[])new String[]{parentFolderPath, "/", folder.getName()});
        return this.getFolderTree(folderPath, folder.getCreateDate(), folder.getModifiedDate(), folder.getLastPostDate());
    }
}

