/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletConfigFactory;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portlet.PortletContextFactoryUtil;
import com.liferay.portlet.internal.PortletConfigImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PortletConfigFactoryImpl
implements PortletConfigFactory {
    private final Map<String, Map<String, PortletConfig>> _pool = new ConcurrentHashMap<String, Map<String, PortletConfig>>();

    public PortletConfig create(Portlet portlet, ServletContext servletContext) {
        Object portletConfig;
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            portletConfigs = new ConcurrentHashMap<String, PortletConfig>();
            this._pool.put(portlet.getRootPortletId(), portletConfigs);
        }
        if ((portletConfig = portletConfigs.get(portlet.getPortletId())) == null || !this._isSamePortletDeployedStatus(portlet, (PortletConfig)portletConfig)) {
            PortletContext portletContext = PortletContextFactoryUtil.create(portlet, servletContext);
            portletConfig = new PortletConfigImpl(portlet, portletContext);
            portletConfigs.put(portlet.getPortletId(), (PortletConfig)portletConfig);
        }
        return portletConfig;
    }

    public void destroy(Portlet portlet) {
        this._pool.remove(portlet.getRootPortletId());
    }

    public PortletConfig get(Portlet portlet) {
        return this.get(portlet.getPortletId());
    }

    public PortletConfig get(String portletId) {
        String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
        Map<String, PortletConfig> portletConfigs = this._pool.get(rootPortletId);
        if (portletConfigs == null) {
            return null;
        }
        return portletConfigs.get(portletId);
    }

    public PortletConfig update(Portlet portlet) {
        Map<String, PortletConfig> portletConfigs = this._pool.get(portlet.getRootPortletId());
        if (portletConfigs == null) {
            return null;
        }
        Object portletConfig = portletConfigs.get(portlet.getPortletId());
        portletConfig = new PortletConfigImpl(portlet, portletConfig.getPortletContext());
        portletConfigs.put(portlet.getPortletId(), (PortletConfig)portletConfig);
        return portletConfig;
    }

    private boolean _isSamePortletDeployedStatus(Portlet portlet, PortletConfig portletConfig) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        Portlet existingPortlet = liferayPortletConfig.getPortlet();
        return existingPortlet != null && portlet.isUndeployedPortlet() == existingPortlet.isUndeployedPortlet();
    }
}

