/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portlet.ratings.service.base.RatingsEntryLocalServiceBaseImpl;
import com.liferay.ratings.kernel.exception.EntryScoreException;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.model.RatingsStats;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.ratings.kernel.service.persistence.RatingsStatsPersistence;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RatingsEntryLocalServiceImpl
extends RatingsEntryLocalServiceBaseImpl {
    @BeanReference(type=AssetEntryLocalService.class)
    private AssetEntryLocalService _assetEntryLocalService;
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;
    @BeanReference(type=RatingsStatsLocalService.class)
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @BeanReference(type=RatingsStatsPersistence.class)
    private RatingsStatsPersistence _ratingsStatsPersistence;
    @BeanReference(type=UserPersistence.class)
    private UserPersistence _userPersistence;

    public void deleteEntry(long userId, String className, long classPK) throws PortalException {
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, this._classNameLocalService.getClassNameId(className), classPK);
        this.ratingsEntryLocalService.deleteEntry(entry, userId, className, classPK);
    }

    @SystemEvent(type=1)
    public void deleteEntry(RatingsEntry entry, long userId, String className, long classPK) throws PortalException {
        if (entry == null) {
            return;
        }
        this.ratingsEntryPersistence.removeByU_C_C(userId, this._classNameLocalService.getClassNameId(className), classPK);
        RatingsStats stats = this._ratingsStatsLocalService.getStats(className, classPK);
        int totalEntries = stats.getTotalEntries() - 1;
        if (totalEntries == 0) {
            this._ratingsStatsPersistence.remove((BaseModel)stats);
        } else {
            double oldScore = entry.getScore();
            double totalScore = stats.getTotalScore() - oldScore;
            double averageScore = 0.0;
            if (totalEntries > 0) {
                averageScore = totalScore / (double)totalEntries;
            }
            stats.setTotalEntries(totalEntries);
            stats.setTotalScore(totalScore);
            stats.setAverageScore(averageScore);
            this._ratingsStatsPersistence.update((BaseModel)stats);
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry != null) {
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)assetEntry, (int)10011, (String)extraDataJSONObject.toString(), (long)0L);
        }
    }

    public RatingsEntry fetchEntry(long userId, String className, long classPK) {
        return this.ratingsEntryPersistence.fetchByU_C_C(userId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public Map<Long, RatingsEntry> getEntries(long userId, String className, long[] classPKs) {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        HashMap<Long, RatingsEntry> ratingsEntries = new HashMap<Long, RatingsEntry>();
        for (RatingsEntry entry : this.ratingsEntryPersistence.findByU_C_C(userId, classNameId, classPKs)) {
            ratingsEntries.put(entry.getClassPK(), entry);
        }
        return ratingsEntries;
    }

    public List<RatingsEntry> getEntries(String className, long classPK) {
        return this.ratingsEntryPersistence.findByC_C(this._classNameLocalService.getClassNameId(className), classPK);
    }

    public List<RatingsEntry> getEntries(String className, long classPK, double score) {
        return this.ratingsEntryPersistence.findByC_C_S(this._classNameLocalService.getClassNameId(className), classPK, score);
    }

    public int getEntriesCount(String className, long classPK, double score) {
        return this.ratingsEntryPersistence.countByC_C_S(this._classNameLocalService.getClassNameId(className), classPK, score);
    }

    public RatingsEntry getEntry(long userId, String className, long classPK) throws PortalException {
        return this.ratingsEntryPersistence.findByU_C_C(userId, this._classNameLocalService.getClassNameId(className), classPK);
    }

    public RatingsEntry updateEntry(long userId, String className, long classPK, double score, ServiceContext serviceContext) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        this.validate(score);
        RatingsEntry entry = this.ratingsEntryPersistence.fetchByU_C_C(userId, classNameId, classPK);
        if (entry != null) {
            double oldScore = entry.getScore();
            entry.setScore(score);
            entry = (RatingsEntry)this.ratingsEntryPersistence.update((BaseModel)entry);
            RatingsStats stats = this._ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
            if (stats == null) {
                stats = this._ratingsStatsLocalService.addStats(classNameId, classPK);
            }
            stats.setModifiedDate(new Date());
            stats.setTotalScore(stats.getTotalScore() - oldScore + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this._ratingsStatsPersistence.update((BaseModel)stats);
        } else {
            User user = this._userPersistence.findByPrimaryKey(userId);
            long entryId = this.counterLocalService.increment();
            entry = this.ratingsEntryPersistence.create(entryId);
            entry.setCompanyId(user.getCompanyId());
            entry.setUserId(user.getUserId());
            entry.setUserName(user.getFullName());
            entry.setClassNameId(classNameId);
            entry.setClassPK(classPK);
            entry.setScore(score);
            entry = (RatingsEntry)this.ratingsEntryPersistence.update((BaseModel)entry);
            RatingsStats stats = this._ratingsStatsPersistence.fetchByC_C(classNameId, classPK);
            if (stats == null) {
                stats = this._ratingsStatsLocalService.addStats(classNameId, classPK);
            }
            stats.setModifiedDate(new Date());
            stats.setTotalEntries(stats.getTotalEntries() + 1);
            stats.setTotalScore(stats.getTotalScore() + score);
            stats.setAverageScore(stats.getTotalScore() / (double)stats.getTotalEntries());
            this._ratingsStatsPersistence.update((BaseModel)stats);
        }
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK);
        if (assetEntry != null) {
            JSONObject extraDataJSONObject = JSONUtil.put((String)"title", (Object)assetEntry.getTitle());
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)assetEntry, (int)10004, (String)extraDataJSONObject.toString(), (long)0L);
        }
        return entry;
    }

    protected void validate(double score) throws PortalException {
        if (score > 1.0 || score < 0.0) {
            throw new EntryScoreException("Score " + score + " is not a value between 0 and 1");
        }
    }
}

