/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgreSQLDB
extends BaseDB {
    private static final String[] _POSTGRESQL = new String[]{"--", "true", "false", "'01/01/1970'", "current_timestamp", " oid", " bytea", " decimal(30, 16)", " bool", " timestamp", " double precision", " integer", " bigint", " text", " text", " varchar", "", "commit"};
    private static final int[] _SQL_TYPES = new int[]{-5, -2, 2, -7, 93, 8, 4, -5, 12, 12, 12};
    private static final Pattern _oidPattern = Pattern.compile(" oid(\\W|$)", 2);
    private final boolean _supportsNewUuidFunction;

    public static String getCreateRulesSQL(String tableName, String columnName) {
        return StringBundler.concat((String[])new String[]{"create or replace rule delete_", tableName, "_", columnName, " as on delete to ", tableName, " do also select case when exists(select 1 from ", "pg_catalog.pg_largeobject_metadata where (oid = old.", columnName, ")) then lo_unlink(old.", columnName, ") end from ", tableName, " where ", tableName, ".", columnName, " = old.", columnName, ";\ncreate or replace rule update_", tableName, "_", columnName, " as on update to ", tableName, " where old.", columnName, " is distinct from new.", columnName, " and old.", columnName, " is not null do also select case when exists(select 1 from ", "pg_catalog.pg_largeobject_metadata where (oid = old.", columnName, ")) then lo_unlink(old.", columnName, ") end from ", tableName, " where ", tableName, ".", columnName, " = old.", columnName, ";"});
    }

    public PostgreSQLDB(int majorVersion, int minorVersion) {
        super(DBType.POSTGRESQL, majorVersion, minorVersion);
        this._supportsNewUuidFunction = majorVersion >= 13;
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.replaceTemplate(template);
        template = this.reword(template);
        return template;
    }

    @Override
    public List<Index> getIndexes(Connection connection) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        String sql = StringBundler.concat((String[])new String[]{"select pg_indexes.indexname, pg_indexes.tablename, ", "pg_index.indisunique from pg_indexes, pg_index, pg_class where ", "pg_indexes.schemaname = current_schema() and ", "(pg_indexes.indexname like 'liferay_%' or pg_indexes.indexname ", "like 'ix_%') and pg_class.relname = pg_indexes.indexname and ", "pg_index.indexrelid = pg_class.oid"});
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String indexName = resultSet.getString("indexname");
                String tableName = resultSet.getString("tablename");
                boolean unique = resultSet.getBoolean("indisunique");
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        return indexes;
    }

    public String getNewUuidFunctionName() {
        return "gen_random_uuid()";
    }

    public String getPopulateSQL(String databaseName, String sqlContent) {
        return StringBundler.concat((String[])new String[]{"\\c ", databaseName, ";\n\n", sqlContent});
    }

    public String getRecreateSQL(String databaseName) {
        return StringBundler.concat((String[])new String[]{"drop database ", databaseName, ";\n", "create database ", databaseName, " encoding = 'UNICODE';\n"});
    }

    @Override
    public boolean isSupportsDBPartition() {
        return true;
    }

    public boolean isSupportsNewUuidFunction() {
        return this._supportsNewUuidFunction;
    }

    @Override
    public boolean isSupportsQueryingAfterException() {
        return false;
    }

    @Override
    protected void createSyncDeleteTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("delete from ");
        sb.append(targetTableName);
        sb.append(" where ");
        for (int i = 0; i < sourcePrimaryKeyColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(targetPrimaryKeyColumnNames[i]);
            sb.append(" = old.");
            sb.append(sourcePrimaryKeyColumnNames[i]);
        }
        this._createTriggerFunction(connection, triggerName, sb.toString());
        this._createTrigger(connection, sourceTableName, "after delete", triggerName);
    }

    @Override
    protected void createSyncInsertTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourceColumnNames, String[] targetColumnNames, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames, Map<String, String> defaultValuesMap) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("insert into ");
        sb.append(targetTableName);
        sb.append(" (");
        sb.append(StringUtil.merge((Object[])targetColumnNames, (String)", "));
        sb.append(") values (");
        for (int i = 0; i < sourceColumnNames.length; ++i) {
            String defaultValue;
            if (i > 0) {
                sb.append(", ");
            }
            if ((defaultValue = defaultValuesMap.get(targetColumnNames[i])) != null) {
                sb.append("COALESCE(");
            }
            sb.append("new.");
            sb.append(sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(")");
        this._createTriggerFunction(connection, triggerName, sb.toString());
        this._createTrigger(connection, sourceTableName, "after insert", triggerName);
    }

    @Override
    protected void createSyncUpdateTrigger(Connection connection, String sourceTableName, String targetTableName, String triggerName, String[] sourceColumnNames, String[] targetColumnNames, String[] sourcePrimaryKeyColumnNames, String[] targetPrimaryKeyColumnNames, Map<String, String> defaultValuesMap) throws Exception {
        int i;
        StringBundler sb = new StringBundler();
        sb.append("update ");
        sb.append(targetTableName);
        sb.append(" set ");
        for (i = 0; i < sourceColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(targetColumnNames[i]);
            sb.append(" = ");
            String defaultValue = defaultValuesMap.get(targetColumnNames[i]);
            if (defaultValue != null) {
                sb.append("COALESCE(");
            }
            sb.append("new.");
            sb.append(sourceColumnNames[i]);
            if (defaultValue == null) continue;
            sb.append(", ");
            sb.append(defaultValue);
            sb.append(")");
        }
        sb.append(" where ");
        for (i = 0; i < sourcePrimaryKeyColumnNames.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(targetPrimaryKeyColumnNames[i]);
            sb.append(" = old.");
            sb.append(sourcePrimaryKeyColumnNames[i]);
        }
        this._createTriggerFunction(connection, triggerName, sb.toString());
        this._createTrigger(connection, sourceTableName, "after update", triggerName);
    }

    @Override
    protected void dropTrigger(Connection connection, String tableName, String triggerName) throws Exception {
        this.runSQL(connection, StringBundler.concat((String[])new String[]{"drop trigger ", triggerName, " on ", tableName}));
        this.runSQL(connection, "drop function " + triggerName);
    }

    @Override
    protected String getCopyTableStructureSQL(String tableName, String newTableName) {
        return StringBundler.concat((String[])new String[]{"create table ", newTableName, " (like ", tableName, " including all excluding indexes)"});
    }

    @Override
    protected int[] getSQLTypes() {
        return _SQL_TYPES;
    }

    @Override
    protected Map<String, Integer> getSQLVarcharSizes() {
        return HashMapBuilder.put((Object)"STRING", (Object)Integer.MAX_VALUE).put((Object)"TEXT", (Object)Integer.MAX_VALUE).build();
    }

    @Override
    protected String[] getTemplate() {
        return _POSTGRESQL;
    }

    @Override
    protected boolean isSupportsDuplicatedIndexName() {
        return false;
    }

    @Override
    protected String limitColumnLength(String column, int length) {
        return StringBundler.concat((Object[])new Object[]{"left(", column, ", ", length, ")"});
    }

    @Override
    protected String reword(String data) throws IOException {
        if (Validator.isNull((String)data)) {
            return null;
        }
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            StringBundler createRulesSQLSB = new StringBundler();
            String line = null;
            String tableName = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String[] tokens;
                String[] template;
                if (line.startsWith("alter_column_name ")) {
                    template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ rename @old-column@ to @new-column@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ alter @old-column@ type @type@ using @old-column@::@type@;", (String[])REWORD_TEMPLATE, (String[])template);
                    String defaultValue = template[template.length - 2];
                    line = !Validator.isBlank((String)defaultValue) ? line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set default @default@;", (String[])REWORD_TEMPLATE, (String[])template)) : line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ drop default;", (String[])REWORD_TEMPLATE, (String[])template));
                    String nullable = template[template.length - 1];
                    line = Objects.equals(nullable, "not null") ? line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ set not null;", (String[])REWORD_TEMPLATE, (String[])template)) : line.concat(StringUtil.replace((String)"alter table @table@ alter column @old-column@ drop not null;", (String[])REWORD_TEMPLATE, (String[])template));
                } else if (line.startsWith("alter_table_name ")) {
                    template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)StringBundler.concat((String[])new String[]{"alter table @old-table@ rename to @new-table@;", "alter table @new-table@ rename constraint ", "@old-table@_pkey to @new-table@_pkey;"}), (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                } else if (line.startsWith("create table ")) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    tableName = tokens[2];
                } else if (line.contains("drop index")) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"drop index @index@;", (String)"@index@", (String)tokens[2]);
                } else if (line.contains("drop primary key")) {
                    tokens = StringUtil.split((String)line, (char)' ');
                    line = StringUtil.replace((String)"alter table @table@ drop constraint @table@_pkey;", (String)"@table@", (String)tokens[2]);
                } else if (line.contains(this.getTemplateBlob())) {
                    Matcher matcher = _oidPattern.matcher(line);
                    if (matcher.find()) {
                        String[] tokens2 = StringUtil.split((String)line, (char)' ');
                        createRulesSQLSB.append("\n");
                        createRulesSQLSB.append(PostgreSQLDB.getCreateRulesSQL(tableName, tokens2[0]));
                    }
                } else if (line.contains("\\'")) {
                    line = StringUtil.replace((String)line, (String)"\\'", (String)"''");
                }
                sb.append(line);
                sb.append("\n");
            }
            sb.append(createRulesSQLSB.toString());
            String string = sb.toString();
            return string;
        }
    }

    private void _createTrigger(Connection connection, String tableName, String triggerEvent, String triggerName) throws Exception {
        this.runSQL(connection, StringBundler.concat((String[])new String[]{"create trigger ", triggerName, " ", triggerEvent, " on ", tableName, " for each row execute procedure ", triggerName, "()"}));
    }

    private void _createTriggerFunction(Connection connection, String functionName, String functionStatement) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("create function ");
        sb.append(functionName);
        sb.append("() returns trigger language plpgsql as $$ begin ");
        sb.append(functionStatement);
        sb.append("; return null; end; $$");
        this.runSQL(connection, sb.toString());
    }
}

