/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.spring.hibernate.SpringHibernateThreadLocalUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DynamicDataSource
implements DataSource {
    private static final Log _log = LogFactoryUtil.getLog(DynamicDataSource.class);
    private final DataSource _readDataSource;
    private final DataSource _writeDataSource;

    public DynamicDataSource(DataSource readDataSource, DataSource writeDataSource) {
        this._readDataSource = readDataSource;
        this._writeDataSource = writeDataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        DataSource dataSource = this._getDataSource();
        return dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        DataSource dataSource = this._getDataSource();
        return dataSource.getConnection(userName, password);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        DataSource dataSource = this._getDataSource();
        return dataSource.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        DataSource dataSource = this._getDataSource();
        return dataSource.getLogWriter();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        DataSource dataSource = this._getDataSource();
        return dataSource.getParentLogger();
    }

    public DataSource getReadDataSource() {
        return this._readDataSource;
    }

    public DataSource getWriteDataSource() {
        return this._writeDataSource;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        DataSource dataSource = this._getDataSource();
        return dataSource.isWrapperFor(clazz);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DataSource dataSource = this._getDataSource();
        dataSource.setLoginTimeout(seconds);
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        DataSource dataSource = this._getDataSource();
        dataSource.setLogWriter(printWriter);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        DataSource dataSource = this._getDataSource();
        return dataSource.unwrap(clazz);
    }

    private DataSource _getDataSource() {
        if (SpringHibernateThreadLocalUtil.isCurrentTransactionReadOnly()) {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"Returning read data source");
            }
            return this._readDataSource;
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)"Returning write data source");
        }
        return this._writeDataSource;
    }
}

