/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.common;

import com.liferay.portal.dao.sql.transformer.HQLToJPQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.JPQLToHQLTransformerLogic;
import com.liferay.portal.dao.sql.transformer.SQLTransformerFactory;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import java.io.Serializable;
import java.util.function.Function;

public class SQLTransformer {
    private static final SQLTransformer _instance = new SQLTransformer();
    private com.liferay.portal.dao.sql.transformer.SQLTransformer _sqlTransformer;
    private PortalCache<String, String> _transformedSQLsPortalCache;

    public static void reloadSQLTransformer() {
        _instance._reloadSQLTransformer();
    }

    public static String transform(String sql) {
        com.liferay.portal.dao.sql.transformer.SQLTransformer sqlTransformer = _instance._getSQLTransformer();
        return sqlTransformer.transform(sql);
    }

    public static String transformFromHQLToJQPL(String sql) {
        return _instance._transformFromHQLToJPQL(sql);
    }

    public static String transformFromJPQLToHQL(String sql) {
        return _instance._transformFromJPQLToHQL(sql);
    }

    private SQLTransformer() {
        this._reloadSQLTransformer();
    }

    private com.liferay.portal.dao.sql.transformer.SQLTransformer _getSQLTransformer() {
        return this._sqlTransformer;
    }

    private void _reloadSQLTransformer() {
        if (this._transformedSQLsPortalCache == null) {
            this._transformedSQLsPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)SQLTransformer.class.getName());
        } else {
            this._transformedSQLsPortalCache.removeAll();
        }
        this._sqlTransformer = SQLTransformerFactory.getSQLTransformer(DBManagerUtil.getDB());
    }

    private String _transformFromHQLToJPQL(String sql) {
        Function[] functions;
        String newSQL = (String)this._transformedSQLsPortalCache.get((Serializable)((Object)sql));
        if (newSQL != null) {
            return newSQL;
        }
        newSQL = this._sqlTransformer.transform(sql);
        for (Function function : functions = new Function[]{HQLToJPQLTransformerLogic.getPositionalParameterFunction(), HQLToJPQLTransformerLogic.getNotEqualsFunction(), HQLToJPQLTransformerLogic.getCompositeIdMarkerFunction()}) {
            newSQL = (String)function.apply(newSQL);
        }
        this._transformedSQLsPortalCache.put((Serializable)((Object)sql), (Object)newSQL);
        return newSQL;
    }

    private String _transformFromJPQLToHQL(String sql) {
        String newSQL = (String)this._transformedSQLsPortalCache.get((Serializable)((Object)sql));
        if (newSQL != null) {
            return newSQL;
        }
        newSQL = this._sqlTransformer.transform(sql);
        Function<String, String> countFunction = JPQLToHQLTransformerLogic.getCountFunction();
        newSQL = countFunction.apply(newSQL);
        this._transformedSQLsPortalCache.put((Serializable)((Object)sql), (Object)newSQL);
        return newSQL;
    }
}

