/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.PropertyAccessException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class MethodPropertyAccessor
implements PropertyAccessStrategy {
    private static final Map<String, PropertyAccess> _propertyAccesses = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);

    public PropertyAccess buildPropertyAccess(Class clazz, String propertyName) {
        String key = StringBundler.concat((Object[])new Object[]{clazz.hashCode(), "#", clazz.getName(), "#", propertyName});
        PropertyAccess propertyAccess = _propertyAccesses.get(key);
        if (propertyAccess == null) {
            propertyAccess = new MethodPropertyAccess(this, clazz, propertyName);
            _propertyAccesses.put(key, propertyAccess);
        }
        return propertyAccess;
    }

    private static class MethodPropertySetter
    implements Setter {
        private final MethodHolder _methodHolder;

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public void set(Object target, Object value, SessionFactoryImplementor sessionFactoryImplementor) throws PropertyAccessException {
            try {
                Method setterMethod = this._methodHolder.getSetterMethod();
                setterMethod.invoke(target, value);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                ReflectionUtil.throwException((Throwable)reflectiveOperationException);
            }
        }

        private MethodPropertySetter(MethodHolder methodHolder) {
            this._methodHolder = methodHolder;
        }
    }

    private static class MethodPropertyGetter
    implements Getter {
        private final MethodHolder _methodHolder;

        public Object get(Object target) {
            try {
                Method getterMethod = this._methodHolder.getGetterMethod();
                return getterMethod.invoke(target, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return ReflectionUtil.throwException((Throwable)reflectiveOperationException);
            }
        }

        public Object getForInsert(Object target, Map mergeMap, SharedSessionContractImplementor sharedSessionContractImplementor) {
            return this.get(target);
        }

        public Member getMember() {
            return null;
        }

        public Method getMethod() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Class getReturnType() {
            Method getterMethod = this._methodHolder.getGetterMethod();
            return getterMethod.getReturnType();
        }

        private MethodPropertyGetter(MethodHolder methodHolder) {
            this._methodHolder = methodHolder;
        }
    }

    private static class MethodPropertyAccess
    implements PropertyAccess {
        private final Getter _getter;
        private final PropertyAccessStrategy _propertyAccessStrategy;
        private final Setter _setter;

        public Getter getGetter() {
            return this._getter;
        }

        public PropertyAccessStrategy getPropertyAccessStrategy() {
            return this._propertyAccessStrategy;
        }

        public Setter getSetter() {
            return this._setter;
        }

        private MethodPropertyAccess(PropertyAccessStrategy propertyAccessStrategy, Class<?> clazz, String propertyName) {
            this._propertyAccessStrategy = propertyAccessStrategy;
            MethodHolder methodHolder = new MethodHolder(clazz, propertyName);
            this._getter = new MethodPropertyGetter(methodHolder);
            this._setter = new MethodPropertySetter(methodHolder);
        }
    }

    private static class MethodHolder {
        private final Class<?> _clazz;
        private Method _getterMethod;
        private final String _propertyName;
        private Method _setterMethod;

        public Method getGetterMethod() {
            if (this._getterMethod == null) {
                this._initialize();
            }
            return this._getterMethod;
        }

        public Method getSetterMethod() {
            if (this._setterMethod == null) {
                this._initialize();
            }
            return this._setterMethod;
        }

        private MethodHolder(Class<?> clazz, String propertyName) {
            this._clazz = clazz;
            this._propertyName = propertyName;
        }

        private String _getMethodName1() {
            StringBuilder sb = new StringBuilder(this._propertyName);
            char c = sb.charAt(0);
            if (c >= 'a' && c <= 'z') {
                sb.setCharAt(0, (char)(c - 32));
            }
            return sb.toString();
        }

        private String _getMethodName2() {
            char c;
            StringBuilder sb = new StringBuilder(this._propertyName);
            for (int i = 0; i < sb.length() && (c = sb.charAt(i)) >= 'a' && c <= 'z'; ++i) {
                sb.setCharAt(i, (char)(c - 32));
            }
            return sb.toString();
        }

        private void _initialize() {
            try {
                String methodName1 = this._getMethodName1();
                this._getterMethod = this._clazz.getMethod("get".concat(methodName1), new Class[0]);
                this._getterMethod.setAccessible(true);
                this._setterMethod = this._clazz.getMethod("set".concat(methodName1), this._getterMethod.getReturnType());
                this._setterMethod.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException1) {
                try {
                    String methodName2 = this._getMethodName2();
                    this._getterMethod = this._clazz.getMethod("get".concat(methodName2), new Class[0]);
                    this._getterMethod.setAccessible(true);
                    this._setterMethod = this._clazz.getMethod("set".concat(methodName2), this._getterMethod.getReturnType());
                    this._setterMethod.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    noSuchMethodException2.addSuppressed(noSuchMethodException1);
                    ReflectionUtil.throwException((Throwable)noSuchMethodException2);
                }
            }
        }
    }
}

