/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.dao.orm.hibernate.DialectImpl;
import com.liferay.portal.dao.orm.hibernate.SessionImpl;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionCustomizer;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PreloadClassLoader;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.osgi.framework.BundleContext;

public class SessionFactoryImpl
implements SessionFactory {
    private static final String[] _PRELOAD_CLASS_NAMES = PropsValues.SPRING_HIBERNATE_SESSION_FACTORY_PRELOAD_CLASSLOADER_CLASSES;
    private static final Log _log = LogFactoryUtil.getLog(SessionFactoryImpl.class);
    private final ServiceTrackerList<SessionCustomizer> _sessionCustomizers = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), SessionCustomizer.class);
    private ClassLoader _sessionFactoryClassLoader;
    private Supplier<SessionFactoryImplementor> _sessionFactoryImplementorSupplier;

    public void closeSession(Session session) throws ORMException {
        if (session != null && !PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) {
            session.flush();
            session.close();
        }
    }

    public void destroy() {
        this._sessionCustomizers.close();
    }

    public Session getCurrentSession() throws ORMException {
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryImplementor();
        return this.wrapSession(sessionFactoryImplementor.getCurrentSession());
    }

    public Dialect getDialect() throws ORMException {
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryImplementor();
        JdbcServices jdbcServices = sessionFactoryImplementor.getJdbcServices();
        return new DialectImpl(jdbcServices.getDialect());
    }

    public SessionFactoryImplementor getSessionFactoryImplementor() {
        return this._sessionFactoryImplementorSupplier.get();
    }

    public Session openNewSession(Connection connection) throws ORMException {
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryImplementor();
        SessionBuilderImplementor sessionBuilder = sessionFactoryImplementor.withOptions();
        return this.wrapSession(sessionBuilder.connection(connection).openSession());
    }

    public Session openSession() throws ORMException {
        org.hibernate.Session session = null;
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryImplementor();
        session = PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED ? sessionFactoryImplementor.getCurrentSession() : sessionFactoryImplementor.openSession();
        if (_log.isDebugEnabled()) {
            org.hibernate.internal.SessionImpl sessionImpl = (org.hibernate.internal.SessionImpl)session;
            JdbcCoordinator jdbcCoordinator = sessionImpl.getJdbcCoordinator();
            LogicalConnectionImplementor logicalConnectionImplementor = jdbcCoordinator.getLogicalConnection();
            PhysicalConnectionHandlingMode physicalConnectionHandlingMode = logicalConnectionImplementor.getConnectionHandlingMode();
            _log.debug((Object)("Session is using connection release mode " + physicalConnectionHandlingMode.getReleaseMode()));
        }
        return this.wrapSession(session);
    }

    public void setSessionFactoryClassLoader(ClassLoader sessionFactoryClassLoader) {
        if (sessionFactoryClassLoader != PortalClassLoaderUtil.getClassLoader()) {
            this._sessionFactoryClassLoader = new PreloadClassLoader(sessionFactoryClassLoader, this.getPreloadClassLoaderClasses());
        }
    }

    public void setSessionFactoryImplementor(SessionFactoryImplementor sessionFactoryImplementor) {
        this.setSessionFactoryImplementorSupplier(() -> sessionFactoryImplementor);
    }

    public void setSessionFactoryImplementorSupplier(Supplier<SessionFactoryImplementor> sessionFactoryImplementorSupplier) {
        this._sessionFactoryImplementorSupplier = sessionFactoryImplementorSupplier;
    }

    protected Map<String, Class<?>> getPreloadClassLoaderClasses() {
        try {
            HashMap classes = new HashMap();
            for (String className : _PRELOAD_CLASS_NAMES) {
                ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
                Class<?> clazz = portalClassLoader.loadClass(className);
                classes.put(className, clazz);
            }
            return classes;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    protected Session wrapSession(org.hibernate.Session session) {
        SessionImpl liferaySession = new SessionImpl(session, this._sessionFactoryClassLoader);
        for (SessionCustomizer sessionCustomizer : this._sessionCustomizers) {
            liferaySession = sessionCustomizer.customize((Session)liferaySession);
        }
        return liferaySession;
    }
}

