/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.jmx;

import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.util.PropsValues;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HibernateStatisticsService {
    private ServiceRegistration<?> _serviceRegistration;

    public void afterPropertiesSet() throws NotCompliantMBeanException {
        if (PropsValues.HIBERNATE_GENERATE_STATISTICS) {
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)InfrastructureUtil.getSessionFactory();
            StatisticsImplementor statistics = sessionFactoryImplementor.getStatistics();
            statistics.setStatisticsEnabled(true);
            BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            this._serviceRegistration = bundleContext.registerService(DynamicMBean.class, (Object)new StandardMBean(statistics, Statistics.class), MapUtil.singletonDictionary((Object)"jmx.objectname", (Object)"Hibernate:name=statistics"));
        }
    }

    public void destroy() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }
}

