/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.internal.dao.sql.transformer.SQLFunctionTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DB2SQLTransformerLogic
extends BaseSQLTransformerLogic {
    private static final String _QUESTION_PARAMETER_MARKER_REPLACEMENT = "COALESCE(CAST(? AS VARCHAR(2000)),'')";
    private static final Pattern _caseWhenThenPattern = Pattern.compile("\\bcase when.+?end\\b", 2);
    private static final Pattern _likePattern = Pattern.compile("LIKE \\?", 2);
    private static final Pattern _selectPattern = Pattern.compile("select .+?from ", 2);

    public DB2SQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getAggregationFunction(), this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getDropTableIfExistsTextFunction(), this.getIntegerDivisionFunction(), this.getNullDateFunction(), this._getCaseWhenThenFunction(), this._getLikeFunction(), this._getSelectFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this.getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected Function<String, String> getConcatFunction() {
        SQLFunctionTransformer sqlFunctionTransformer = new SQLFunctionTransformer("CONCAT(", "", " CONCAT ", "");
        return sqlFunctionTransformer::transform;
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS VARCHAR(2000))");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        String dropTableIfExists = StringBundler.concat((String[])new String[]{"BEGIN\n", "DECLARE CONTINUE HANDLER FOR SQLSTATE '42704'\n", "BEGIN END;\n", "EXECUTE IMMEDIATE 'DROP TABLE $1';\n", "END"});
        return matcher.replaceAll(dropTableIfExists);
    }

    private Function<String, String> _getCaseWhenThenFunction() {
        return sql -> this._replaceQuestionParameterMarker(_caseWhenThenPattern.matcher((CharSequence)sql), (String)sql);
    }

    private Function<String, String> _getLikeFunction() {
        return sql -> {
            Matcher matcher = _likePattern.matcher((CharSequence)sql);
            return matcher.replaceAll("LIKE COALESCE(CAST(? AS VARCHAR(2000)),'')");
        };
    }

    private Function<String, String> _getSelectFunction() {
        return sql -> this._replaceQuestionParameterMarker(_selectPattern.matcher((CharSequence)sql), (String)sql);
    }

    private String _replaceQuestionParameterMarker(Matcher matcher, String sql) {
        int index = 0;
        StringBundler sb = new StringBundler();
        while (matcher.find()) {
            if (matcher.start() > index) {
                sb.append(sql.substring(index, matcher.start()));
            }
            sb.append(StringUtil.replace((String)matcher.group(), (String[])new String[]{StringBundler.concat((String[])new String[]{" ", "?", ","}), StringBundler.concat((String[])new String[]{" ", "?", " "})}, (String[])new String[]{StringBundler.concat((String[])new String[]{" ", _QUESTION_PARAMETER_MARKER_REPLACEMENT, ","}), StringBundler.concat((String[])new String[]{" ", _QUESTION_PARAMETER_MARKER_REPLACEMENT, " "})}));
            index = matcher.end();
        }
        if (index < sql.length() - 1) {
            sb.append(sql.substring(index));
        }
        return sb.toString();
    }
}

