/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.sql.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.sql.transformer.BaseSQLTransformerLogic;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.function.Function;
import java.util.regex.Matcher;

public class SybaseSQLTransformerLogic
extends BaseSQLTransformerLogic {
    public SybaseSQLTransformerLogic(DB db) {
        super(db);
        Object[] functions = new Function[]{this.getAggregationFunction(), this.getBitwiseCheckFunction(), this.getBooleanFunction(), this.getCastClobTextFunction(), this.getCastLongFunction(), this.getCastTextFunction(), this.getConcatFunction(), this.getDropTableIfExistsTextFunction(), this.getInstrFunction(), this.getIntegerDivisionFunction(), this.getLengthFunction(), this.getModFunction(), this.getNullDateFunction(), this.getSubstrFunction(), this._getCrossJoinFunction(), this._getReplaceFunction()};
        if (!db.isSupportsStringCaseSensitiveQuery()) {
            functions = (Function[])ArrayUtil.append((Object[])functions, this.getLowerFunction());
        }
        this.setFunctions((Function[])functions);
    }

    @Override
    protected String replaceCastLong(Matcher matcher) {
        return matcher.replaceAll("CONVERT(BIGINT, $1)");
    }

    @Override
    protected String replaceCastText(Matcher matcher) {
        return matcher.replaceAll("CAST($1 AS NVARCHAR(5461))");
    }

    @Override
    protected String replaceDropTableIfExistsText(Matcher matcher) {
        return matcher.replaceAll(StringBundler.concat((String[])new String[]{"IF EXISTS(select 1 from sysobjects where name = '$1' and ", "type = 'U')\n", "BEGIN\n", "DROP TABLE $1\n", "END"}));
    }

    private Function<String, String> _getCrossJoinFunction() {
        return sql -> StringUtil.replace((String)sql, (String)"CROSS JOIN", (String)",");
    }

    private Function<String, String> _getReplaceFunction() {
        return sql -> sql.replaceAll("(?i)replace\\(", "str_replace(");
    }
}

