/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.internal.service.util;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portlet.PortalPreferenceKey;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PortalPreferencesCacheUtil {
    private static final PortalCache<PortalPreferenceKey, PortalPreferenceKey> _normalizedPortalCache = PortalCacheHelperUtil.getPortalCache((String)"SINGLE_VM_PORTAL_CACHE_MANAGER", (String)(PortalPreferencesCacheUtil.class.getName() + "#_normalized"));
    private static final PortalCache<Long, Map<PortalPreferenceKey, String[]>> _portalCache = PortalCacheHelperUtil.getPortalCache((String)"MULTI_VM_PORTAL_CACHE_MANAGER", (String)PortalPreferencesCacheUtil.class.getName());

    public static Map<PortalPreferenceKey, String[]> get(long portalPreferencesId) {
        return (Map)_portalCache.get((Serializable)Long.valueOf(portalPreferencesId));
    }

    public static void put(long portalPreferencesId, Map<PortalPreferenceKey, String[]> preferenceMap) {
        if (preferenceMap.isEmpty()) {
            preferenceMap = Collections.emptyMap();
        } else {
            HashMap<PortalPreferenceKey, Object> copiedPreferenceMap = new HashMap<PortalPreferenceKey, Object>();
            for (Map.Entry<PortalPreferenceKey, Object> entry : preferenceMap.entrySet()) {
                copiedPreferenceMap.put(PortalPreferencesCacheUtil._normalize(entry.getKey()), entry.getValue());
            }
            preferenceMap = Collections.unmodifiableMap(copiedPreferenceMap);
        }
        _portalCache.put((Serializable)Long.valueOf(portalPreferencesId), preferenceMap);
    }

    private static PortalPreferenceKey _normalize(PortalPreferenceKey portalPreferenceKey) {
        PortalPreferenceKey normalizedPortalPreferenceKey = (PortalPreferenceKey)_normalizedPortalCache.get((Serializable)portalPreferenceKey);
        if (normalizedPortalPreferenceKey == null) {
            _normalizedPortalCache.put((Serializable)portalPreferenceKey, (Object)portalPreferenceKey);
            normalizedPortalPreferenceKey = portalPreferenceKey;
        }
        return normalizedPortalPreferenceKey;
    }

    private PortalPreferencesCacheUtil() {
    }
}

