/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.language;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.language.LanguageOverrideProvider;
import com.liferay.portal.language.ResourceBundleEnumeration;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class LanguageResources {
    public static ResourceBundleLoader PORTAL_RESOURCE_BUNDLE_LOADER = new ResourceBundleLoader(){

        public ResourceBundle loadResourceBundle(Locale locale) {
            return LanguageResources.getResourceBundle(locale);
        }
    };
    private static final Locale _blankLocale = new Locale("");
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final Snapshot<LanguageOverrideProvider> _languageOverrideProviderSnapshot = new Snapshot(LanguageResources.class, LanguageOverrideProvider.class);
    private static final Map<Locale, MapHolder> _mapHolders = new ConcurrentHashMap<Locale, MapHolder>();
    private static final Locale _nullLocale = new Locale("");
    private static final Map<Long, Map<Locale, Locale>> _superLocalesMap = new ConcurrentHashMap<Long, Map<Locale, Locale>>();

    public static String getMessage(Locale locale, String key) {
        String overrideValue;
        if (locale == null) {
            return null;
        }
        ResourceBundle overrideResourceBundle = LanguageResources._getOverrideResourceBundle(locale);
        if (overrideResourceBundle != null && (overrideValue = ResourceBundleUtil.getString((ResourceBundle)overrideResourceBundle, (String)key)) != null) {
            return overrideValue;
        }
        MapHolder mapHolder = LanguageResources._getMapHolder(locale);
        Map<String, String> languageMap = mapHolder.getMap();
        String value = languageMap.get(key);
        if (value == null) {
            return LanguageResources.getMessage(LanguageResources.getSuperLocale(locale), key);
        }
        return value;
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return new AggregateResourceBundle(new ResourceBundle[]{new DynamicOverrideResourceBundle(locale), new LanguageResourcesBundle(locale)});
    }

    public static Locale getSuperLocale(Locale locale) {
        Locale superLocale;
        Map<Locale, Locale> previousSuperLocales;
        Long companyId = CompanyThreadLocal.getCompanyId();
        Map<Locale, Locale> superLocales = _superLocalesMap.get(companyId);
        if (superLocales == null && (previousSuperLocales = _superLocalesMap.putIfAbsent(companyId, superLocales = new ConcurrentHashMap<Locale, Locale>())) != null) {
            superLocales = previousSuperLocales;
        }
        if ((superLocale = superLocales.get(locale)) != null) {
            if (superLocale == _nullLocale) {
                return null;
            }
            return superLocale;
        }
        superLocale = LanguageResources._getSuperLocale(locale);
        if (superLocale == null) {
            superLocales.put(locale, _nullLocale);
        } else {
            superLocales.put(locale, superLocale);
        }
        return superLocale;
    }

    public void afterPropertiesSet() {
        ResourceBundleLoaderUtil.setPortalResourceBundleLoader((ResourceBundleLoader)PORTAL_RESOURCE_BUNDLE_LOADER);
    }

    public void destroy() {
        for (MapHolder mapHolder : _mapHolders.values()) {
            mapHolder.close();
        }
        _mapHolders.clear();
    }

    private static MapHolder _getMapHolder(Locale locale) {
        MapHolder previousMapHolder;
        MapHolder mapHolder = _mapHolders.get(locale);
        if (mapHolder == null && (previousMapHolder = _mapHolders.putIfAbsent(locale, mapHolder = new MapHolder(locale))) != null) {
            mapHolder.close();
            mapHolder = previousMapHolder;
        }
        return mapHolder;
    }

    private static ResourceBundle _getOverrideResourceBundle(Locale locale) {
        LanguageOverrideProvider languageOverrideProvider = (LanguageOverrideProvider)_languageOverrideProviderSnapshot.get();
        if (languageOverrideProvider == null) {
            return null;
        }
        return languageOverrideProvider.getOverrideResourceBundle(locale);
    }

    private static Locale _getSuperLocale(Locale locale) {
        String variant = locale.getVariant();
        if (variant.length() > 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        String country = locale.getCountry();
        if (country.length() > 0) {
            Locale priorityLocale = LanguageUtil.getLocale((String)locale.getLanguage());
            if (priorityLocale != null) {
                variant = priorityLocale.getVariant();
            }
            if (priorityLocale != null && !locale.equals(priorityLocale) && variant.length() <= 0) {
                return new Locale(priorityLocale.getLanguage(), priorityLocale.getCountry());
            }
            return LocaleUtil.fromLanguageId((String)locale.getLanguage(), (boolean)false, (boolean)true);
        }
        String language = locale.getLanguage();
        if (language.length() > 0) {
            return _blankLocale;
        }
        return null;
    }

    private static class MapHolder {
        private final Map<String, String> _map = new HashMap<String, String>();
        private final Collection<ServiceReference<ResourceBundle>> _serviceReferences;

        public void close() {
            for (ServiceReference<ResourceBundle> serviceReference : this._serviceReferences) {
                _bundleContext.ungetService(serviceReference);
            }
        }

        public Map<String, String> getMap() {
            return this._map;
        }

        private MapHolder(Locale locale) {
            try {
                this._serviceReferences = _bundleContext.getServiceReferences(ResourceBundle.class, "(&(!(javax.portlet.name=*))(language.id=" + LocaleUtil.toLanguageId((Locale)locale) + "))");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new RuntimeException(invalidSyntaxException);
            }
            for (ServiceReference<ResourceBundle> serviceReference : this._serviceReferences) {
                ResourceBundle resourceBundle = (ResourceBundle)_bundleContext.getService(serviceReference);
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    String key = enumeration.nextElement();
                    this._map.putIfAbsent(key, ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key));
                }
            }
        }

        static {
            try {
                _bundleContext.addServiceListener(new ServiceListener(){

                    public void serviceChanged(ServiceEvent serviceEvent) {
                        ServiceReference serviceReference = serviceEvent.getServiceReference();
                        MapHolder mapHolder = (MapHolder)_mapHolders.remove(LocaleUtil.fromLanguageId((String)String.valueOf(serviceReference.getProperty("language.id")), (boolean)false));
                        if (mapHolder != null) {
                            mapHolder.close();
                        }
                    }
                }, "(&(!(javax.portlet.name=*))(language.id=*))");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new ExceptionInInitializerError(invalidSyntaxException);
            }
        }
    }

    private static class LanguageResourcesBundle
    extends ResourceBundle {
        private final Locale _locale;

        @Override
        public Enumeration<String> getKeys() {
            MapHolder mapHolder = LanguageResources._getMapHolder(this._locale);
            Map<String, String> languageMap = mapHolder.getMap();
            Set<String> keySet = languageMap.keySet();
            if (this.parent == null) {
                return Collections.enumeration(keySet);
            }
            return new ResourceBundleEnumeration(keySet, this.parent.getKeys());
        }

        @Override
        public Locale getLocale() {
            return this._locale;
        }

        @Override
        protected Object handleGetObject(String key) {
            MapHolder mapHolder = LanguageResources._getMapHolder(this._locale);
            Map<String, String> languageMap = mapHolder.getMap();
            return languageMap.get(key);
        }

        @Override
        protected Set<String> handleKeySet() {
            MapHolder mapHolder = LanguageResources._getMapHolder(this._locale);
            Map<String, String> languageMap = mapHolder.getMap();
            return languageMap.keySet();
        }

        private LanguageResourcesBundle(Locale locale) {
            this._locale = locale;
            Locale superLocale = LanguageResources.getSuperLocale(locale);
            if (superLocale != null) {
                LanguageResourcesBundle superResourceBundle = new LanguageResourcesBundle(superLocale);
                ResourceBundle superLocaleOverrideResourceBundle = LanguageResources._getOverrideResourceBundle(superLocale);
                if (superLocaleOverrideResourceBundle != null) {
                    superResourceBundle = new AggregateResourceBundle(new ResourceBundle[]{superLocaleOverrideResourceBundle, superResourceBundle});
                }
                this.setParent(superResourceBundle);
            }
        }
    }

    private static class DynamicOverrideResourceBundle
    extends ResourceBundle {
        private final Locale _locale;

        @Override
        public Enumeration<String> getKeys() {
            ResourceBundle overrideResourceBundle = LanguageResources._getOverrideResourceBundle(this._locale);
            if (overrideResourceBundle != null) {
                return overrideResourceBundle.getKeys();
            }
            return Collections.emptyEnumeration();
        }

        @Override
        public Locale getLocale() {
            return this._locale;
        }

        @Override
        protected Object handleGetObject(String key) {
            ResourceBundle overrideResourceBundle = LanguageResources._getOverrideResourceBundle(this._locale);
            if (overrideResourceBundle != null) {
                return overrideResourceBundle.getObject(key);
            }
            return null;
        }

        @Override
        protected Set<String> handleKeySet() {
            ResourceBundle overrideResourceBundle = LanguageResources._getOverrideResourceBundle(this._locale);
            if (overrideResourceBundle != null) {
                return overrideResourceBundle.keySet();
            }
            return Collections.emptySet();
        }

        private DynamicOverrideResourceBundle(Locale locale) {
            this._locale = locale;
        }
    }
}

