/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.model.impl.UserGroupRoleBaseImpl;

public class UserGroupRoleImpl
extends UserGroupRoleBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(UserGroupRoleImpl.class);

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UserGroupRole)) {
            return false;
        }
        UserGroupRole userGroupRole = (UserGroupRole)object;
        return this.getUserId() == userGroupRole.getUserId() && this.getGroupId() == userGroupRole.getGroupId() && this.getRoleId() == userGroupRole.getRoleId();
    }

    public Group getGroup() throws PortalException {
        return GroupLocalServiceUtil.getGroup((long)this.getGroupId());
    }

    public Role getRole() throws PortalException {
        return RoleLocalServiceUtil.getRole((long)this.getRoleId());
    }

    public User getUser() throws PortalException {
        return UserLocalServiceUtil.getUser((long)this.getUserId());
    }

    @Override
    public int hashCode() {
        int hash = HashUtil.hash((int)0, (long)this.getUserId());
        hash = HashUtil.hash((int)hash, (long)this.getGroupId());
        return HashUtil.hash((int)hash, (long)this.getRoleId());
    }

    public boolean hasOrganizationRole() {
        Role role = RoleLocalServiceUtil.fetchRole((long)this.getRoleId());
        return role != null && role.getType() == 3;
    }

    public boolean hasSiteRole() {
        block3: {
            try {
                Group group = this.getGroup();
                Role role = this.getRole();
                if (group != null && group.isSite() && role != null && role.getType() == 2) {
                    return true;
                }
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
        return false;
    }
}

