/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.BaseAuthTokenWhitelist;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;

public class AuthTokenWhitelistImpl
extends BaseAuthTokenWhitelist {
    private final DCLSingleton<Set<String>> _originCSRFWhitelist = new DCLSingleton();
    private final DCLSingleton<Set<String>> _portletCSRFWhitelist = new DCLSingleton();
    private final DCLSingleton<Set<String>> _portletInvocationWhitelist = new DCLSingleton();

    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        for (String whitelistedOrigin : (Set)this._originCSRFWhitelist.getSingleton(this::_createOriginCSRFWhitelist)) {
            if (!origin.startsWith(whitelistedOrigin)) continue;
            return true;
        }
        return false;
    }

    public boolean isPortletCSRFWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        Set portletCSRFWhitelist = (Set)this._portletCSRFWhitelist.getSingleton(this::_createPortletCSRFWhitelist);
        return portletCSRFWhitelist.contains(portlet.getRootPortletId());
    }

    public boolean isPortletInvocationWhitelisted(HttpServletRequest httpServletRequest, Portlet portlet) {
        Set portletInvocationWhitelist = (Set)this._portletInvocationWhitelist.getSingleton(this::_createPortletInvocationWhitelist);
        return portletInvocationWhitelist.contains(portlet.getPortletId());
    }

    public boolean isPortletURLCSRFWhitelisted(LiferayPortletURL liferayPortletURL) {
        String rootPortletId = PortletIdCodec.decodePortletName((String)liferayPortletURL.getPortletId());
        Set portletCSRFWhitelist = (Set)this._portletCSRFWhitelist.getSingleton(this::_createPortletCSRFWhitelist);
        return portletCSRFWhitelist.contains(rootPortletId);
    }

    public boolean isPortletURLPortletInvocationWhitelisted(LiferayPortletURL liferayPortletURL) {
        Set portletInvocationWhitelist = (Set)this._portletInvocationWhitelist.getSingleton(this::_createPortletInvocationWhitelist);
        return portletInvocationWhitelist.contains(liferayPortletURL.getPortletId());
    }

    public boolean isValidSharedSecret(String sharedSecret) {
        if (Validator.isNull((String)sharedSecret) || Validator.isNull((String)PropsValues.AUTH_TOKEN_SHARED_SECRET)) {
            return false;
        }
        return sharedSecret.equals(DigesterUtil.digest((String)PropsValues.AUTH_TOKEN_SHARED_SECRET));
    }

    private Set<String> _createOriginCSRFWhitelist() {
        Set<String> originCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
        this.registerPortalProperty("auth.token.ignore.origins");
        this.trackWhitelistServices("auth.token.ignore.origins", originCSRFWhitelist);
        return originCSRFWhitelist;
    }

    private Set<String> _createPortletCSRFWhitelist() {
        Set<String> portletCSRFWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
        this.registerPortalProperty("auth.token.ignore.portlets");
        this.trackWhitelistServices("auth.token.ignore.portlets", portletCSRFWhitelist);
        return portletCSRFWhitelist;
    }

    private Set<String> _createPortletInvocationWhitelist() {
        Set<String> portletInvocationWhitelist = Collections.newSetFromMap(new ConcurrentHashMap());
        this.registerPortalProperty("portlet.add.default.resource.check.whitelist");
        this.trackWhitelistServices("portlet.add.default.resource.check.whitelist", portletInvocationWhitelist);
        return portletInvocationWhitelist;
    }
}

