/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.security.sso.SSO;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import org.osgi.framework.BundleContext;

public class SSOUtil {
    private static final ServiceTrackerList<SSO> _ssos = ServiceTrackerListFactory.open((BundleContext)SystemBundleUtil.getBundleContext(), SSO.class);

    public static String getSessionExpirationRedirectURL(long companyId, String sessionExpirationRedirectURL) {
        String ssoSessionExpirationRedirectURL = SSOUtil._getSessionExpirationRedirectURL(companyId);
        if (_ssos.size() == 0 || Validator.isNull((String)ssoSessionExpirationRedirectURL)) {
            return sessionExpirationRedirectURL;
        }
        return ssoSessionExpirationRedirectURL;
    }

    public static String getSignInURL(long companyId, String signInURL) {
        if (_ssos.size() == 0) {
            return null;
        }
        return SSOUtil._getSignInURL(companyId, signInURL);
    }

    public static boolean isLoginRedirectRequired(long companyId) {
        if (PrefsPropsUtil.getBoolean((long)companyId, (String)"login.dialog.disabled", (boolean)PropsValues.LOGIN_DIALOG_DISABLED)) {
            return true;
        }
        if (_ssos.size() == 0) {
            return false;
        }
        return SSOUtil._isLoginRedirectRequired(companyId);
    }

    public static boolean isRedirectRequired(long companyId) {
        if (_ssos.size() == 0) {
            return false;
        }
        return SSOUtil._isRedirectRequired(companyId);
    }

    public static boolean isSessionRedirectOnExpire(long companyId) {
        boolean sessionRedirectOnExpire = PropsValues.SESSION_TIMEOUT_REDIRECT_ON_EXPIRE;
        if (_ssos.size() == 0 || sessionRedirectOnExpire) {
            return sessionRedirectOnExpire;
        }
        return SSOUtil._isSessionRedirectOnExpire(companyId);
    }

    private static String _getSessionExpirationRedirectURL(long companyId) {
        for (SSO sso : _ssos) {
            String sessionExpirationRedirectURL = sso.getSessionExpirationRedirectUrl(companyId);
            if (sessionExpirationRedirectURL == null) continue;
            return sessionExpirationRedirectURL;
        }
        return null;
    }

    private static String _getSignInURL(long companyId, String defaultSignInURL) {
        for (SSO sso : _ssos) {
            String signInURL = sso.getSignInURL(companyId, defaultSignInURL);
            if (signInURL == null) continue;
            return signInURL;
        }
        return null;
    }

    private static boolean _isLoginRedirectRequired(long companyId) {
        for (SSO sso : _ssos) {
            if (!sso.isLoginRedirectRequired(companyId)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isRedirectRequired(long companyId) {
        for (SSO sso : _ssos) {
            if (!sso.isRedirectRequired(companyId)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isSessionRedirectOnExpire(long companyId) {
        for (SSO sso : _ssos) {
            if (!sso.isSessionRedirectOnExpire(companyId)) continue;
            return true;
        }
        return false;
    }

    private SSOUtil() {
    }
}

