/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.xml;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProvider;
import com.liferay.portal.security.xml.StripDoctypeXMLReader;
import com.liferay.portal.util.PropsValues;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.XMLReader;

public class SecureXMLFactoryProviderImpl
implements SecureXMLFactoryProvider {
    private static final String _FEATURES_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String _FEATURES_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String _FEATURES_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final Log _log = LogFactoryUtil.getLog(SecureXMLFactoryProviderImpl.class);

    public DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        if (!PropsValues.XML_SECURITY_ENABLED) {
            return documentBuilderFactory;
        }
        try {
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize safe document builder factory to protect from XML Bomb attacks", (Throwable)exception);
        }
        try {
            documentBuilderFactory.setFeature(_FEATURES_DISALLOW_DOCTYPE_DECL, true);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize safe document builder factory to protect from XML Bomb attacks", (Throwable)exception);
        }
        try {
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setFeature(_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
            documentBuilderFactory.setFeature(_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize safe document builder factory to protect from XXE attacks", (Throwable)exception);
        }
        return documentBuilderFactory;
    }

    public TransformerFactory newTransformerFactory() throws TransformerFactoryConfigurationError {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!PropsValues.XML_SECURITY_ENABLED) {
            return transformerFactory;
        }
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }

    public XMLInputFactory newXMLInputFactory() {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        if (!PropsValues.XML_SECURITY_ENABLED) {
            return xmlInputFactory;
        }
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xmlInputFactory;
    }

    public XMLReader newXMLReader() {
        Object xmlReader = null;
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)SecureXMLFactoryProviderImpl.class.getClassLoader());){
            xmlReader = new SAXParser();
        }
        catch (RuntimeException runtimeException) {
            throw new SystemException((Throwable)runtimeException);
        }
        if (!PropsValues.XML_SECURITY_ENABLED) {
            return xmlReader;
        }
        xmlReader = new StripDoctypeXMLReader((XMLReader)xmlReader);
        try {
            xmlReader.setFeature(_FEATURES_DISALLOW_DOCTYPE_DECL, true);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize safe SAX parser to protect from XML Bomb attacks", (Throwable)exception);
        }
        try {
            xmlReader.setFeature(_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
            xmlReader.setFeature(_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to initialize safe SAX parser to protect from XXE attacks", (Throwable)exception);
        }
        return xmlReader;
    }
}

