/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.service.base.CompanyServiceBaseImpl;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import com.liferay.ratings.kernel.transformer.RatingsDataTransformerUtil;
import java.io.InputStream;
import java.util.List;
import javax.portlet.PortletPreferences;

@JSONWebService
public class CompanyServiceImpl
extends CompanyServiceBaseImpl {
    @BeanReference(type=RoleLocalService.class)
    private RoleLocalService _roleLocalService;

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company addCompany(long companyId, String webId, String virtualHost, String mx, int maxUsers, boolean active) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.addCompany(Long.valueOf(companyId), webId, virtualHost, mx, maxUsers, active, null, null, null, null, null, null);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company addCompany(String webId, String virtualHost, String mx, int maxUsers, boolean active, String defaultAdminPassword, String defaultAdminScreenName, String defaultAdminEmailAddress, String defaultAdminFirstName, String defaultAdminMiddleName, String defaultAdminLastName) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.addCompany(null, webId, virtualHost, mx, maxUsers, active, defaultAdminPassword, defaultAdminScreenName, defaultAdminEmailAddress, defaultAdminFirstName, defaultAdminMiddleName, defaultAdminLastName);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company deleteCompany(long companyId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.deleteCompany(companyId);
    }

    public void deleteLogo(long companyId) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.deleteLogo(companyId);
    }

    public void forEachCompany(UnsafeConsumer<Company, Exception> unsafeConsumer) throws Exception {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        this.companyLocalService.forEachCompany(unsafeConsumer);
    }

    public List<Company> getCompanies() {
        return this.companyLocalService.getCompanies();
    }

    public Company getCompanyById(long companyId) throws PortalException {
        return this.companyLocalService.getCompanyById(companyId);
    }

    public Company getCompanyByLogoId(long logoId) throws PortalException {
        return this.companyLocalService.getCompanyByLogoId(logoId);
    }

    public Company getCompanyByMx(String mx) throws PortalException {
        return this.companyLocalService.getCompanyByMx(mx);
    }

    public Company getCompanyByVirtualHost(String virtualHost) throws PortalException {
        return this.companyLocalService.getCompanyByVirtualHost(virtualHost);
    }

    public Company getCompanyByWebId(String webId) throws PortalException {
        return this.companyLocalService.getCompanyByWebId(webId);
    }

    public void removePreferences(long companyId, String[] keys) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.removePreferences(companyId, keys);
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, int maxUsers, boolean active) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker);
        }
        return this.companyLocalService.updateCompany(companyId, virtualHost, mx, maxUsers, active);
    }

    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, boolean hasLogo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateCompany(companyId, virtualHost, mx, homeURL, hasLogo, logoBytes, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company updateCompany(long companyId, String virtualHost, String mx, String homeURL, boolean hasLogo, byte[] logoBytes, String name, String legalName, String legalId, String legalType, String sicCode, String tickerSymbol, String industry, String type, String size, String languageId, String timeZoneId, List<Address> addresses, List<EmailAddress> emailAddresses, List<Phone> phones, List<Website> websites, UnicodeProperties unicodeProperties) throws PortalException {
        PortletPreferences oldCompanyPortletPreferences = PrefsPropsUtil.getPreferences((long)companyId);
        Company company = this.updateCompany(companyId, virtualHost, mx, homeURL, hasLogo, logoBytes, name, legalName, legalId, legalType, sicCode, tickerSymbol, industry, type, size);
        this.updateDisplay(company.getCompanyId(), languageId, timeZoneId);
        this.updatePreferences(company.getCompanyId(), unicodeProperties);
        RatingsDataTransformerUtil.transformCompanyRatingsData((long)companyId, (PortletPreferences)oldCompanyPortletPreferences, (UnicodeProperties)unicodeProperties);
        UsersAdminUtil.updateAddresses(Company.class.getName(), company.getCompanyId(), addresses);
        UsersAdminUtil.updateEmailAddresses(Company.class.getName(), company.getCompanyId(), emailAddresses);
        UsersAdminUtil.updatePhones(Company.class.getName(), company.getCompanyId(), phones);
        UsersAdminUtil.updateWebsites(Company.class.getName(), company.getCompanyId(), websites);
        return company;
    }

    public void updateDisplay(long companyId, String languageId, String timeZoneId) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateDisplay(companyId, languageId, timeZoneId);
    }

    public Company updateLogo(long companyId, byte[] bytes) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateLogo(companyId, bytes);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public Company updateLogo(long companyId, InputStream inputStream) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        return this.companyLocalService.updateLogo(companyId, inputStream);
    }

    public void updatePreferences(long companyId, UnicodeProperties unicodeProperties) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true) && !this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Analytics Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updatePreferences(companyId, unicodeProperties);
    }

    @JSONWebService(mode=JSONWebServiceMode.IGNORE)
    public void updateSecurity(long companyId, String authType, boolean autoLogin, boolean sendPassword, boolean strangers, boolean strangersWithMx, boolean strangersVerify, boolean siteLogo) throws PortalException {
        if (!this._roleLocalService.hasUserRole(this.getUserId(), companyId, "Administrator", true)) {
            throw new PrincipalException();
        }
        this.companyLocalService.updateSecurity(companyId, authType, autoLogin, sendPassword, strangers, strangersWithMx, strangersVerify, siteLogo);
    }
}

