/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.LayoutPrototypeServiceBaseImpl;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LayoutPrototypeServiceImpl
extends LayoutPrototypeServiceBaseImpl {
    public LayoutPrototype addLayoutPrototype(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_LAYOUT_PROTOTYPE");
        User user = this.getUser();
        return this.layoutPrototypeLocalService.addLayoutPrototype(user.getUserId(), user.getCompanyId(), nameMap, descriptionMap, active, serviceContext);
    }

    public void deleteLayoutPrototype(long layoutPrototypeId) throws PortalException {
        LayoutPrototypePermissionUtil.check(this.getPermissionChecker(), layoutPrototypeId, "DELETE");
        this.layoutPrototypeLocalService.deleteLayoutPrototype(layoutPrototypeId);
    }

    public LayoutPrototype fetchLayoutPrototype(long layoutPrototypeId) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.fetchLayoutPrototype(layoutPrototypeId);
        if (layoutPrototype != null) {
            LayoutPrototypePermissionUtil.check(this.getPermissionChecker(), layoutPrototypeId, "VIEW");
        }
        return layoutPrototype;
    }

    public LayoutPrototype getLayoutPrototype(long layoutPrototypeId) throws PortalException {
        LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototype(layoutPrototypeId);
        LayoutPrototypePermissionUtil.check(this.getPermissionChecker(), layoutPrototypeId, "VIEW");
        return layoutPrototype;
    }

    public List<LayoutPrototype> search(long companyId, Boolean active, OrderByComparator<LayoutPrototype> orderByComparator) throws PortalException {
        ArrayList<LayoutPrototype> filteredLayoutPrototypes = new ArrayList<LayoutPrototype>();
        List layoutPrototypes = this.layoutPrototypeLocalService.search(companyId, active, -1, -1, orderByComparator);
        for (LayoutPrototype layoutPrototype : layoutPrototypes) {
            if (!LayoutPrototypePermissionUtil.contains(this.getPermissionChecker(), layoutPrototype.getLayoutPrototypeId(), "VIEW")) continue;
            filteredLayoutPrototypes.add(layoutPrototype);
        }
        return filteredLayoutPrototypes;
    }

    public LayoutPrototype updateLayoutPrototype(long layoutPrototypeId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, ServiceContext serviceContext) throws PortalException {
        LayoutPrototypePermissionUtil.check(this.getPermissionChecker(), layoutPrototypeId, "UPDATE");
        return this.layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototypeId, nameMap, descriptionMap, active, serviceContext);
    }
}

