/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.ReleaseConstants;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.ReleaseLocalServiceBaseImpl;
import java.util.Date;

public class ReleaseLocalServiceImpl
extends ReleaseLocalServiceBaseImpl {
    public Release addRelease(String servletContextName, int buildNumber) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date date = new Date();
        release.setCreateDate(date);
        release.setModifiedDate(date);
        release.setServletContextName(servletContextName);
        release.setBuildNumber(buildNumber);
        if (servletContextName.equals("portal")) {
            release.setTestString(ReleaseConstants.TEST_STRING);
        }
        return (Release)this.releasePersistence.update((BaseModel)release);
    }

    public Release addRelease(String servletContextName, String schemaVersion) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date date = new Date();
        release.setCreateDate(date);
        release.setModifiedDate(date);
        release.setServletContextName(servletContextName);
        release.setSchemaVersion(schemaVersion);
        if (servletContextName.equals("portal")) {
            release.setTestString(ReleaseConstants.TEST_STRING);
        }
        return (Release)this.releasePersistence.update((BaseModel)release);
    }

    public Release fetchRelease(String servletContextName) {
        if (Validator.isNull((String)servletContextName)) {
            throw new IllegalArgumentException("Servlet context name is null");
        }
        Release release = null;
        release = servletContextName.equals("portal") ? this.releasePersistence.fetchByPrimaryKey(1L) : this.releasePersistence.fetchByServletContextName(servletContextName);
        return release;
    }

    public Release updateRelease(long releaseId, String schemaVersion, int buildNumber, Date buildDate, boolean verified) throws PortalException {
        Release release = this.releasePersistence.findByPrimaryKey(releaseId);
        release.setModifiedDate(new Date());
        release.setSchemaVersion(schemaVersion);
        release.setBuildNumber(buildNumber);
        release.setBuildDate(buildDate);
        release.setVerified(verified);
        return (Release)this.releasePersistence.update((BaseModel)release);
    }

    public Release updateRelease(String servletContextName, String schemaVersion, String previousSchemaVersion) {
        String currentSchemaVersion;
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            if (previousSchemaVersion.equals("0.0.0")) {
                release = this.releaseLocalService.addRelease(servletContextName, previousSchemaVersion);
            } else {
                throw new IllegalStateException("Unable to update release because it does not exist");
            }
        }
        if (Validator.isNull((String)(currentSchemaVersion = release.getSchemaVersion()))) {
            currentSchemaVersion = "0.0.0";
        }
        if (!previousSchemaVersion.equals(currentSchemaVersion)) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Unable to update release because the previous schema ", "version ", previousSchemaVersion, " does not match the expected schema version ", currentSchemaVersion}));
        }
        release.setSchemaVersion(schemaVersion);
        return (Release)this.releasePersistence.update((BaseModel)release);
    }
}

