/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PwdEncryptorException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.RememberMeToken;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.RememberMeTokenLocalServiceBaseImpl;
import java.util.Date;
import java.util.Objects;
import java.util.function.Consumer;

public class RememberMeTokenLocalServiceImpl
extends RememberMeTokenLocalServiceBaseImpl {
    public RememberMeToken addRememberMeToken(long companyId, long userId, Date expirationDate, Consumer<String> valueConsumer) throws PwdEncryptorException {
        RememberMeToken rememberMeToken = this.rememberMeTokenPersistence.create(this.counterLocalService.increment());
        rememberMeToken.setCompanyId(companyId);
        rememberMeToken.setUserId(userId);
        rememberMeToken.setExpirationDate(expirationDate);
        String value = PortalUUIDUtil.generate();
        rememberMeToken.setValue(PasswordEncryptorUtil.encrypt((String)value));
        rememberMeToken = (RememberMeToken)this.rememberMeTokenPersistence.update((BaseModel)rememberMeToken);
        valueConsumer.accept(value);
        return rememberMeToken;
    }

    public void deleteExpiredRememberMeTokens(long userId) {
        for (RememberMeToken rememberMeToken : this.rememberMeTokenPersistence.findByUserId(userId)) {
            if (!rememberMeToken.isExpired()) continue;
            this.deleteRememberMeToken(rememberMeToken);
        }
    }

    public RememberMeToken fetchRememberMeToken(long rememberMeTokenId, String value) throws PwdEncryptorException {
        RememberMeToken rememberMeToken = this.fetchRememberMeToken(rememberMeTokenId);
        if (rememberMeToken == null || !Objects.equals(rememberMeToken.getValue(), PasswordEncryptorUtil.encrypt((String)value, (String)rememberMeToken.getValue()))) {
            return null;
        }
        return rememberMeToken;
    }
}

