/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.service.base.WebDAVPropsLocalServiceBaseImpl;
import java.util.Date;

public class WebDAVPropsLocalServiceImpl
extends WebDAVPropsLocalServiceBaseImpl {
    @BeanReference(type=ClassNameLocalService.class)
    private ClassNameLocalService _classNameLocalService;

    public void deleteWebDAVProps(String className, long classPK) {
        WebDAVProps webDAVProps = this.webDAVPropsPersistence.fetchByC_C(this._classNameLocalService.getClassNameId(className), classPK);
        if (webDAVProps != null) {
            this.webDAVPropsPersistence.remove((BaseModel)webDAVProps);
        }
    }

    public WebDAVProps getWebDAVProps(long companyId, String className, long classPK) {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        WebDAVProps webDAVProps = this.webDAVPropsPersistence.fetchByC_C(classNameId, classPK);
        if (webDAVProps == null) {
            webDAVProps = this.webDAVPropsPersistence.create(this.counterLocalService.increment());
            Date date = new Date();
            webDAVProps.setCompanyId(companyId);
            webDAVProps.setCreateDate(date);
            webDAVProps.setModifiedDate(date);
            webDAVProps.setClassNameId(classNameId);
            webDAVProps.setClassPK(classPK);
            webDAVProps = this.webDAVPropsLocalService.updateWebDAVProps(webDAVProps);
        }
        return webDAVProps;
    }

    public void storeWebDAVProps(WebDAVProps webDAVProps) throws PortalException {
        try {
            webDAVProps.store();
        }
        catch (Exception exception) {
            throw new WebDAVException("Problem trying to store WebDAVProps", (Throwable)exception);
        }
        this.webDAVPropsPersistence.update((BaseModel)webDAVProps);
    }
}

