/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoogleGadgetServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(GoogleGadgetServlet.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String content = this.getContent(httpServletRequest);
            if (content == null) {
                PortalUtil.sendError((int)404, (Exception)((Object)new NoSuchLayoutException()), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            } else {
                httpServletRequest.setAttribute("GOOGLE_GADGET", (Object)Boolean.TRUE);
                httpServletResponse.setContentType("text/xml");
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)content);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            PortalUtil.sendError((int)500, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    protected String getContent(HttpServletRequest httpServletRequest) throws Exception {
        String path = GetterUtil.getString((String)httpServletRequest.getPathInfo());
        if (Validator.isNull((String)path)) {
            return null;
        }
        int pos = path.indexOf("/-/");
        if (pos == -1) {
            return null;
        }
        String portletId = path.substring(pos + "/-/".length());
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest), (String)portletId);
        String title = portlet.getDisplayName();
        String widgetURL = String.valueOf(httpServletRequest.getRequestURL());
        widgetURL = widgetURL.replaceFirst(PropsValues.GOOGLE_GADGET_SERVLET_MAPPING, PropsValues.WIDGET_SERVLET_MAPPING);
        StringBundler sb = new StringBundler(14);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Module>");
        sb.append("<ModulePrefs title=\"");
        sb.append(title);
        sb.append("\"/>");
        sb.append("<Content type=\"html\">");
        sb.append("<![CDATA[");
        sb.append("<iframe frameborder=\"0\" height=\"100%\" src=\"");
        sb.append(widgetURL);
        sb.append("\" width=\"100%\">");
        sb.append("</iframe>");
        sb.append("]]>");
        sb.append("</Content>");
        sb.append("</Module>");
        return sb.toString();
    }
}

