/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.servlet.RestrictedByteBufferCacheServletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagFilter
extends BasePortalFilter {
    public static final String SKIP_FILTER = ETagFilter.class.getName() + "#SKIP_FILTER";
    private static final String _ETAG = "etag";

    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)_ETAG, (boolean)true) && !this.isAlreadyFiltered(httpServletRequest);
    }

    protected boolean isAlreadyFiltered(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getAttribute(SKIP_FILTER) != null;
    }

    protected boolean isEligibleForETag(int status) {
        return status >= 200 && status < 300;
    }

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        httpServletRequest.setAttribute(SKIP_FILTER, (Object)Boolean.TRUE);
        RestrictedByteBufferCacheServletResponse restrictedByteBufferCacheServletResponse = new RestrictedByteBufferCacheServletResponse(httpServletResponse, PropsValues.ETAG_RESPONSE_SIZE_MAX);
        this.processFilter(ETagFilter.class.getName(), httpServletRequest, (HttpServletResponse)restrictedByteBufferCacheServletResponse, filterChain);
        if (httpServletRequest.isAsyncSupported() && httpServletRequest.isAsyncStarted()) {
            AsyncContext asyncContext = httpServletRequest.getAsyncContext();
            asyncContext.addListener((AsyncListener)new ETagFilterAsyncListener(asyncContext, httpServletRequest, httpServletResponse, restrictedByteBufferCacheServletResponse));
        } else {
            this._postProcessETag(httpServletRequest, httpServletResponse, restrictedByteBufferCacheServletResponse);
        }
    }

    private void _postProcessETag(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RestrictedByteBufferCacheServletResponse restrictedByteBufferCacheServletResponse) throws IOException {
        if (!(restrictedByteBufferCacheServletResponse.isOverflowed() || this.isEligibleForETag(restrictedByteBufferCacheServletResponse.getStatus()) && ETagUtil.processETag(httpServletRequest, httpServletResponse, restrictedByteBufferCacheServletResponse.getByteBuffer()))) {
            restrictedByteBufferCacheServletResponse.flushCache();
        }
    }

    private class ETagFilterAsyncListener
    implements AsyncListener {
        private final AsyncContext _asyncContext;
        private final HttpServletRequest _httpServletRequest;
        private final HttpServletResponse _httpServletResponse;
        private final RestrictedByteBufferCacheServletResponse _restrictedByteBufferCacheServletResponse;

        public void onComplete(AsyncEvent event) throws IOException {
            ETagFilter.this._postProcessETag(this._httpServletRequest, this._httpServletResponse, this._restrictedByteBufferCacheServletResponse);
        }

        public void onError(AsyncEvent event) {
        }

        public void onStartAsync(AsyncEvent event) {
            this._asyncContext.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) {
        }

        private ETagFilterAsyncListener(AsyncContext asyncContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RestrictedByteBufferCacheServletResponse restrictedByteBufferCacheServletResponse) {
            this._asyncContext = asyncContext;
            this._httpServletRequest = httpServletRequest;
            this._httpServletResponse = httpServletResponse;
            this._restrictedByteBufferCacheServletResponse = restrictedByteBufferCacheServletResponse;
        }
    }
}

