/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.gzip;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZipResponse
extends HttpServletResponseWrapper {
    private static final int _EMPTY_GZIP_OUTPUT_SIZE;
    private static final String _GZIP = "gzip";
    private static final Log _log;
    private PrintWriter _printWriter;
    private ServletOutputStream _servletOutputStream;

    public GZipResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        httpServletResponse.setContentLength(-1);
        httpServletResponse.addHeader("Content-Encoding", _GZIP);
    }

    public void finishResponse() throws IOException {
        if (this._printWriter != null) {
            this._printWriter.close();
        } else if (this._servletOutputStream != null) {
            this._servletOutputStream.close();
        }
    }

    public void flushBuffer() throws IOException {
        if (this._servletOutputStream != null) {
            this._servletOutputStream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._printWriter != null) {
            throw new IllegalStateException();
        }
        if (this._servletOutputStream == null) {
            this._servletOutputStream = this._createGZipServletOutputStream(super.getOutputStream());
        }
        return this._servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._printWriter != null) {
            return this._printWriter;
        }
        if (this._servletOutputStream != null) {
            throw new IllegalStateException();
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Use getOutputStream for optimum performance");
        }
        this._servletOutputStream = this.getOutputStream();
        this._printWriter = UnsyncPrintWriterPool.borrow((OutputStream)this._servletOutputStream, (String)this.getCharacterEncoding());
        return this._printWriter;
    }

    public void setContentLength(int contentLength) {
        if (contentLength == 0) {
            super.setContentLength(0);
        }
    }

    public void setContentLengthLong(long contentLengthLong) {
        if (contentLengthLong == 0L) {
            super.setContentLengthLong(0L);
        }
    }

    public void setHeader(String name, String value) {
        if ("Content-Length".equals(name)) {
            if (Objects.equals(value, "0")) {
                super.setContentLength(0);
            }
            return;
        }
        super.setHeader(name, value);
    }

    private ServletOutputStream _createGZipServletOutputStream(ServletOutputStream servletOutputStream) throws IOException {
        if (this._isGZipContentType()) {
            return servletOutputStream;
        }
        final EmptyGZipBufferedOutputStream emptyGZipBufferedOutputStream = new EmptyGZipBufferedOutputStream((OutputStream)servletOutputStream);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)((Object)emptyGZipBufferedOutputStream)){
            {
                this.def.setLevel(PropsValues.GZIP_COMPRESSION_LEVEL);
            }
        };
        return new ServletOutputStreamAdapter(gzipOutputStream){

            public void write(byte[] bytes) throws IOException {
                this.write(bytes, 0, bytes.length);
            }

            public void write(byte[] bytes, int offset, int length) throws IOException {
                if (length > 0) {
                    emptyGZipBufferedOutputStream.setFlush(true);
                }
                super.write(bytes, offset, length);
            }

            public void write(int b) throws IOException {
                emptyGZipBufferedOutputStream.setFlush(true);
                super.write(b);
            }
        };
    }

    private boolean _isGZipContentType() {
        String contentType = this.getContentType();
        return contentType != null && (contentType.equals("application/gzip") || contentType.equals("application/x-gzip"));
    }

    static {
        _log = LogFactoryUtil.getLog(GZipResponse.class);
        try {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)unsyncByteArrayOutputStream){
                {
                    this.def.setLevel(PropsValues.GZIP_COMPRESSION_LEVEL);
                }
            };
            gzipOutputStream.close();
            _EMPTY_GZIP_OUTPUT_SIZE = unsyncByteArrayOutputStream.size();
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
    }

    private static class EmptyGZipBufferedOutputStream
    extends UnsyncBufferedOutputStream {
        private boolean _flush;

        public void flush() throws IOException {
            if (this._flush) {
                super.flush();
            }
        }

        public void setFlush(boolean flush) {
            this._flush = flush;
        }

        private EmptyGZipBufferedOutputStream(OutputStream outputStream) {
            super(outputStream, _EMPTY_GZIP_OUTPUT_SIZE);
        }
    }
}

