/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.healthcheckdatasource;

import com.liferay.portal.kernel.util.InfrastructureUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class HealthCheckDataSourceFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        DataSource dataSource = InfrastructureUtil.getDataSource();
        try (Connection connection = dataSource.getConnection();){
            if (connection.isValid(0)) {
                this._writeMessage(httpServletResponse, 200, "Data source is healthy.");
            } else {
                this._writeMessage(httpServletResponse, 503, "Data source is not healthy.");
            }
        }
        catch (SQLException sqlException) {
            this._writeMessage(httpServletResponse, 500, sqlException.getMessage());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void _writeMessage(HttpServletResponse httpServletResponse, int status, String message) throws IOException {
        httpServletResponse.setStatus(status);
        try (PrintWriter printWriter = httpServletResponse.getWriter();){
            printWriter.println(message);
        }
    }
}

