/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.json.JSONArray;
import org.json.JSONObject;

public class PublishDateBuilder {
    private static final String _CVPD = "current-version-publish-date";
    private static final String _LATEST_VERSION = "LATEST VERSION";
    private static final String _LVPD = "latest-version-publish-date";
    private static final Log _log = LogFactoryUtil.getLog(PublishDateBuilder.class);
    private static final Properties _dependenciesProperties;
    private static final Map<String, JSONObject> _mavenVersionDetailsCache;
    private Map<String, File> _bundleNameGradleFileMap;

    public static void main(String[] args) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String xmls = bufferedReader.readLine();
        new PublishDateBuilder(StringUtil.split((String)xmls));
    }

    public PublishDateBuilder(String[] xmls) throws DocumentException, IOException {
        System.setProperty("line.separator", "\n");
        for (String xml : xmls) {
            this._addDate(xml);
        }
    }

    private Element _addCVPDElement(Element libraryElement, String groupId, String artifactId, String version) {
        Element cvpdElement = libraryElement.element(_CVPD);
        if (cvpdElement != null) {
            return libraryElement;
        }
        cvpdElement = libraryElement.addElement(_CVPD);
        String date = this._getMavenVersionDate(groupId, artifactId, version);
        if (date != null) {
            cvpdElement.setText(date);
        }
        return libraryElement;
    }

    private void _addDate(String xml) throws DocumentException, IOException {
        try {
            SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
            Document document = saxReader.read(new File(xml));
            Element rootElement = document.getRootElement();
            Element versionElement = rootElement.element("version");
            Element librariesElement = versionElement.element("libraries");
            List libraryElements = librariesElement.elements("library");
            for (Element libraryElement : libraryElements) {
                String value = null;
                String fileNameElementText = libraryElement.elementText("file-name");
                value = fileNameElementText.startsWith("lib/") ? this._getDependencyFromPropertyFile(fileNameElementText) : this._getDependencyFromGradleFile(fileNameElementText);
                String[] dependency = StringUtil.split((String)value, (char)':');
                if (dependency.length == 0) continue;
                String groupId = dependency[0];
                String artifactId = dependency[1];
                String version = dependency[2];
                this._addCVPDElement(libraryElement, groupId, artifactId, version);
                this._addLVPDElement(libraryElement, groupId, artifactId);
            }
            this._writeDocument(document, xml);
        }
        catch (DocumentException documentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to read the " + xml), (Throwable)documentException);
            }
            throw new DocumentException("Unable to read the " + xml);
        }
    }

    private Element _addLVPDElement(Element libraryElement, String groupId, String artifactId) {
        String date;
        Element lvpdElement = libraryElement.element(_LVPD);
        if (lvpdElement == null) {
            lvpdElement = libraryElement.addElement(_LVPD);
        }
        if ((date = this._getMavenVersionDate(groupId, artifactId, _LATEST_VERSION)) != null) {
            lvpdElement.setText(date);
        }
        return libraryElement;
    }

    private String _extractGradleDependency(String content) {
        char[] quote = new char[]{'\"', '\"'};
        int groupStartIndex = content.indexOf("group:");
        int groupEndIndex = content.indexOf(",", groupStartIndex);
        int nameStartIndex = content.indexOf("name:");
        int nameEndIndex = content.indexOf(",", nameStartIndex);
        int versionStartIndex = content.indexOf("version:");
        String groupPart = content.substring(groupStartIndex, groupEndIndex);
        String group = StringUtil.extractLast((String)groupPart, (String)":");
        group = StringUtil.removeChars((String)group.trim(), (char[])quote);
        String namePart = content.substring(nameStartIndex, nameEndIndex);
        String name = StringUtil.extractLast((String)namePart, (String)":");
        name = StringUtil.removeChars((String)name.trim(), (char[])quote);
        String versionPart = content.substring(versionStartIndex);
        String version = StringUtil.extractLast((String)versionPart, (String)":");
        version = StringUtil.removeChars((String)version.trim(), (char[])quote);
        return StringBundler.concat((String[])new String[]{group, ":", name, ":", version});
    }

    private String _formatDate(long time) {
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Timestamp timestamp = new Timestamp(time);
        return dateFormat.format(timestamp);
    }

    private Map<String, File> _getBundleNameGradleFileMap() {
        if (this._bundleNameGradleFileMap != null) {
            return this._bundleNameGradleFileMap;
        }
        File folder = new File(System.getProperty("project.modules.dir"));
        this._bundleNameGradleFileMap = new HashMap<String, File>();
        return this._getBundleNameGradleFileMap(folder);
    }

    private Map<String, File> _getBundleNameGradleFileMap(File folder) {
        File[] files;
        for (File file : files = folder.listFiles()) {
            File gradleFile;
            String bundleSymbolicName;
            if (file.isDirectory()) {
                this._getBundleNameGradleFileMap(file);
                continue;
            }
            String name = file.getName();
            if (!name.equals("bnd.bnd") || (bundleSymbolicName = this._getBundleSymbolicName(file)) == null || !(gradleFile = new File(file.getParent() + "/build.gradle")).exists()) continue;
            this._bundleNameGradleFileMap.put(bundleSymbolicName, gradleFile);
        }
        return this._bundleNameGradleFileMap;
    }

    private String _getBundleSymbolicName(File file) {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String content = null;
            while ((content = bufferedReader.readLine()) != null) {
                if (!StringUtil.startsWith((String)content, (String)"Bundle-SymbolicName")) continue;
                int start = content.indexOf(":");
                String name = content.substring(start + 1);
                return name.trim();
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return null;
    }

    private String _getDependencyFromGradleFile(String fileNameElementText) {
        String dependency = null;
        String bundleJar = StringUtil.extractFirst((String)fileNameElementText, (String)"!");
        int x = bundleJar.lastIndexOf(".");
        String bundleName = bundleJar.substring(0, x);
        File gradleFile = this._getGradleFile(bundleName);
        Path path = Paths.get(gradleFile.getAbsolutePath(), new String[0]);
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String content = null;
            String artifactJar = StringUtil.extractLast((String)fileNameElementText, (String)"!");
            int y = artifactJar.lastIndexOf(".");
            String artifactName = artifactJar.substring(0, y);
            StringBuilder regexSB = new StringBuilder();
            regexSB.append(".*group:.*name:\\s*\"");
            regexSB.append(artifactName);
            regexSB.append("\".*version:.*");
            while ((content = bufferedReader.readLine()) != null) {
                if (!content.matches(regexSB.toString())) continue;
                dependency = this._extractGradleDependency(content);
                break;
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return dependency;
    }

    private String _getDependencyFromPropertyFile(String fileNameElementText) {
        int startIndex = fileNameElementText.lastIndexOf("/");
        int endIndex = fileNameElementText.lastIndexOf(".");
        String name = fileNameElementText.substring(startIndex + 1, endIndex);
        return _dependenciesProperties.getProperty(name);
    }

    private File _getGradleFile(String bundleName) {
        Map<String, File> bundleNameGradleFileMap = this._getBundleNameGradleFileMap();
        return bundleNameGradleFileMap.get(bundleName);
    }

    private String _getMavenVersionDate(String groupId, String artifactId, String version) {
        JSONObject mavenVersionDetailsJSONObject = this._getMavenVersionDetailsJSONObject(groupId, artifactId);
        if (mavenVersionDetailsJSONObject == null) {
            return null;
        }
        JSONObject responseJSONObject = mavenVersionDetailsJSONObject.getJSONObject("response");
        int numFound = responseJSONObject.getInt("numFound");
        if (numFound == 0) {
            return null;
        }
        JSONObject docJSONObject = null;
        JSONArray docsJSONArray = responseJSONObject.getJSONArray("docs");
        if (version.equals(_LATEST_VERSION)) {
            docJSONObject = docsJSONArray.getJSONObject(0);
        } else {
            String id;
            String key = StringBundler.concat((String[])new String[]{groupId, ":", artifactId, ":", version});
            Iterator iterator = docsJSONArray.iterator();
            while (iterator.hasNext() && !(id = (docJSONObject = (JSONObject)iterator.next()).getString("id")).equals(key)) {
            }
        }
        long timestamp = docJSONObject.getLong("timestamp");
        return this._formatDate(timestamp);
    }

    private JSONObject _getMavenVersionDetailsJSONObject(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        JSONObject mavenVersionDetailsJSONObject = _mavenVersionDetailsCache.get(key);
        if (mavenVersionDetailsJSONObject != null) {
            return mavenVersionDetailsJSONObject;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://search.maven.org/solrsearch/select?q=g:");
        sb.append(groupId);
        sb.append("+AND+");
        sb.append("a:");
        sb.append(artifactId);
        sb.append("&core=gav&rows=200&wt=json");
        try {
            URL url = new URL(sb.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == 200) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    response.append(line);
                }
                mavenVersionDetailsJSONObject = new JSONObject(response.toString());
                _mavenVersionDetailsCache.put(key, mavenVersionDetailsJSONObject);
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return mavenVersionDetailsJSONObject;
    }

    private void _writeDocument(Document document, String xml) throws IOException {
        try {
            OutputFormat outFormat = OutputFormat.createPrettyPrint();
            outFormat.setIndent("\t");
            outFormat.setOmitEncoding(true);
            outFormat.setExpandEmptyElements(false);
            outFormat.setPadText(false);
            FileOutputStream outputStream = new FileOutputStream(xml);
            XMLWriter xmlWriter = new XMLWriter((OutputStream)outputStream, outFormat);
            xmlWriter.write(document);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to write the " + xml), (Throwable)ioException);
            }
            throw new IOException("Unable to write the " + xml);
        }
    }

    static {
        _mavenVersionDetailsCache = new HashMap<String, JSONObject>();
        String projectDir = System.getProperty("project.dir");
        _dependenciesProperties = new Properties();
        try {
            BufferedInputStream developmentPropertiesInputStream = new BufferedInputStream(new FileInputStream(projectDir + "/lib/development/dependencies.properties"));
            BufferedInputStream portalPropertiesInputStream = new BufferedInputStream(new FileInputStream(projectDir + "/lib/portal/dependencies.properties"));
            _dependenciesProperties.load(developmentPropertiesInputStream);
            _dependenciesProperties.load(portalPropertiesInputStream);
            _dependenciesProperties.put("ant-contrib", "ant-contrib:ant-contrib:1.0b3");
            _dependenciesProperties.put("antelope", "com.liferay:ise.antelope:3.4.0");
            _dependenciesProperties.put("bsh", "org.beanshell:bsh:2.0b4");
            _dependenciesProperties.put("xmltask", "com.oopsconsultancy:xmltask:1.16");
            ((InputStream)developmentPropertiesInputStream).close();
            ((InputStream)portalPropertiesInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            _log.error((Throwable)fileNotFoundException);
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
    }
}

