/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.layout.admin.kernel.model.LayoutTypePortletConstants;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.PortalPreferencesImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

public class UpgradeCustomizablePortlets
extends UpgradeProcess {
    private static final String _PREFIX = "<name>com.liferay.portal.model.CustomizedPages";
    private static final String _SUFFIX = "</name>";

    public static String namespacePlid(long plid) {
        return "com.liferay.portal.model.CustomizedPages".concat(String.valueOf(plid));
    }

    protected void doUpgrade() throws Exception {
        this.upgradeCustomizablePreferences();
    }

    protected PortalPreferencesImpl getPortalPreferencesImpl(long ownerId, int ownerType, String xml) {
        return (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)ownerType, (String)xml);
    }

    protected void upgradeCustomizablePreferences() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select portalPreferencesId, ownerId, ownerType, preferences from PortalPreferences where preferences like '%com.liferay.portal.model.CustomizedPages%'");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortalPreferences set preferences = ? where portalPreferencesId = ?");){
            while (resultSet.next()) {
                long portalPreferencesId = resultSet.getLong("portalPreferencesId");
                long ownerId = resultSet.getLong("ownerId");
                int ownerType = resultSet.getInt("ownerType");
                String preferences = resultSet.getString("preferences");
                PortalPreferencesImpl portalPreferencesImpl = this.getPortalPreferencesImpl(ownerId, ownerType, preferences);
                this.upgradeCustomizablePreferences(portalPreferencesImpl, ownerId, ownerType, preferences);
                preparedStatement2.setString(1, portalPreferencesImpl.toXML());
                preparedStatement2.setLong(2, portalPreferencesId);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void upgradeCustomizablePreferences(PortalPreferencesImpl portalPreferencesImpl, long ownerId, int ownerType, String preferences) throws Exception {
        int x = preferences.indexOf(_PREFIX);
        int y = -1;
        if (x != -1) {
            y = preferences.indexOf(_SUFFIX, x += _PREFIX.length());
        } else {
            return;
        }
        while (x != -1) {
            String[] parts = StringUtil.split((String)preferences.substring(x, y), (String)"#");
            String key = GetterUtil.getString((String)parts[1]);
            if (LayoutTypePortletConstants.isLayoutTemplateColumnName((String)key)) {
                long plid = GetterUtil.getLong((String)parts[0]);
                String value = portalPreferencesImpl.getValue(UpgradeCustomizablePortlets.namespacePlid(plid), key);
                ArrayList<String> newPortletIds = new ArrayList<String>();
                StringBundler sb = new StringBundler(4);
                sb.append("update PortletPreferences set ownerId = ?, ");
                sb.append("ownerType = ?, plid = ?, portletId = ? where ");
                sb.append("ownerId = ? and ownerType = ? and plid = ? and ");
                sb.append("portletId = ?");
                try (PreparedStatement preparedStatement = this.connection.prepareStatement(sb.toString());){
                    for (String customPortletId : StringUtil.split((String)value)) {
                        if (!PortletIdCodec.hasInstanceId((String)customPortletId)) {
                            newPortletIds.add(customPortletId);
                            continue;
                        }
                        String instanceId = PortletIdCodec.decodeInstanceId((String)customPortletId);
                        String newPortletId = PortletIdCodec.encode((String)PortletIdCodec.decodePortletName((String)customPortletId), (long)ownerId, (String)instanceId);
                        preparedStatement.setLong(1, ownerId);
                        preparedStatement.setInt(2, 4);
                        preparedStatement.setLong(3, plid);
                        preparedStatement.setString(4, newPortletId);
                        preparedStatement.setLong(5, 0L);
                        preparedStatement.setInt(6, 3);
                        preparedStatement.setLong(7, plid);
                        preparedStatement.setString(8, newPortletId);
                        newPortletIds.add(newPortletId);
                        preparedStatement.addBatch();
                    }
                    preparedStatement.executeBatch();
                }
                value = StringUtil.merge(newPortletIds);
                portalPreferencesImpl.setValue(UpgradeCustomizablePortlets.namespacePlid(plid), key, value);
            }
            x = preferences.indexOf(_PREFIX, y);
            y = -1;
            if (x == -1) continue;
            y = preferences.indexOf(_SUFFIX, x += _PREFIX.length());
        }
    }
}

