/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.instance.PortalInstancePool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.TreeModel;
import com.liferay.portal.kernel.tree.TreeModelTasks;
import com.liferay.portal.kernel.tree.TreeModelTasksAdapter;
import com.liferay.portal.kernel.tree.TreePathUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpgradeDocumentLibrary
extends UpgradeProcess {
    private static final String _SELECT_DLFOLDER_BY_PARENT = "select folderId from DLFolder dlFolder where dlFolder.folderId > ? and dlFolder.companyId = ? and dlFolder.parentFolderId = ? and dlFolder.status != ?";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeDocumentLibrary.class);

    protected void doUpgrade() throws Exception {
        this.alterTableAddColumn("DLFileEntryType", "fileEntryTypeKey", "VARCHAR(75) null");
        this.alterColumnType("DLFileEntryType", "name", "STRING null");
        this.updateFileEntryTypes();
        this.updateDLFolderUserName();
        this.updateTreePath();
    }

    /*
     * Exception decompiling
     */
    protected String getUserName(long userId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String localize(long companyId, String content, String key) throws Exception {
        String languageId = UpgradeProcessUtil.getDefaultLanguageId((long)companyId);
        return LocalizationUtil.updateLocalization((Map)HashMapBuilder.put((Object)LocaleUtil.fromLanguageId((String)languageId), (Object)content).build(), (String)"", (String)key, (String)languageId);
    }

    protected void rebuildTree(long companyId, final PreparedStatement folderPreparedStatement, final PreparedStatement fileEntryPreparedStatement, final PreparedStatement fileShortcutPreparedStatement, final PreparedStatement fileVersionPreparedStatement) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)0L, (String)"/", (TreeModelTasks)new TreeModelTasksAdapter<DLFolderTreeModel>(){

            public List<DLFolderTreeModel> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                ArrayList<DLFolderTreeModel> treeModels = new ArrayList<DLFolderTreeModel>();
                try (PreparedStatement preparedStatement = UpgradeDocumentLibrary.this.connection.prepareStatement(UpgradeDocumentLibrary._SELECT_DLFOLDER_BY_PARENT);){
                    preparedStatement.setLong(1, previousId);
                    preparedStatement.setLong(2, companyId);
                    preparedStatement.setLong(3, parentPrimaryKey);
                    preparedStatement.setInt(4, 8);
                    preparedStatement.setFetchSize(size);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            long folderId = resultSet.getLong(1);
                            DLFolderTreeModel treeModel = new DLFolderTreeModel(folderPreparedStatement);
                            treeModel.setPrimaryKeyObj(Long.valueOf(folderId));
                            treeModels.add(treeModel);
                        }
                    }
                }
                catch (SQLException sqlException) {
                    _log.error((Object)("Unable to get folders with parent primary key " + parentPrimaryKey), (Throwable)sqlException);
                }
                return treeModels;
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException {
                try {
                    fileEntryPreparedStatement.setString(1, treePath);
                    fileEntryPreparedStatement.setLong(2, parentPrimaryKey);
                    fileEntryPreparedStatement.addBatch();
                }
                catch (SQLException sqlException) {
                    _log.error((Object)("Unable to update file entries with tree path " + treePath), (Throwable)sqlException);
                }
                try {
                    fileShortcutPreparedStatement.setString(1, treePath);
                    fileShortcutPreparedStatement.setLong(2, parentPrimaryKey);
                    fileShortcutPreparedStatement.addBatch();
                }
                catch (SQLException sqlException) {
                    _log.error((Object)("Unable to update file shortcuts with tree path " + treePath), (Throwable)sqlException);
                }
                try {
                    fileVersionPreparedStatement.setString(1, treePath);
                    fileVersionPreparedStatement.setLong(2, parentPrimaryKey);
                    fileVersionPreparedStatement.addBatch();
                }
                catch (SQLException sqlException) {
                    _log.error((Object)("Unable to update file versions with tree path " + treePath), (Throwable)sqlException);
                }
            }
        });
    }

    protected void updateDLFolderUserName() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select distinct userId from DLFolder where userName is null or userName = ''");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update DLFolder set userName = ? where userId = ? and (userName is null or userName = '')");){
            while (resultSet.next()) {
                long userId = resultSet.getLong("userId");
                String userName = this.getUserName(userId);
                if (Validator.isNotNull((String)userName)) {
                    preparedStatement2.setString(1, userName);
                    preparedStatement2.setLong(2, userId);
                    preparedStatement2.addBatch();
                    continue;
                }
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("User " + userId + " does not exist"));
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void updateFileEntryType(long fileEntryTypeId, long companyId, String fileEntryTypeKey, String name, String description) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update DLFileEntryType set fileEntryTypeKey = ?, name = ?, description = ? where fileEntryTypeId = ?");){
            preparedStatement.setString(1, fileEntryTypeKey);
            preparedStatement.setString(2, this.localize(companyId, name, "Name"));
            preparedStatement.setString(3, this.localize(companyId, description, "Description"));
            preparedStatement.setLong(4, fileEntryTypeId);
            preparedStatement.executeUpdate();
        }
    }

    protected void updateFileEntryTypes() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select fileEntryTypeId, companyId, name, description from DLFileEntryType");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long fileEntryTypeId = resultSet.getLong("fileEntryTypeId");
                long companyId = resultSet.getLong("companyId");
                String name = GetterUtil.getString((String)resultSet.getString("name"));
                String description = resultSet.getString("description");
                if (fileEntryTypeId == 0L) {
                    name = "basic-document";
                }
                this.updateFileEntryType(fileEntryTypeId, companyId, StringUtil.toUpperCase((String)name), name, description);
            }
        }
    }

    protected void updateTreePath() throws Exception {
        this._runSQL("create index IX_LPP_41834_YGUA on DLFileEntry (folderId);");
        this._runSQL("create index IX_LPP_41834_UQAZ on DLFileShortcut (folderId);");
        this._runSQL("create index IX_LPP_41834_ABGC on DLFileVersion (folderId);");
        this._runSQL("create index IX_LPP_41834_PWBE on DLFolder (companyId, parentFolderId, status);");
        this._runSQL("create index IX_LPP_41834_EYIW on DLFolder (userId);");
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstancePool.getCompanyIds()) {
                try (PreparedStatement folderPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFolder set treePath = ? where folderId = ?");
                     PreparedStatement fileEntryPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFileEntry set treePath = ? where folderId = ?");
                     PreparedStatement fileShortcutPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFileShortcut set treePath = ? where folderId = ?");
                     PreparedStatement fileVersionPreparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update DLFileVersion set treePath = ? where folderId = ?");){
                    try {
                        this.rebuildTree(companyId, folderPreparedStatement, fileEntryPreparedStatement, fileShortcutPreparedStatement, fileVersionPreparedStatement);
                    }
                    catch (PortalException portalException) {
                        _log.error((Object)("Unable to update tree paths for company " + companyId), (Throwable)portalException);
                    }
                    folderPreparedStatement.executeBatch();
                    fileEntryPreparedStatement.executeBatch();
                    fileShortcutPreparedStatement.executeBatch();
                    fileVersionPreparedStatement.executeBatch();
                }
            }
        }
        catch (SQLException sqlException) {
            _log.error((Object)"Unable to update tree paths", (Throwable)sqlException);
        }
    }

    private void _runSQL(String sql) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(sql);){
            this.runSQL(sql);
        }
    }

    private class DLFolderTreeModel
    implements TreeModel {
        private long _folderId;
        private final PreparedStatement _preparedStatement;

        public DLFolderTreeModel(PreparedStatement preparedStatement) {
            this._preparedStatement = preparedStatement;
        }

        public String buildTreePath() throws PortalException {
            return null;
        }

        public Serializable getPrimaryKeyObj() {
            return Long.valueOf(this._folderId);
        }

        public String getTreePath() {
            return null;
        }

        public void setPrimaryKeyObj(Serializable primaryKeyObj) {
            this._folderId = (Long)primaryKeyObj;
        }

        public void updateTreePath(String treePath) {
            try {
                this._preparedStatement.setString(1, treePath);
                this._preparedStatement.setLong(2, this._folderId);
                this._preparedStatement.addBatch();
            }
            catch (SQLException sqlException) {
                _log.error((Object)("Unable to update tree path: " + treePath), (Throwable)sqlException);
            }
        }
    }
}

