/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.upgrade.v6_2_0.BaseUpgradePortletPreferences;
import com.liferay.portal.upgrade.v6_2_0.util.RSSUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class UpgradeJournal
extends BaseUpgradePortletPreferences {
    private static final int _DDM_STRUCTURE_TYPE_DEFAULT = 0;
    private static final String _DDM_TEMPLATE_MODE_CREATE = "create";
    private static final String _DDM_TEMPLATE_TYPE_DISPLAY = "display";
    private static final String _PORTLET_ID_ASSET_PUBLISHER = "101";
    private static final String _PORTLET_ID_JOURNAL_CONTENT = "56";
    private static final String _PORTLET_ID_JOURNAL_CONTENT_LIST = "62";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournal.class);
    private final Map<String, Long> _classNameIds = new HashMap<String, Long>();
    private final Map<Long, Long> _companyGroupIds = new HashMap<Long, Long>();
    private final Map<String, String> _ddmDataTypes = new HashMap<String, String>();
    private final Map<String, String> _ddmMetadataAttributes = new HashMap<String, String>();
    private final Map<String, Long> _ddmStructureIds = new HashMap<String, Long>();
    private final Map<Long, Long> _ddmStructurePKs = new HashMap<Long, Long>();
    private final Map<String, String> _journalTypesToDDMTypes = new HashMap<String, String>();

    protected void addDDMStructure(String uuid, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long parentDDMStructureId, long classNameId, String ddmStructureKey, String name, String description, String xsd, String storageType, int type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("insert into DDMStructure (uuid_, structureId, groupId, ");
        sb.append("companyId, userId, userName, createDate, modifiedDate, ");
        sb.append("parentStructureId, classNameId, structureKey, name, ");
        sb.append("description, xsd, storageType, type_) values (?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, uuid);
            preparedStatement.setLong(2, ddmStructureId);
            preparedStatement.setLong(3, groupId);
            preparedStatement.setLong(4, companyId);
            preparedStatement.setLong(5, userId);
            preparedStatement.setString(6, userName);
            preparedStatement.setTimestamp(7, createDate);
            preparedStatement.setTimestamp(8, modifiedDate);
            preparedStatement.setLong(9, parentDDMStructureId);
            preparedStatement.setLong(10, classNameId);
            preparedStatement.setString(11, ddmStructureKey);
            preparedStatement.setString(12, name);
            preparedStatement.setString(13, description);
            preparedStatement.setString(14, this.getDDMXSD(xsd, this.getDefaultLocale(companyId)));
            preparedStatement.setString(15, storageType);
            preparedStatement.setInt(16, type);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to upgrade dynamic data mapping structure with UUID " + uuid));
            throw exception;
        }
    }

    protected void addDDMStructure(String uuid, long ddmStructureId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, String parentStructureId, String ddmStructureKey, String name, String description, String xsd) throws Exception {
        long insertedDDMStructureId;
        long parentDDMStructureId = 0L;
        if (Validator.isNotNull((String)parentStructureId)) {
            parentDDMStructureId = this.updateStructure(parentStructureId);
        }
        if ((insertedDDMStructureId = this.getDDMStructureId(groupId, ddmStructureKey, false)) == 0L) {
            this.addDDMStructure(uuid, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentDDMStructureId, this._getClassNameId("com.liferay.portlet.journal.model.JournalArticle"), ddmStructureKey, name, description, xsd, "xml", 0);
        }
    }

    protected void addDDMTemplate(String uuid, long ddmTemplateId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long classNameId, long classPK, String templateKey, String name, String description, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, long smallImageId, String smallImageURL) throws Exception {
        StringBundler sb = new StringBundler(6);
        sb.append("insert into DDMTemplate (uuid_, templateId, groupId, ");
        sb.append("companyId, userId, userName, createDate, modifiedDate,");
        sb.append("classNameId, classPK , templateKey, name, description,");
        sb.append("type_, mode_, language, script, cacheable, smallImage,");
        sb.append("smallImageId, smallImageURL) values (?, ?, ?, ?, ?, ?,?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        String sql = sb.toString();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            preparedStatement.setString(1, uuid);
            preparedStatement.setLong(2, ddmTemplateId);
            preparedStatement.setLong(3, groupId);
            preparedStatement.setLong(4, companyId);
            preparedStatement.setLong(5, userId);
            preparedStatement.setString(6, userName);
            preparedStatement.setTimestamp(7, createDate);
            preparedStatement.setTimestamp(8, modifiedDate);
            preparedStatement.setLong(9, classNameId);
            preparedStatement.setLong(10, classPK);
            preparedStatement.setString(11, templateKey);
            preparedStatement.setString(12, name);
            preparedStatement.setString(13, description);
            preparedStatement.setString(14, type);
            preparedStatement.setString(15, mode);
            preparedStatement.setString(16, language);
            preparedStatement.setString(17, script);
            preparedStatement.setBoolean(18, cacheable);
            preparedStatement.setBoolean(19, smallImage);
            preparedStatement.setLong(20, smallImageId);
            preparedStatement.setString(21, smallImageURL);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to upgrade dynamic data mapping template with UUID " + uuid));
            throw exception;
        }
    }

    protected void addMetadataEntry(Element metadataElement, String name, String value) {
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", name);
        entryElement.addCDATA(value);
    }

    protected void addResourcePermission(PreparedStatement preparedStatement, long companyId, String primKey, long roleId) {
        try {
            preparedStatement.setLong(1, this.increment(ResourcePermission.class.getName()));
            preparedStatement.setLong(2, companyId);
            preparedStatement.setString(3, "com.liferay.portlet.journal");
            preparedStatement.setInt(4, 4);
            preparedStatement.setString(5, primKey);
            preparedStatement.setLong(6, roleId);
            preparedStatement.setLong(7, 0L);
            preparedStatement.setLong(8, 1L);
            preparedStatement.addBatch();
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to insert ResourcePermission", (Throwable)exception);
        }
    }

    protected String decodeURL(String url) {
        try {
            return HttpComponentsUtil.decodeURL((String)url);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)illegalArgumentException);
            }
            return url;
        }
    }

    protected void doUpgrade() throws Exception {
        this.alterColumnName("JournalFeed", "feedType", "feedFormat VARCHAR(75) null");
        this.setUpStrutureAttributesMappings();
        this.updateContentSearch();
        this.updateLinkToLayoutContent();
        this.updateStructures();
        this.updateTemplates();
        this.upgradeURLTitle();
        this.updateAssetEntryClassTypeId();
        this.updateJournalResourcePermission();
        super.doUpgrade();
    }

    protected Element fetchMetadataEntry(Element parentElement, String attributeName, String attributeValue) {
        StringBundler sb = new StringBundler(5);
        sb.append("entry[@");
        sb.append(attributeName);
        sb.append("=");
        sb.append(HtmlUtil.escapeXPathAttribute((String)attributeValue));
        sb.append("]");
        XPath xPath = SAXReaderUtil.createXPath((String)sb.toString());
        return (Element)xPath.selectSingleNode((Object)parentElement);
    }

    /*
     * Exception decompiling
     */
    protected long getCompanyGroupId(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getDDMStructureClassNameId() {
        return this._getClassNameId("com.liferay.portlet.dynamicdatamapping.model.DDMStructure");
    }

    protected long getDDMStructureId(long groupId, long companyGroupId, String structureId) {
        return this.getDDMStructureId(groupId, companyGroupId, structureId, true);
    }

    protected long getDDMStructureId(long groupId, long companyGroupId, String structureId, boolean warn) {
        if (Validator.isNull((String)structureId)) {
            return 0L;
        }
        Long ddmStructureId = this._ddmStructureIds.get(groupId + "#" + structureId);
        if (ddmStructureId == null && companyGroupId != 0L) {
            ddmStructureId = this._ddmStructureIds.get(companyGroupId + "#" + structureId);
        }
        if (ddmStructureId != null) {
            return ddmStructureId;
        }
        if (warn && _log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(5);
            sb.append("Unable to get the DDM structure ID for group ");
            sb.append(groupId);
            if (companyGroupId != 0L) {
                sb.append(" or global group");
            }
            sb.append(" and journal structure ID ");
            sb.append(structureId);
            _log.warn((Object)sb.toString());
        }
        return 0L;
    }

    protected long getDDMStructureId(long groupId, String structureId, boolean warn) {
        return this.getDDMStructureId(groupId, 0L, structureId, warn);
    }

    protected String getDDMXSD(String journalXSD, Locale defaultLocale) throws Exception {
        Document document = SAXReaderUtil.read((String)journalXSD);
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("available-locales", defaultLocale.toString());
        rootElement.addAttribute("default-locale", defaultLocale.toString());
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLocale.toString());
        }
        return document.formattedString("  ");
    }

    protected Locale getDefaultLocale(long companyId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select languageId from User_ where companyId = ? and defaultUser = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setBoolean(2, true);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    String languageId = resultSet.getString("languageId");
                    Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                    return locale;
                }
            }
        }
        return LocaleUtil.getSiteDefault();
    }

    protected long getJournalStructureClassNameId() {
        return this._getClassNameId("com.liferay.portlet.journal.model.JournalStructure");
    }

    protected String[] getPortletIds() {
        return new String[]{"56_INSTANCE_%", "62_INSTANCE_%", "101_INSTANCE_%"};
    }

    /*
     * Exception decompiling
     */
    protected long getRoleId(String roleName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void removeAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return;
        }
        element.remove(attribute);
    }

    protected void setUpStrutureAttributesMappings() {
        this._ddmDataTypes.put("boolean", "boolean");
        this._ddmDataTypes.put("document_library", "document-library");
        this._ddmDataTypes.put("image", "image");
        this._ddmDataTypes.put("link_to_layout", "link-to-page");
        this._ddmDataTypes.put("list", "string");
        this._ddmDataTypes.put("multi-list", "string");
        this._ddmDataTypes.put("text", "string");
        this._ddmDataTypes.put("text_area", "html");
        this._ddmDataTypes.put("text_box", "string");
        this._ddmMetadataAttributes.put("instructions", "tip");
        this._ddmMetadataAttributes.put("label", "label");
        this._ddmMetadataAttributes.put("predefinedValue", "predefinedValue");
        this._journalTypesToDDMTypes.put("boolean", "checkbox");
        this._journalTypesToDDMTypes.put("document_library", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("image", "ddm-image");
        this._journalTypesToDDMTypes.put("image_gallery", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("link_to_layout", "ddm-link-to-page");
        this._journalTypesToDDMTypes.put("list", "select");
        this._journalTypesToDDMTypes.put("multi-list", "select");
        this._journalTypesToDDMTypes.put("selection_break", "ddm-separator");
        this._journalTypesToDDMTypes.put("text", "text");
        this._journalTypesToDDMTypes.put("text_area", "ddm-text-html");
        this._journalTypesToDDMTypes.put("text_box", "textarea");
    }

    protected void updateAssetEntryClassTypeId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform("select distinct companyId, groupId, resourcePrimKey, structureId from JournalArticle where structureId != ''"));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            long classNameId = this._getClassNameId("com.liferay.portlet.journal.model.JournalArticle");
            try (PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update AssetEntry set classTypeId = ? where classNameId = ? AND classPK = ?");){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    long companyId = resultSet.getLong("companyId");
                    long resourcePrimKey = resultSet.getLong("resourcePrimKey");
                    String structureId = resultSet.getString("structureId");
                    preparedStatement2.setLong(1, this.getDDMStructureId(groupId, this.getCompanyGroupId(companyId), structureId));
                    preparedStatement2.setLong(2, classNameId);
                    preparedStatement2.setLong(3, resourcePrimKey);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }

    protected void updateContentSearch() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select groupId, portletId from JournalContentSearch group by groupId, portletId having count(groupId) > 1 and count(portletId) > 1");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("groupId");
                String portletId = resultSet.getString("portletId");
                this.updateContentSearch(groupId, portletId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateContentSearch(long groupId, String portletId) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select preferences from PortletPreferences inner join Layout on PortletPreferences.plid = Layout.plid where groupId = ? and portletId = ?");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select companyId, privateLayout, layoutId, portletId from JournalContentSearch where JournalContentSearch.groupId = ? and JournalContentSearch.articleId = ?");
             PreparedStatement preparedStatement3 = this.connection.prepareStatement("delete from JournalContentSearch where JournalContentSearch.groupId = ? and JournalContentSearch.articleId = ?");
             PreparedStatement preparedStatement4 = this.connection.prepareStatement("insert into JournalContentSearch(contentSearchId, companyId, groupId, privateLayout, layoutId, portletId, articleId) values (?, ?, ?, ?, ?, ?, ?)");){
            preparedStatement1.setLong(1, groupId);
            preparedStatement1.setString(2, portletId);
            try (ResultSet resultSet1 = preparedStatement1.executeQuery();){
                while (resultSet1.next()) {
                    ResultSet resultSet2;
                    block71: {
                        String xml = resultSet1.getString("preferences");
                        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromDefaultXML((String)xml);
                        String articleId = portletPreferences.getValue("articleId", null);
                        preparedStatement2.setLong(1, groupId);
                        preparedStatement2.setString(2, articleId);
                        resultSet2 = preparedStatement2.executeQuery();
                        Throwable throwable = null;
                        try {
                            if (resultSet2.next()) {
                                long companyId = resultSet2.getLong("companyId");
                                boolean privateLayout = resultSet2.getBoolean("privateLayout");
                                long layoutId = resultSet2.getLong("layoutId");
                                String journalContentSearchPortletId = resultSet2.getString("portletId");
                                preparedStatement3.setLong(1, groupId);
                                preparedStatement3.setString(2, articleId);
                                preparedStatement3.executeUpdate();
                                preparedStatement4.setLong(1, this.increment());
                                preparedStatement4.setLong(2, companyId);
                                preparedStatement4.setLong(3, groupId);
                                preparedStatement4.setBoolean(4, privateLayout);
                                preparedStatement4.setLong(5, layoutId);
                                preparedStatement4.setString(6, journalContentSearchPortletId);
                                preparedStatement4.setString(7, articleId);
                                preparedStatement4.executeUpdate();
                            }
                            if (resultSet2 == null) continue;
                            if (throwable == null) break block71;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (resultSet2 == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        resultSet2.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                resultSet2.close();
                                throw throwable3;
                            }
                        }
                        try {
                            resultSet2.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    resultSet2.close();
                }
                return;
            }
        }
    }

    protected void updateElement(long groupId, Element element) {
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateElement(groupId, dynamicElementElement);
        }
        String type = element.attributeValue("type");
        if (type.equals("link_to_layout")) {
            this.updateLinkToLayoutElements(groupId, element);
        }
    }

    protected void updateJournalArticleClassNameIdAndClassPK(long journalStructureId, Long ddmStructureId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update JournalArticle set classNameId = ?, classPK = ? where classNameId = ? and classPK = ?");){
            preparedStatement.setLong(1, this.getDDMStructureClassNameId());
            preparedStatement.setLong(2, ddmStructureId);
            preparedStatement.setLong(3, this.getJournalStructureClassNameId());
            preparedStatement.setLong(4, journalStructureId);
            preparedStatement.execute();
        }
    }

    protected void updateJournalResourcePermission() throws Exception {
        long guestRoleId = this.getRoleId("Guest");
        long ownerRoleId = this.getRoleId("Owner");
        long siteMemberRoleId = this.getRoleId("Site Member");
        StringBundler updateSB = new StringBundler(10);
        updateSB.append("update ResourcePermission set actionIds = actionIds ");
        updateSB.append("+ 1 where name = 'com.liferay.portlet.journal' and ");
        updateSB.append("roleId in (");
        updateSB.append(guestRoleId);
        updateSB.append(",");
        updateSB.append(ownerRoleId);
        updateSB.append(",");
        updateSB.append(siteMemberRoleId);
        updateSB.append(") and ownerId = 0 and MOD(actionIds, 2) = 0 and ");
        updateSB.append("scope = 4");
        this.runSQL(updateSB.toString());
        StringBundler selectSB = new StringBundler(10);
        selectSB.append("select companyId, primKey, roleId from ");
        selectSB.append("ResourcePermission where name = ");
        selectSB.append("'com.liferay.portlet.journal' and ownerId = 0 and ");
        selectSB.append("scope = 4 and roleId in (");
        selectSB.append(guestRoleId);
        selectSB.append(",");
        selectSB.append(ownerRoleId);
        selectSB.append(",");
        selectSB.append(siteMemberRoleId);
        selectSB.append(") order by companyId, primKey, roleId");
        StringBundler insertSB = new StringBundler(4);
        insertSB.append("insert into ResourcePermission ");
        insertSB.append("(resourcePermissionId, companyId, name, scope, ");
        insertSB.append("primKey, roleId, ownerId, actionIds) values (?, ?, ");
        insertSB.append("?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(selectSB.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)insertSB.toString());
             ResultSet resultSet = preparedStatement1.executeQuery();){
            long currentCompanyId = 0L;
            String currentPrimKey = null;
            boolean hasGuestResourcePermissions = false;
            boolean hasOwnerResourcePermissions = false;
            boolean hasSiteMemberResourcePermissions = false;
            while (resultSet.next()) {
                long companyId = resultSet.getLong("companyId");
                String primKey = resultSet.getString("primKey");
                long roleId = resultSet.getLong("roleId");
                if (currentPrimKey != null && !primKey.equals(currentPrimKey)) {
                    if (!hasGuestResourcePermissions) {
                        this.addResourcePermission(preparedStatement2, currentCompanyId, currentPrimKey, guestRoleId);
                    }
                    if (!hasOwnerResourcePermissions) {
                        this.addResourcePermission(preparedStatement2, currentCompanyId, currentPrimKey, ownerRoleId);
                    }
                    if (!hasSiteMemberResourcePermissions) {
                        this.addResourcePermission(preparedStatement2, currentCompanyId, currentPrimKey, siteMemberRoleId);
                    }
                    currentPrimKey = primKey;
                    currentCompanyId = companyId;
                    hasGuestResourcePermissions = false;
                    hasOwnerResourcePermissions = false;
                    hasSiteMemberResourcePermissions = false;
                }
                if (currentPrimKey == null) {
                    currentCompanyId = companyId;
                    currentPrimKey = primKey;
                }
                if (guestRoleId == roleId) {
                    hasGuestResourcePermissions = true;
                    continue;
                }
                if (ownerRoleId == roleId) {
                    hasOwnerResourcePermissions = true;
                    continue;
                }
                if (siteMemberRoleId != roleId) continue;
                hasSiteMemberResourcePermissions = true;
            }
            if (currentPrimKey != null) {
                if (!hasGuestResourcePermissions) {
                    this.addResourcePermission(preparedStatement2, currentCompanyId, currentPrimKey, guestRoleId);
                }
                if (!hasOwnerResourcePermissions) {
                    this.addResourcePermission(preparedStatement2, currentCompanyId, currentPrimKey, ownerRoleId);
                }
                if (!hasSiteMemberResourcePermissions) {
                    this.addResourcePermission(preparedStatement2, currentCompanyId, currentPrimKey, siteMemberRoleId);
                }
            }
            preparedStatement2.executeBatch();
        }
    }

    protected void updateJournalXSDDynamicElement(Element element, String defaultLanguageId) {
        String name = element.attributeValue("name");
        String type = element.attributeValue("type");
        Element metadataElement = element.element("meta-data");
        if (metadataElement == null) {
            metadataElement = element.addElement("meta-data");
        }
        if (type.equals("multi-list")) {
            element.addAttribute("multiple", "true");
        } else {
            Element parentElement = element.getParent();
            String parentType = parentElement.attributeValue("type");
            if (parentType != null && parentType.equals("select")) {
                metadataElement.addAttribute("locale", defaultLanguageId);
                this.addMetadataEntry(metadataElement, "label", this.decodeURL(name));
                this.removeAttribute(element, "index-type");
                element.addAttribute("name", "option" + StringUtil.randomId());
                element.addAttribute("type", "option");
                element.addAttribute("value", this.decodeURL(type));
                return;
            }
        }
        String indexType = "";
        Attribute indexTypeAttribute = element.attribute("index-type");
        if (indexTypeAttribute != null) {
            indexType = indexTypeAttribute.getValue();
            element.remove(indexTypeAttribute);
        }
        element.remove(element.attribute("type"));
        if (!type.equals("selection_break")) {
            String dataType = this._ddmDataTypes.get(type);
            if (dataType == null) {
                dataType = "string";
            }
            element.addAttribute("dataType", dataType);
        }
        element.addAttribute("indexType", indexType);
        String required = "false";
        Element requiredElement = this.fetchMetadataEntry(metadataElement, "name", "required");
        if (requiredElement != null) {
            required = requiredElement.getText();
        }
        element.addAttribute("required", required);
        element.addAttribute("showLabel", "true");
        String newType = this._journalTypesToDDMTypes.get(type);
        if (newType == null) {
            newType = type;
        }
        element.addAttribute("type", newType);
        if (newType.startsWith("ddm")) {
            element.addAttribute("fieldNamespace", "ddm");
        }
        metadataElement.addAttribute("locale", defaultLanguageId);
        List entryElements = metadataElement.elements();
        if (entryElements.isEmpty()) {
            this.addMetadataEntry(metadataElement, "label", name);
        } else {
            for (Element entryElement : entryElements) {
                String oldEntryName = entryElement.attributeValue("name");
                String newEntryName = this._ddmMetadataAttributes.get(oldEntryName);
                if (newEntryName == null) {
                    metadataElement.remove(entryElement);
                    continue;
                }
                entryElement.addAttribute("name", newEntryName);
            }
        }
        if (newType.equals("ddm-date") || newType.equals("ddm-decimal") || newType.equals("ddm-integer") || newType.equals("ddm-link-to-page") || newType.equals("ddm-number") || newType.equals("ddm-text-html") || newType.equals("text") || newType.equals("textarea")) {
            element.addAttribute("width", "25");
        } else if (newType.equals("ddm-image")) {
            element.addAttribute("fieldNamespace", "ddm");
            element.addAttribute("readOnly", "false");
        }
        element.add(metadataElement.detach());
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLanguageId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateLinkToLayoutContent() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform("select id_, groupId, content from JournalArticle where structureId != '' and content like '%link_to_layout%'"));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                long id = resultSet.getLong("id_");
                long groupId = resultSet.getLong("groupId");
                String content = resultSet.getString("content");
                try {
                    Document document = SAXReaderUtil.read((String)content);
                    Element rootElement = document.getRootElement();
                    for (Element element : rootElement.elements()) {
                        this.updateElement(groupId, element);
                    }
                    preparedStatement2.setString(1, document.asXML());
                    preparedStatement2.setLong(2, id);
                    preparedStatement2.addBatch();
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to update content for article " + id), (Throwable)exception);
                }
            }
            preparedStatement2.executeBatch();
            return;
        }
    }

    protected void updateLinkToLayoutElements(long groupId, Element element) {
        Element dynamicContentElement = element.element("dynamic-content");
        Node node = dynamicContentElement.node(0);
        String text = node.getText();
        if (!text.isEmpty() && !text.endsWith("@" + groupId)) {
            node.setText(dynamicContentElement.getStringValue() + "@" + groupId);
        }
    }

    protected void updatePreferencesClassPKs(PortletPreferences portletPreferences, String key) throws Exception {
        String[] oldValues = portletPreferences.getValues(key, null);
        if (oldValues == null) {
            return;
        }
        String[] newValues = new String[oldValues.length];
        for (int i = 0; i < oldValues.length; ++i) {
            String[] oldPrimaryKeys;
            String oldValue;
            String newValue = oldValue = oldValues[i];
            for (String oldPrimaryKey : oldPrimaryKeys = StringUtil.split((String)oldValue)) {
                if (!Validator.isNumber((String)oldPrimaryKey)) break;
                Long newPrimaryKey = this._ddmStructurePKs.get(GetterUtil.getLong((String)oldPrimaryKey));
                if (!Validator.isNotNull((Long)newPrimaryKey)) continue;
                newValue = StringUtil.replace((String)newValue, (String)oldPrimaryKey, (String)String.valueOf(newPrimaryKey));
            }
            newValues[i] = newValue;
        }
        portletPreferences.setValues(key, newValues);
    }

    protected void updateResourcePermission(long companyId, String oldClassName, String newClassName, long oldPrimKey, long newPrimKey) throws Exception {
        StringBundler sb = new StringBundler(11);
        sb.append("update ResourcePermission set name = '");
        sb.append(newClassName);
        sb.append("', primKey = '");
        sb.append(newPrimKey);
        sb.append("' where companyId = ");
        sb.append(companyId);
        sb.append(" and name = '");
        sb.append(oldClassName);
        sb.append("' and primKey = '");
        sb.append(oldPrimKey);
        sb.append("'");
        this.runSQL(sb.toString());
    }

    protected long updateStructure(ResultSet resultSet) throws Exception {
        long groupId = resultSet.getLong("groupId");
        String structureId = resultSet.getString("structureId");
        Long ddmStructureId = this._ddmStructureIds.get(groupId + "#" + structureId);
        if (ddmStructureId != null) {
            return ddmStructureId;
        }
        ddmStructureId = this.increment();
        String uuid_ = resultSet.getString("uuid_");
        long companyId = resultSet.getLong("companyId");
        long userId = resultSet.getLong("userId");
        String userName = resultSet.getString("userName");
        Timestamp createDate = resultSet.getTimestamp("createDate");
        Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
        String parentStructureId = resultSet.getString("parentStructureId");
        String name = resultSet.getString("name");
        String description = resultSet.getString("description");
        String xsd = resultSet.getString("xsd");
        this.addDDMStructure(uuid_, ddmStructureId, groupId, companyId, userId, userName, createDate, modifiedDate, parentStructureId, structureId, name, description, xsd);
        long id_ = resultSet.getLong("id_");
        this.updateJournalArticleClassNameIdAndClassPK(id_, ddmStructureId);
        this.updateResourcePermission(companyId, "com.liferay.portlet.journal.model.JournalStructure", "com.liferay.portlet.dynamicdatamapping.model.DDMStructure", id_, ddmStructureId);
        this._ddmStructureIds.put(groupId + "#" + structureId, ddmStructureId);
        this._ddmStructurePKs.put(id_, ddmStructureId);
        return ddmStructureId;
    }

    /*
     * Exception decompiling
     */
    protected long updateStructure(String structureId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateStructures() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select * from JournalStructure");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                this.updateStructure(resultSet);
            }
            this.dropTable("JournalStructure");
        }
    }

    protected void updateTemplates() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select * from JournalTemplate");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String uuid_ = resultSet.getString("uuid_");
                long id_ = resultSet.getLong("id_");
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Timestamp createDate = resultSet.getTimestamp("createDate");
                Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
                String templateId = resultSet.getString("templateId");
                String structureId = resultSet.getString("structureId");
                String name = resultSet.getString("name");
                String description = resultSet.getString("description");
                String language = resultSet.getString("langType");
                String script = resultSet.getString("xsl");
                boolean cacheable = resultSet.getBoolean("cacheable");
                boolean smallImage = resultSet.getBoolean("smallImage");
                long smallImageId = resultSet.getLong("smallImageId");
                String smallImageURL = resultSet.getString("smallImageURL");
                long ddmTemplateId = this.increment();
                long classNameId = this.getDDMStructureClassNameId();
                long classPK = this.getDDMStructureId(groupId, this.getCompanyGroupId(companyId), structureId);
                this.addDDMTemplate(uuid_, ddmTemplateId, groupId, companyId, userId, userName, createDate, modifiedDate, classNameId, classPK, templateId, name, description, _DDM_TEMPLATE_TYPE_DISPLAY, _DDM_TEMPLATE_MODE_CREATE, language, script, cacheable, smallImage, smallImageId, smallImageURL);
                this.updateResourcePermission(companyId, "com.liferay.portlet.journal.model.JournalTemplate", "com.liferay.portlet.dynamicdatamapping.model.DDMTemplate", id_, ddmTemplateId);
            }
            this.dropTable("JournalTemplate");
        }
    }

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        String structureId;
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        if (portletId.startsWith(_PORTLET_ID_ASSET_PUBLISHER)) {
            this.updatePreferencesClassPKs(portletPreferences, "anyClassTypeJournalArticleAssetRendererFactory");
            this.updatePreferencesClassPKs(portletPreferences, "classTypeIds");
            this.updatePreferencesClassPKs(portletPreferences, "classTypeIdsJournalArticleAssetRendererFactory");
            this.upgradeRss(portletPreferences);
            this.upgradeScopeIds(portletPreferences);
        } else if (portletId.startsWith(_PORTLET_ID_JOURNAL_CONTENT)) {
            String templateId = portletPreferences.getValue("templateId", "");
            if (Validator.isNotNull((String)templateId)) {
                portletPreferences.reset("templateId");
                portletPreferences.setValue("ddmTemplateKey", templateId);
            }
        } else if (portletId.startsWith(_PORTLET_ID_JOURNAL_CONTENT_LIST) && Validator.isNotNull((String)(structureId = portletPreferences.getValue("structureId", "")))) {
            portletPreferences.reset("structureId");
            portletPreferences.setValue("ddmStructureKey", structureId);
        }
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    protected void upgradeRss(PortletPreferences portletPreferences) throws Exception {
        String rssFormat = GetterUtil.getString((String)portletPreferences.getValue("rssFormat", null));
        if (Validator.isNotNull((String)rssFormat)) {
            portletPreferences.setValue("rssFeedType", RSSUtil.getFeedType(RSSUtil.getFormatType(rssFormat), RSSUtil.getFormatVersion(rssFormat)));
        }
        portletPreferences.reset("rssFormat");
    }

    protected void upgradeScopeIds(PortletPreferences portletPreferences) throws Exception {
        String defaultScope = GetterUtil.getString((String)portletPreferences.getValue("defaultScope", null));
        if (Validator.isNull((String)defaultScope)) {
            return;
        }
        if (defaultScope.equals("true")) {
            portletPreferences.setValues("scopeIds", new String[]{"Group_default"});
        } else if (!defaultScope.equals("false")) {
            portletPreferences.setValues("scopeIds", new String[]{defaultScope});
        }
        portletPreferences.reset("defaultScope");
    }

    protected void upgradeURLTitle() throws Exception {
        this._runSQL("create index IX_LPP_41834_UXEC on JournalArticle (urlTitle);");
        int count = 0;
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select distinct groupId, articleId, urlTitle from JournalArticle");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            HashMap<String, String> processedArticleIds = new HashMap<String, String>();
            try (PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.autoBatch((Connection)this.connection, (String)"update JournalArticle set urlTitle = ? where urlTitle = ?");){
                while (resultSet.next()) {
                    String normalizedURLTitle;
                    String urlTitle = GetterUtil.getString((String)resultSet.getString("urlTitle"));
                    if (urlTitle.equals(normalizedURLTitle = FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)urlTitle))) continue;
                    long groupId = resultSet.getLong("groupId");
                    String articleId = resultSet.getString("articleId");
                    normalizedURLTitle = this._getUniqueUrlTitle(groupId, articleId, normalizedURLTitle, processedArticleIds);
                    preparedStatement2.setString(1, normalizedURLTitle);
                    preparedStatement2.setString(2, urlTitle);
                    preparedStatement2.addBatch();
                    ++count;
                }
                preparedStatement2.executeBatch();
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Updated " + count + " journal articles"));
        }
    }

    private long _getClassNameId(String className) {
        Long classNameId = this._classNameIds.get(className);
        if (classNameId == null) {
            classNameId = PortalUtil.getClassNameId((String)className);
            this._classNameIds.put(className, classNameId);
        }
        return classNameId;
    }

    private String _getUniqueUrlTitle(long groupId, String articleId, String urlTitle, Map<String, String> processedArticleIds) throws Exception {
        int i = 1;
        while (true) {
            String key;
            String processedArticleId;
            if (((processedArticleId = processedArticleIds.get(key = groupId + "_" + urlTitle)) == null || processedArticleId.equals(articleId)) && this._isValidUrlTitle(groupId, articleId, urlTitle)) {
                processedArticleIds.put(key, articleId);
                return urlTitle;
            }
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean _isValidUrlTitle(long groupId, String articleId, String urlTitle) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void _runSQL(String sql) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(sql);){
            this.runSQL(sql);
        }
    }
}

