/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.upgrade.v6_2_0.UpgradeMVCCVersion;

public class UpgradeSchema
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._runSQLFile("update-6.1.1-6.2.0.sql", "update-6.1.1-6.2.0-dl.sql", "update-6.1.1-6.2.0-expando.sql", "update-6.1.1-6.2.0-group.sql", "update-6.1.1-6.2.0-journal.sql", "update-6.1.1-6.2.0-wiki.sql");
        if (DBManagerUtil.getDBType() == DBType.POSTGRESQL) {
            try (LoggingTimer loggingTimer = new LoggingTimer("_upgradeSchemaPostgreSQL");){
                this._upgradeSchemaPostgreSQL();
            }
        }
        try (LoggingTimer loggingTimer = new LoggingTimer("_upgradeSchemaDefault");){
            this._upgradeSchemaDefault();
        }
        if (this.hasIndex("Layout", "IX_CED31606")) {
            this.runSQL("drop index IX_CED31606 on Layout");
        }
        if (this.hasIndex("ResourcePermission", "IX_8DB864A9")) {
            this.runSQL("drop index IX_8DB864A9 on ResourcePermission");
        }
        this.upgrade((UpgradeProcess)new UpgradeMVCCVersion());
    }

    private void _runSQLFile(String ... sqlFileNames) throws Exception {
        for (String sqlFileName : sqlFileNames) {
            try (LoggingTimer loggingTimer = new LoggingTimer(sqlFileName);){
                this.runSQLFile(sqlFileName, false);
            }
        }
    }

    private void _upgradeSchemaDefault() throws Exception {
        String[] sqls = new String[]{"alter table JournalArticle add folderId LONG", "alter table JournalArticle add treePath STRING null", "update JournalArticle set folderId = 0, treePath = '/'", "alter table User_ add ldapServerId LONG", "update User_ set ldapServerId = -1"};
        this.runSQL(sqls);
    }

    private void _upgradeSchemaPostgreSQL() throws Exception {
        String[] sqls = new String[]{"alter table JournalArticle add folderId LONG default 0", "alter table JournalArticle alter column folderId drop default", "alter table JournalArticle add treePath STRING default '/'", "alter table JournalArticle alter column treePath drop default", "alter table User_ add ldapServerId LONG default -1", "alter table User_ alter column ldapServerId drop default"};
        this.runSQL(sqls);
    }
}

