/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class VerifyResourceActions
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyResourceActions.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteDuplicateBitwiseValuesOnResource() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement1 = this.connection.prepareStatement("select name, bitwiseValue, min(resourceActionId) as minResourceActionId from ResourceAction group by name, bitwiseValue having count(resourceActionId) > 1");
             PreparedStatement preparedStatement2 = this.connection.prepareStatement("select resourceActionId, actionId from ResourceAction where name = ? and bitwiseValue = ? and resourceActionId != ?");
             ResultSet resultSet1 = preparedStatement1.executeQuery();){
            while (resultSet1.next()) {
                ResultSet resultSet2;
                block60: {
                    String name = resultSet1.getString("name");
                    long bitwiseValue = resultSet1.getLong("bitwiseValue");
                    long minResourceActionId = resultSet1.getLong("minResourceActionId");
                    preparedStatement2.setString(1, name);
                    preparedStatement2.setLong(2, bitwiseValue);
                    preparedStatement2.setLong(3, minResourceActionId);
                    resultSet2 = preparedStatement2.executeQuery();
                    Throwable throwable = null;
                    try {
                        while (resultSet2.next()) {
                            if (_log.isInfoEnabled()) {
                                StringBundler sb = new StringBundler(7);
                                sb.append("Deleting resource action ");
                                sb.append(resultSet2.getString("actionId"));
                                sb.append(" from resource ");
                                sb.append(name);
                                sb.append(" because its bitwise value is the ");
                                sb.append("same as another resource action on ");
                                sb.append("the same resource");
                                _log.info((Object)sb.toString());
                            }
                            ResourceActionLocalServiceUtil.deleteResourceAction((long)resultSet2.getLong("resourceActionId"));
                        }
                        if (resultSet2 == null) continue;
                        if (throwable == null) break block60;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (resultSet2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    resultSet2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            resultSet2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        resultSet2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                resultSet2.close();
            }
            return;
        }
    }

    @Override
    protected void doVerify() throws Exception {
        this.deleteDuplicateBitwiseValuesOnResource();
    }
}

