/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVRequestImpl
implements WebDAVRequest {
    private static final String _APPLE_DOUBLE_PREFIX = "._";
    private final long _companyId;
    private final long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;
    private final String _lockUuid;
    private final boolean _manualCheckInRequired;
    private final String _path;
    private final PermissionChecker _permissionChecker;
    private final WebDAVStorage _storage;
    private final String _userAgent;
    private final long _userId;

    public WebDAVRequestImpl(WebDAVStorage storage, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String userAgent, PermissionChecker permissionChecker) throws WebDAVException {
        this._storage = storage;
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
        this._userAgent = userAgent;
        this._lockUuid = WebDAVUtil.getLockUuid((HttpServletRequest)httpServletRequest);
        String pathInfo = HttpComponentsUtil.fixPath((String)httpServletRequest.getPathInfo(), (boolean)false, (boolean)true);
        String strippedPathInfo = WebDAVUtil.stripManualCheckInRequiredPath((String)pathInfo);
        if (strippedPathInfo.length() != pathInfo.length()) {
            pathInfo = strippedPathInfo;
            this._manualCheckInRequired = true;
        } else {
            this._manualCheckInRequired = false;
        }
        this._path = WebDAVUtil.stripOfficeExtension((String)pathInfo);
        this._companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
        this._groupId = WebDAVUtil.getGroupId((long)this._companyId, (String)this._path);
        this._permissionChecker = permissionChecker;
        this._userId = GetterUtil.getLong((String)httpServletRequest.getRemoteUser());
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._httpServletResponse;
    }

    public String getLockUuid() {
        return this._lockUuid;
    }

    public String getPath() {
        return this._path;
    }

    public String[] getPathArray() {
        return WebDAVUtil.getPathArray((String)this._path);
    }

    public PermissionChecker getPermissionChecker() {
        return this._permissionChecker;
    }

    public String getRootPath() {
        return this._storage.getRootPath();
    }

    public long getUserId() {
        return this._userId;
    }

    public WebDAVStorage getWebDAVStorage() {
        return this._storage;
    }

    public boolean isAppleDoubleRequest() {
        String name = WebDAVUtil.getResourceName((String[])this.getPathArray());
        return this.isMac() && name.startsWith(_APPLE_DOUBLE_PREFIX);
    }

    public boolean isLitmus() {
        return this._userAgent.contains("litmus");
    }

    public boolean isMac() {
        return this._userAgent.contains("WebDAVFS");
    }

    public boolean isManualCheckInRequired() {
        return this._manualCheckInRequired;
    }

    public boolean isWindows() {
        return this._userAgent.contains("Microsoft Data Access Internet Publishing Provider");
    }
}

