/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.FileEntryExpiredException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.processor.AudioProcessorUtil;
import com.liferay.document.library.kernel.processor.ImageProcessorUtil;
import com.liferay.document.library.kernel.processor.PDFProcessorUtil;
import com.liferay.document.library.kernel.processor.VideoProcessorUtil;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.image.ImageToolUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.OrganizationTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.friendly.url.resolver.FileEntryFriendlyURLResolver;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.util.FileEntryHttpHeaderCustomizerUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.trash.helper.TrashHelper;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerEntry;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebServerServlet
extends HttpServlet {
    public static final String PATH_PORTLET_FILE_ENTRY = "portlet_file_entry";
    private static final String _PATH_SEPARATOR_FILE_ENTRY = "d";
    private static final boolean _WEB_SERVER_SERVLET_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsValues.WEB_SERVER_SERVLET_VERSION_VERBOSITY, (String)ReleaseInfo.getName());
    private static final boolean _WEB_SERVER_SERVLET_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsValues.WEB_SERVER_SERVLET_VERSION_VERBOSITY, (String)"partial");
    private static final Log _log = LogFactoryUtil.getLog(WebServerServlet.class);
    private static final Set<String> _acceptRangesMimeTypes = SetUtil.fromArray((Object[])PropsValues.WEB_SERVER_SERVLET_ACCEPT_RANGES_MIME_TYPES);
    private static final Snapshot<FileEntryFriendlyURLResolver> _fileEntryFriendlyURLResolverSnapshot = new Snapshot(WebServerServlet.class, FileEntryFriendlyURLResolver.class);
    private static final Snapshot<InactiveRequestHandler> _inactiveRequestHandlerSnapshot = new Snapshot(WebServerServlet.class, InactiveRequestHandler.class);
    private static final Snapshot<MessageBus> _messageBusSnapshot = new Snapshot(WebServerServlet.class, MessageBus.class);
    private static final Snapshot<TrashHelper> _trashTitleResolverSnapshot = new Snapshot(WebServerServlet.class, TrashHelper.class);
    private static final Snapshot<UserFileUploadsSettings> _userFileUploadsSettingsSnapshot = new Snapshot(WebServerServlet.class, UserFileUploadsSettings.class);
    private boolean _lastModified = true;
    private TemplateResource _templateResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasFiles(HttpServletRequest httpServletRequest) {
        String name = PrincipalThreadLocal.getName();
        String password = PrincipalThreadLocal.getPassword();
        try {
            String[] pathArray;
            User user = WebServerServlet._getUser(httpServletRequest);
            if (!user.isGuestUser()) {
                PrincipalThreadLocal.setName((long)user.getUserId());
                PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest));
            }
            if ((pathArray = StringUtil.split((String)WebServerServlet._getPath(httpServletRequest), (char)'/')).length == 0) {
                boolean bl = true;
                return bl;
            }
            if (Validator.isNumber((String)pathArray[0])) {
                WebServerServlet._checkFileEntry(pathArray);
            } else if (_PATH_SEPARATOR_FILE_ENTRY.equals(pathArray[0])) {
                FileEntry fileEntry = WebServerServlet._resolveFileEntry(httpServletRequest, pathArray);
                if (fileEntry == null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (PATH_PORTLET_FILE_ENTRY.equals(pathArray[0])) {
                FileEntry fileEntry = WebServerServlet.getPortletFileEntry(httpServletRequest, pathArray);
                if (fileEntry != null) {
                    boolean bl = true;
                    return bl;
                }
            } else {
                Group group = WebServerServlet._getGroup(user.getCompanyId(), pathArray[0]);
                WebServerServlet._checkDirectoryIndexingEnabled(group);
                long groupId = group.getGroupId();
                long folderId = 0L;
                for (int i = 1; i < pathArray.length; ++i) {
                    try {
                        Folder folder = DLAppLocalServiceUtil.getFolder((long)groupId, (long)folderId, (String)URLCodec.decodeURL((String)pathArray[i]));
                        folderId = folder.getFolderId();
                        continue;
                    }
                    catch (NoSuchFolderException noSuchFolderException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)noSuchFolderException);
                        }
                        if (i != pathArray.length - 1) {
                            boolean bl = false;
                            PrincipalThreadLocal.setName((String)name);
                            PrincipalThreadLocal.setPassword((String)password);
                            return bl;
                        }
                        pathArray = new String[]{String.valueOf(groupId), String.valueOf(folderId), pathArray[i]};
                        WebServerServlet._checkFileEntry(pathArray);
                        continue;
                    }
                }
            }
            WebServerServlet.sendMessageObjectEntryAttachmentDownload(httpServletRequest, user);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PrincipalThreadLocal.setPassword((String)password);
        }
        return true;
    }

    public static void sendMessageObjectEntryAttachmentDownload(HttpServletRequest httpServletRequest, User user) {
        block4: {
            String objectDefinitionExternalReferenceCode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"objectDefinitionExternalReferenceCode");
            if (Validator.isNull((String)objectDefinitionExternalReferenceCode)) {
                return;
            }
            try {
                MessageBus messageBus = (MessageBus)_messageBusSnapshot.get();
                Message message = new Message();
                if (user == null) {
                    user = WebServerServlet._getUser(httpServletRequest);
                }
                message.put("companyId", (Object)user.getCompanyId());
                message.put("objectDefinitionExternalReferenceCode", (Object)objectDefinitionExternalReferenceCode);
                message.put("objectEntryExternalReferenceCode", (Object)ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"objectEntryExternalReferenceCode"));
                message.put("userId", (Object)user.getUserId());
                messageBus.sendMessage("liferay/object_entry_attachment_download", message);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._lastModified = GetterUtil.getBoolean((String)servletConfig.getInitParameter("last_modified"), (boolean)true);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        String templateId = "com/liferay/portal/webserver/dependencies/template.ftl";
        URL url = classLoader.getResource(templateId);
        this._templateResource = new URLTemplateResource(templateId, url);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        User user = null;
        try {
            long lastModified;
            user = WebServerServlet._getUser(httpServletRequest);
            if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, user.getCompanyId())) {
                return;
            }
            PrincipalThreadLocal.setName((long)user.getUserId());
            PrincipalThreadLocal.setPassword((String)PortalUtil.getUserPassword((HttpServletRequest)httpServletRequest));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)user));
            this._checkResourcePermission(httpServletRequest, httpServletResponse);
            String ifNoneMatch = httpServletRequest.getHeader("If-None-Match");
            if (ifNoneMatch == null && this._lastModified && (lastModified = this.getLastModified(httpServletRequest)) > 0L) {
                long ifModifiedSince = httpServletRequest.getDateHeader("If-Modified-Since");
                if (ifModifiedSince > 0L && ifModifiedSince == lastModified) {
                    httpServletResponse.setStatus(304);
                    return;
                }
                httpServletResponse.setDateHeader("Last-Modified", lastModified);
            }
            TransactionConfig.Builder builder = new TransactionConfig.Builder();
            builder.setReadOnly(true);
            builder.setRollbackForClasses(new Class[]{Exception.class});
            TransactionInvokerUtil.invoke((TransactionConfig)builder.build(), this._createFileServingCallable(httpServletRequest, httpServletResponse, user));
        }
        catch (FileEntryExpiredException | NoSuchFileEntryException | NoSuchFolderException exception) {
            PortalUtil.sendError((int)404, (Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        catch (PrincipalException principalException) {
            this.processPrincipalException(principalException, user, httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            PortalUtil.sendError((Exception)exception, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
        catch (Throwable throwable) {
            PortalUtil.sendError((Exception)new Exception(throwable), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
        }
    }

    protected static FileEntry getPortletFileEntry(HttpServletRequest httpServletRequest, String[] pathArray) throws Exception {
        User user;
        String uuid = pathArray[3];
        long groupId = GetterUtil.getLong((String)pathArray[1]);
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((String)uuid, (long)groupId);
        if (!fileEntry.containsPermission(PermissionCheckerFactoryUtil.create((User)(user = WebServerServlet._getUser(httpServletRequest))), "VIEW")) {
            throw new PrincipalException.MustHavePermission(user.getUserId(), new String[]{"VIEW"});
        }
        int status = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"status", (int)0);
        if (status != 8 && fileEntry.isInTrash()) {
            return null;
        }
        return fileEntry;
    }

    protected Image convertFileEntry(boolean smallImage, FileEntry fileEntry) throws PortalException {
        try {
            ImageImpl image = new ImageImpl();
            image.setModifiedDate(fileEntry.getModifiedDate());
            InputStream inputStream = null;
            inputStream = smallImage ? ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileEntry.getFileVersion(), (int)0) : fileEntry.getContentStream();
            image.setTextObj(FileUtil.getBytes((InputStream)inputStream));
            image.setType(fileEntry.getExtension());
            return image;
        }
        catch (PortalException | SystemException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    protected Image getDefaultImage(HttpServletRequest httpServletRequest, long imageId) {
        String path = GetterUtil.getString((String)httpServletRequest.getPathInfo());
        if (path.startsWith("/company_logo") || path.startsWith("/layout_set_logo") || path.startsWith("/logo")) {
            return ImageToolUtil.getDefaultCompanyLogo();
        }
        if (path.startsWith("/organization_logo")) {
            return ImageToolUtil.getDefaultOrganizationLogo();
        }
        if (path.startsWith("/user_female_portrait")) {
            return ImageToolUtil.getDefaultUserFemalePortrait();
        }
        if (path.startsWith("/user_male_portrait")) {
            return ImageToolUtil.getDefaultUserMalePortrait();
        }
        if (path.startsWith("/user_portrait")) {
            return ImageToolUtil.getDefaultUserPortrait();
        }
        return null;
    }

    protected Image getImage(HttpServletRequest httpServletRequest, boolean getDefault) throws Exception {
        long imageId;
        Image image;
        block15: {
            image = null;
            imageId = this.getImageId(httpServletRequest);
            if (imageId > 0L) {
                image = ImageServiceUtil.getImage((long)imageId);
                String path = GetterUtil.getString((String)httpServletRequest.getPathInfo());
                if (path.startsWith("/layout_icon") || path.startsWith("/logo")) {
                    PermissionChecker permissionChecker;
                    Layout layout = LayoutLocalServiceUtil.fetchLayoutByIconImageId((boolean)true, (long)imageId);
                    if (layout != null && !LayoutPermissionUtil.contains((PermissionChecker)(permissionChecker = this._getPermissionChecker(httpServletRequest)), (Layout)layout, (String)"VIEW")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getPlid(), new String[]{"VIEW"});
                    }
                } else if (path.startsWith("/layout_set_logo")) {
                    LayoutSet layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSetByLogoId((boolean)true, (long)imageId);
                    if (layoutSet != null) {
                        PermissionChecker permissionChecker = this._getPermissionChecker(httpServletRequest);
                        Group group = layoutSet.getGroup();
                        if (!group.isShowSite(permissionChecker, layoutSet.isPrivateLayout()) && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)layoutSet.getGroupId(), (String)"VIEW")) {
                            throw new PrincipalException.MustHavePermission(permissionChecker, LayoutSet.class.getName(), layoutSet.getLayoutSetId(), new String[]{"VIEW"});
                        }
                    }
                } else if (path.startsWith("/user_female_portrait") || path.startsWith("/user_male_portrait") || path.startsWith("/user_portrait")) {
                    image = this.getUserPortraitImageResized(image, imageId);
                }
            } else {
                String uuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"uuid");
                long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
                if (Validator.isNotNull((String)uuid) && groupId > 0L) {
                    boolean igSmallImage = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"igSmallImage");
                    try {
                        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                        image = this.convertFileEntry(igSmallImage, fileEntry);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block15;
                        _log.debug((Throwable)exception);
                    }
                }
            }
        }
        if (getDefault && image == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Get a default image for " + imageId));
            }
            image = this.getDefaultImage(httpServletRequest, imageId);
        }
        return image;
    }

    protected byte[] getImageBytes(HttpServletRequest httpServletRequest, Image image) throws PortalException {
        byte[] textObj = image.getTextObj();
        if (textObj == null || textObj.length == 0) {
            throw new NoSuchFileException();
        }
        try {
            if (!PropsValues.IMAGE_AUTO_SCALE) {
                return textObj;
            }
            ImageBag imageBag = null;
            if (image.getImageId() == 0L) {
                imageBag = ImageToolUtil.read(textObj);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                image.setHeight(renderedImage.getHeight());
                image.setWidth(renderedImage.getWidth());
            }
            int height = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"height", (int)image.getHeight());
            int width = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"width", (int)image.getWidth());
            if (height >= image.getHeight() && width >= image.getWidth()) {
                return textObj;
            }
            if (image.getImageId() != 0L) {
                imageBag = ImageToolUtil.read(textObj);
            }
            RenderedImage renderedImage = ImageToolUtil.scale(imageBag.getRenderedImage(), height, width);
            return ImageToolUtil.getBytes(renderedImage, imageBag.getType());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Error scaling image " + image.getImageId()), (Throwable)exception);
            }
            return textObj;
        }
    }

    protected long getImageId(HttpServletRequest httpServletRequest) {
        UserFileUploadsSettings userFileUploadsSettings;
        long imageId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"image_id");
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"img_id");
        }
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"i_id");
        }
        User user = null;
        if (imageId <= 0L) {
            long companyId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"companyId");
            String screenName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"screenName");
            if (companyId > 0L && Validator.isNotNull((String)screenName) && (user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName)) != null) {
                imageId = user.getPortraitId();
            }
        }
        if ((userFileUploadsSettings = (UserFileUploadsSettings)_userFileUploadsSettingsSnapshot.get()).isImageCheckToken() && imageId > 0L) {
            String imageIdToken = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"img_id_token");
            if (user == null) {
                user = UserLocalServiceUtil.fetchUserByPortraitId((long)imageId);
            }
            if (user != null && !imageIdToken.equals(DigesterUtil.digest((String)user.getUserUuid()))) {
                return 0L;
            }
            Organization organization = null;
            List organizations = (List)OrganizationLocalServiceUtil.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)OrganizationTable.INSTANCE).from((Table)OrganizationTable.INSTANCE).where(OrganizationTable.INSTANCE.logoId.eq((Object)imageId)).limit(0, 1));
            if (ListUtil.isNotEmpty((List)organizations)) {
                organization = (Organization)organizations.get(0);
            }
            if (organization != null && !imageIdToken.equals(DigesterUtil.digest((String)organization.getUuid()))) {
                return 0L;
            }
        }
        return imageId;
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        try {
            Date modifiedDate = null;
            Image image = this.getImage(httpServletRequest, true);
            if (image != null) {
                modifiedDate = image.getModifiedDate();
            } else {
                FileEntry fileEntry;
                block13: {
                    String[] pathArray = StringUtil.split((String)WebServerServlet._getPath(httpServletRequest), (char)'/');
                    if (pathArray.length == 0 || pathArray[0].equals("language")) {
                        return -1L;
                    }
                    fileEntry = null;
                    try {
                        fileEntry = this._getFileEntry(pathArray, httpServletRequest);
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block13;
                        _log.debug((Throwable)exception);
                    }
                }
                if (fileEntry == null) {
                    return -1L;
                }
                String version = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"version");
                if (Validator.isNotNull((String)version)) {
                    FileVersion fileVersion = fileEntry.getFileVersion(version);
                    modifiedDate = fileVersion.getModifiedDate();
                } else {
                    modifiedDate = fileEntry.getModifiedDate();
                }
            }
            if (modifiedDate == null) {
                modifiedDate = PortalUtil.getUptime();
            }
            return modifiedDate.getTime() / 1000L * 1000L;
        }
        catch (PrincipalException principalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)principalException);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return -1L;
    }

    protected Image getUserPortraitImageResized(Image image, long imageId) throws PortalException {
        if (image == null) {
            return null;
        }
        UserFileUploadsSettings userFileUploadsSettings = (UserFileUploadsSettings)_userFileUploadsSettingsSnapshot.get();
        int usersImageMaxHeight = userFileUploadsSettings.getImageMaxHeight();
        int usersImageMaxWidth = userFileUploadsSettings.getImageMaxWidth();
        if (usersImageMaxHeight > 0 && image.getHeight() > usersImageMaxHeight || usersImageMaxWidth > 0 && image.getWidth() > usersImageMaxWidth) {
            User user = UserLocalServiceUtil.getUserByPortraitId((long)imageId);
            UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])image.getTextObj());
            return ImageLocalServiceUtil.getImage((long)imageId);
        }
        return image;
    }

    protected boolean isLegacyImageGalleryImageId(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            long imageId = this.getImageId(httpServletRequest);
            if (imageId == 0L) {
                return false;
            }
            Repository repository = RepositoryProviderUtil.getImageRepository((long)imageId);
            if (!repository.isCapabilityProvided(ThumbnailCapability.class)) {
                return false;
            }
            ThumbnailCapability thumbnailCapability = (ThumbnailCapability)repository.getCapability(ThumbnailCapability.class);
            FileEntry fileEntry = thumbnailCapability.fetchImageFileEntry(imageId);
            if (fileEntry == null) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String queryString = "";
            if (imageId == thumbnailCapability.getSmallImageId(fileEntry)) {
                queryString = "&imageThumbnail=1";
            } else if (imageId == thumbnailCapability.getCustom1ImageId(fileEntry)) {
                queryString = "&imageThumbnail=2";
            } else if (imageId == thumbnailCapability.getCustom2ImageId(fileEntry)) {
                queryString = "&imageThumbnail=3";
            }
            FileVersion fileVersion = fileEntry.getFileVersion();
            if (PropsValues.DL_FILE_ENTRY_IG_THUMBNAIL_GENERATION && Validator.isNotNull((String)queryString)) {
                ImageProcessorUtil.hasImages((FileVersion)fileVersion);
            }
            String url = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileVersion, (ThemeDisplay)themeDisplay, (String)queryString);
            httpServletResponse.setHeader("Location", url);
            httpServletResponse.setStatus(301);
            return true;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    protected boolean isSupportsRangeHeader(String contentType) {
        return _acceptRangesMimeTypes.contains(contentType);
    }

    protected void processPrincipalException(Throwable throwable, User user, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!user.isGuestUser()) {
            PortalUtil.sendError((int)401, (Exception)((Exception)throwable), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return;
        }
        String redirect = PortalUtil.getPathMain() + "/portal/login";
        redirect = HttpComponentsUtil.addParameter((String)redirect, (String)"redirect", (String)PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest));
        httpServletResponse.sendRedirect(redirect);
    }

    protected void sendDocumentLibrary(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user, String path, String[] pathArray) throws Exception {
        Group group = WebServerServlet._getGroup(user.getCompanyId(), pathArray[0]);
        WebServerServlet._checkDirectoryIndexingEnabled(group);
        long groupId = group.getGroupId();
        long folderId = 0L;
        for (int i = 1; i < pathArray.length; ++i) {
            String name = pathArray[i];
            try {
                Folder folder = DLAppLocalServiceUtil.getFolder((long)groupId, (long)folderId, (String)URLCodec.decodeURL((String)name));
                folderId = folder.getFolderId();
                continue;
            }
            catch (NoSuchFolderException noSuchFolderException) {
                if (i != pathArray.length - 1) {
                    throw noSuchFolderException;
                }
                String title = name;
                this.sendFile(httpServletResponse, user, groupId, folderId, URLCodec.decodeURL((String)title));
                return;
            }
        }
        try {
            this.sendFile(httpServletResponse, user, groupId, folderId, "index.html");
            return;
        }
        catch (NoSuchFileEntryException | PrincipalException exception1) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception1);
            }
            try {
                this.sendFile(httpServletResponse, user, groupId, folderId, "index.htm");
                return;
            }
            catch (NoSuchFileEntryException | PrincipalException exception2) {
                if (_log.isDebugEnabled()) {
                    _log.debug(exception2);
                }
                ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
                webServerEntries.add(new WebServerEntry(path, "../"));
                List folders = DLAppServiceUtil.getFolders((long)groupId, (long)folderId);
                for (Folder folder : folders) {
                    WebServerEntry webServerEntry = new WebServerEntry(path, folder.getName() + "/", folder.getCreateDate(), folder.getModifiedDate(), folder.getDescription(), 0L);
                    webServerEntries.add(webServerEntry);
                }
                List fileEntries = DLAppServiceUtil.getFileEntries((long)groupId, (long)folderId);
                for (FileEntry fileEntry : fileEntries) {
                    WebServerEntry webServerEntry = new WebServerEntry(path, fileEntry.getTitle(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getDescription(), fileEntry.getSize());
                    webServerEntries.add(webServerEntry);
                }
                this.sendHTML(httpServletResponse, URLCodec.decodeURL((String)path), webServerEntries);
                return;
            }
        }
    }

    protected void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user, String[] pathArray) throws Exception {
        FileEntry fileEntry = this._getFileEntry(pathArray, httpServletRequest);
        if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, fileEntry.getCompanyId())) {
            return;
        }
        String version = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"version");
        if (Validator.isNull((String)version) && Validator.isNotNull((String)fileEntry.getVersion())) {
            version = fileEntry.getVersion();
        }
        String tempFileId = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version);
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        if (ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"height") > 0 || ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"width") > 0) {
            InputStream inputStream = fileVersion.getContentStream(true);
            this.writeImage(ImageToolUtil.getImage(inputStream), httpServletRequest, httpServletResponse);
            return;
        }
        String fileName = fileVersion.getFileName();
        boolean converted = false;
        int imageThumbnail = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"imageThumbnail");
        int documentThumbnail = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"documentThumbnail");
        int previewFileIndex = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"previewFileIndex");
        boolean audioPreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"audioPreview");
        boolean imagePreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"imagePreview");
        boolean videoPreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"videoPreview");
        int videoThumbnail = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"videoThumbnail");
        InputStream inputStream = null;
        long contentLength = 0L;
        if (imageThumbnail > 0 && imageThumbnail <= 3) {
            fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", ImageProcessorUtil.getThumbnailType((FileVersion)fileVersion)});
            int thumbnailIndex = imageThumbnail - 1;
            inputStream = ImageProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = ImageProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (documentThumbnail > 0 && documentThumbnail <= 3) {
            fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", "png"});
            int thumbnailIndex = documentThumbnail - 1;
            inputStream = PDFProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = PDFProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else if (previewFileIndex > 0) {
            fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", "png"});
            inputStream = PDFProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (int)previewFileIndex);
            contentLength = PDFProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (int)previewFileIndex);
            converted = true;
        } else if (audioPreview || videoPreview) {
            String type = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"type");
            fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", type});
            if (audioPreview) {
                inputStream = AudioProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (String)type);
                contentLength = AudioProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (String)type);
            } else {
                inputStream = VideoProcessorUtil.getPreviewAsStream((FileVersion)fileVersion, (String)type);
                contentLength = VideoProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (String)type);
            }
            converted = true;
        } else if (imagePreview) {
            String type = ImageProcessorUtil.getPreviewType((FileVersion)fileVersion);
            fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", type});
            inputStream = ImageProcessorUtil.getPreviewAsStream((FileVersion)fileVersion);
            contentLength = ImageProcessorUtil.getPreviewFileSize((FileVersion)fileVersion);
            converted = true;
        } else if (videoThumbnail > 0 && videoThumbnail <= 3) {
            fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", "jpg"});
            int thumbnailIndex = videoThumbnail - 1;
            inputStream = VideoProcessorUtil.getThumbnailAsStream((FileVersion)fileVersion, (int)thumbnailIndex);
            contentLength = VideoProcessorUtil.getThumbnailFileSize((FileVersion)fileVersion, (int)thumbnailIndex);
            converted = true;
        } else {
            File convertedFile;
            inputStream = fileVersion.getContentStream(true);
            contentLength = fileVersion.getSize();
            String targetExtension = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"targetExtension");
            if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert((String)tempFileId, (InputStream)inputStream, (String)fileVersion.getExtension(), (String)targetExtension)) != null) {
                fileName = StringBundler.concat((String[])new String[]{FileUtil.stripExtension((String)fileName), ".", targetExtension});
                inputStream = new FileInputStream(convertedFile);
                contentLength = convertedFile.length();
                converted = true;
            }
        }
        if (converted && contentLength == 0L) {
            PortalUtil.sendError((int)404, (Exception)new NoSuchFileException("The converted file is empty"), (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
            return;
        }
        String contentType = null;
        contentType = converted ? MimeTypesUtil.getContentType((String)fileName) : fileVersion.getMimeType();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Content type set to " + contentType));
        }
        String cacheControlValue = "private";
        boolean download = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"download");
        if (download) {
            cacheControlValue = "private, no-cache, no-store, must-revalidate";
        }
        httpServletResponse.addHeader("Cache-Control", FileEntryHttpHeaderCustomizerUtil.getHttpHeaderValue((FileEntry)fileEntry, (String)"Cache-Control", (String)cacheControlValue));
        if (this.isSupportsRangeHeader(contentType)) {
            ServletResponseUtil.sendFileWithRangeHeader((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType);
        } else if (download) {
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType, (String)"attachment");
        } else {
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (InputStream)inputStream, (long)contentLength, (String)contentType);
        }
    }

    protected void sendFile(HttpServletResponse httpServletResponse, User user, long groupId, long folderId, String title) throws Exception {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
        httpServletResponse.addHeader("Cache-Control", FileEntryHttpHeaderCustomizerUtil.getHttpHeaderValue((FileEntry)fileEntry, (String)"Cache-Control", (String)"private"));
        ServletResponseUtil.sendFile(null, (HttpServletResponse)httpServletResponse, (String)fileEntry.getTitle(), (InputStream)fileEntry.getContentStream(), (long)fileEntry.getSize(), (String)fileEntry.getMimeType());
    }

    protected void sendGroups(HttpServletResponse httpServletResponse, User user, String path) throws Exception {
        ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
        List groups = WebDAVUtil.getGroups((User)user);
        for (Group group : groups) {
            if (!WebServerServlet._isDirectoryIndexingEnabled(group)) continue;
            String name = HttpComponentsUtil.fixPath((String)group.getFriendlyURL());
            WebServerEntry webServerEntry = new WebServerEntry(path, name + "/", null, null, group.getDescription(), 0L);
            webServerEntries.add(webServerEntry);
        }
        this.sendHTML(httpServletResponse, path, webServerEntries);
    }

    protected void sendHTML(HttpServletResponse httpServletResponse, String path, List<WebServerEntry> webServerEntries) throws Exception {
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)this._templateResource, (boolean)true);
        template.put((Object)"entries", webServerEntries);
        template.put((Object)"path", (Object)HttpComponentsUtil.encodePath((String)path));
        if (!_WEB_SERVER_SERVLET_VERSION_VERBOSITY_DEFAULT) {
            if (_WEB_SERVER_SERVLET_VERSION_VERBOSITY_PARTIAL) {
                template.put((Object)"releaseInfo", (Object)ReleaseInfo.getName());
            } else {
                template.put((Object)"releaseInfo", (Object)ReleaseInfo.getReleaseInfo());
            }
        }
        template.put((Object)"validator", (Object)Validator_IW.getInstance());
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        template.processTemplate((Writer)httpServletResponse.getWriter());
    }

    protected void sendPortletFileEntry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String path, String[] pathArray) throws Exception {
        FileEntry fileEntry = WebServerServlet.getPortletFileEntry(httpServletRequest, pathArray);
        if (fileEntry == null || this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, fileEntry.getCompanyId())) {
            return;
        }
        String fileName = HttpComponentsUtil.decodeURL((String)HtmlUtil.escape((String)pathArray[2]));
        if (Validator.isNull((String)fileName)) {
            throw new NoSuchFileEntryException("Invalid path " + path);
        }
        if (fileEntry.isInTrash()) {
            TrashHelper trashTitleResolver = (TrashHelper)_trashTitleResolverSnapshot.get();
            fileName = trashTitleResolver.getOriginalTitle(fileName);
        }
        httpServletResponse.addHeader("Cache-Control", FileEntryHttpHeaderCustomizerUtil.getHttpHeaderValue((FileEntry)fileEntry, (String)"Cache-Control", (String)"private"));
        boolean download = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"download");
        if (download) {
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (InputStream)fileEntry.getContentStream(), (long)fileEntry.getSize(), (String)fileEntry.getMimeType(), (String)"attachment");
        } else {
            ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (InputStream)fileEntry.getContentStream(), (long)fileEntry.getSize(), (String)fileEntry.getMimeType());
        }
    }

    protected void writeImage(Image image, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        block6: {
            if (image == null) {
                return;
            }
            String contentType = null;
            String type = image.getType();
            if (!type.equals("na")) {
                contentType = MimeTypesUtil.getExtensionContentType((String)type);
                httpServletResponse.setContentType(contentType);
            }
            String fileName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"fileName");
            byte[] bytes = this.getImageBytes(httpServletRequest, image);
            try {
                if (Validator.isNotNull((String)fileName)) {
                    ServletResponseUtil.sendFile((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (String)fileName, (byte[])bytes, (String)contentType);
                } else {
                    ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (byte[])bytes);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Throwable)exception);
            }
        }
    }

    private static void _checkDirectoryIndexingEnabled(Group group) throws Exception {
        if (!WebServerServlet._isDirectoryIndexingEnabled(group)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Directory indexing is not enabled for group " + group.getGroupId()));
            }
            throw new NoSuchFolderException();
        }
    }

    private static void _checkFileEntry(String[] pathArray) throws Exception {
        block13: {
            if (pathArray.length == 1) {
                long fileShortcutId = GetterUtil.getLong((String)pathArray[0]);
                FileShortcut fileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)fileShortcutId);
                DLAppLocalServiceUtil.getFileEntry((long)fileShortcut.getToFileEntryId());
            } else if (pathArray.length == 2) {
                DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)pathArray[1], (long)GetterUtil.getLong((String)pathArray[0]));
            } else {
                if (pathArray.length == 3) {
                    long groupId = GetterUtil.getLong((String)pathArray[0]);
                    long folderId = GetterUtil.getLong((String)pathArray[1]);
                    String fileName = HttpComponentsUtil.decodeURL((String)pathArray[2]);
                    try {
                        try {
                            DLAppLocalServiceUtil.getFileEntryByFileName((long)groupId, (long)folderId, (String)fileName);
                            break block13;
                        }
                        catch (NoSuchFileEntryException noSuchFileEntryException) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Throwable)noSuchFileEntryException);
                            }
                            DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
                        }
                    }
                    catch (RepositoryException repositoryException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Throwable)repositoryException);
                        }
                        break block13;
                    }
                }
                long groupId = GetterUtil.getLong((String)pathArray[0]);
                String uuid = pathArray[3];
                try {
                    DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                }
                catch (RepositoryException repositoryException) {
                    if (!_log.isDebugEnabled()) break block13;
                    _log.debug((Throwable)repositoryException);
                }
            }
        }
    }

    private static Group _getGroup(long companyId, String name) throws Exception {
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)companyId, (String)("/" + name));
        if (group != null) {
            return group;
        }
        User user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)name);
        return user.getGroup();
    }

    private static String _getPath(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        String path = httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
        return requestURI.substring(path.length() + 1);
    }

    private static User _getUser(HttpServletRequest httpServletRequest) throws Exception {
        User user;
        HttpSession httpSession = httpServletRequest.getSession();
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
        }
        if ((user = PortalUtil.getUser((HttpServletRequest)httpServletRequest)) != null) {
            return user;
        }
        String userIdString = (String)httpSession.getAttribute("j_username");
        String password = (String)httpSession.getAttribute("j_password");
        if (userIdString != null && password != null) {
            long userId = GetterUtil.getLong((String)userIdString);
            return UserLocalServiceUtil.getUser((long)userId);
        }
        Company company = CompanyLocalServiceUtil.getCompany((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest));
        return company.getGuestUser();
    }

    private static boolean _isDirectoryIndexingEnabled(Group group) {
        UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        return GetterUtil.getBoolean((String)typeSettingsUnicodeProperties.getProperty("directoryIndexingEnabled"), (boolean)PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED);
    }

    private static FileEntry _resolveFileEntry(HttpServletRequest httpServletRequest, String[] pathArray) throws Exception {
        FileEntryFriendlyURLResolver fileEntryFriendlyURLResolver = (FileEntryFriendlyURLResolver)_fileEntryFriendlyURLResolverSnapshot.get();
        if (fileEntryFriendlyURLResolver == null) {
            return null;
        }
        User user = WebServerServlet._getUser(httpServletRequest);
        Group group = WebServerServlet._getGroup(user.getCompanyId(), pathArray[1]);
        return fileEntryFriendlyURLResolver.resolveFriendlyURL(group.getGroupId(), pathArray[2]);
    }

    private void _checkCompanyAndGroup(long groupId, HttpServletRequest httpServletRequest) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (group == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No group exists group ID " + groupId));
            }
            throw new NoSuchFileEntryException();
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest);
        if (group.getCompanyId() != companyId) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Group ", groupId, " does not belong to company ", companyId}));
            }
            throw new NoSuchFileEntryException();
        }
    }

    private void _checkFileEntry(FileEntry fileEntry, HttpServletRequest httpServletRequest) throws Exception {
        if (fileEntry == null) {
            return;
        }
        this._checkCompanyAndGroup(fileEntry.getGroupId(), httpServletRequest);
        PermissionChecker permissionChecker = this._getPermissionChecker(httpServletRequest);
        ModelResourcePermission fileEntryModelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)FileEntry.class.getName());
        fileEntryModelResourcePermission.check(permissionChecker, fileEntry.getFileEntryId(), this._getActionId(httpServletRequest));
        FileVersion fileVersion = fileEntry.getFileVersion();
        if (!fileVersion.isExpired()) {
            return;
        }
        User user = WebServerServlet._getUser(httpServletRequest);
        if (!permissionChecker.isContentReviewer(user.getCompanyId(), fileVersion.getGroupId()) && !Objects.equals(fileVersion.getUserId(), user.getUserId())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"The file entry ", fileEntry.getFileEntryId(), " is expired. Only users with content review ", "permission can access it."}));
            }
            throw new FileEntryExpiredException("The file entry " + fileEntry.getFileEntryId() + " is expired and the user does not have review permission");
        }
    }

    private void _checkResourcePermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String[] pathArray = StringUtil.split((String)WebServerServlet._getPath(httpServletRequest), (char)'/');
        if (pathArray.length == 0) {
            if (!PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED) {
                httpServletResponse.setStatus(403);
                throw new PrincipalException();
            }
        } else if (Objects.equals(pathArray[0], _PATH_SEPARATOR_FILE_ENTRY) || Validator.isNumber((String)pathArray[0])) {
            FileEntry fileEntry = this._getFileEntry(pathArray, httpServletRequest);
            String portletId = this._getPortletId(fileEntry, httpServletRequest);
            if (portletId == null) {
                return;
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            Group group = GroupLocalServiceUtil.getGroup((long)fileEntry.getGroupId());
            if (group.isStagingGroup()) {
                GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)"VIEW_STAGING");
            } else if (!PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)portletId)) {
                throw new PrincipalException.MustHavePermission(permissionChecker, FileEntry.class.getName(), fileEntry.getFileEntryId(), new String[]{"ACCESS_IN_CONTROL_PANEL"});
            }
        }
    }

    private Callable<Void> _createFileServingCallable(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user) {
        return () -> {
            String path = WebServerServlet._getPath(httpServletRequest);
            String[] pathArray = StringUtil.split((String)WebServerServlet._getPath(httpServletRequest), (char)'/');
            if (pathArray.length == 0) {
                this.sendGroups(httpServletResponse, user, httpServletRequest.getServletPath() + "/" + path);
            } else if (Validator.isNumber((String)pathArray[0])) {
                this.sendFile(httpServletRequest, httpServletResponse, user, pathArray);
            } else if (_PATH_SEPARATOR_FILE_ENTRY.equals(pathArray[0])) {
                this.sendFile(httpServletRequest, httpServletResponse, user, pathArray);
            } else if (PATH_PORTLET_FILE_ENTRY.equals(pathArray[0])) {
                this.sendPortletFileEntry(httpServletRequest, httpServletResponse, path, pathArray);
            } else {
                if (PropsValues.WEB_SERVER_SERVLET_CHECK_IMAGE_GALLERY && this.isLegacyImageGalleryImageId(httpServletRequest, httpServletResponse)) {
                    return null;
                }
                Image image = this.getImage(httpServletRequest, true);
                if (image != null) {
                    if (image.getCompanyId() != user.getCompanyId() && this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, image.getCompanyId())) {
                        return null;
                    }
                    this.writeImage(image, httpServletRequest, httpServletResponse);
                } else {
                    this.sendDocumentLibrary(httpServletRequest, httpServletResponse, user, StringBundler.concat((String[])new String[]{PortalUtil.getPathContext(), httpServletRequest.getServletPath(), "/", path}), pathArray);
                }
            }
            return null;
        };
    }

    private String _getActionId(HttpServletRequest httpServletRequest) {
        boolean audioPreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"audioPreview");
        boolean imagePreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"imagePreview");
        boolean videoPreview = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"videoPreview");
        if (audioPreview || imagePreview || videoPreview) {
            return "VIEW";
        }
        int documentThumbnail = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"documentThumbnail");
        if (documentThumbnail > 0 && documentThumbnail <= 3) {
            return "VIEW";
        }
        int imageThumbnail = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"imageThumbnail");
        if (imageThumbnail > 0 && imageThumbnail <= 3) {
            return "VIEW";
        }
        int previewFileIndex = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"previewFileIndex");
        if (previewFileIndex > 0) {
            return "VIEW";
        }
        int videoThumbnail = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"videoThumbnail");
        if (videoThumbnail > 0 && videoThumbnail <= 3) {
            return "VIEW";
        }
        return "DOWNLOAD";
    }

    private FileEntry _getFileEntry(String[] pathArray, HttpServletRequest httpServletRequest) throws Exception {
        if (pathArray.length == 1) {
            long fileShortcutId = GetterUtil.getLong((String)pathArray[0]);
            FileShortcut dlFileShortcut = DLAppLocalServiceUtil.getFileShortcut((long)fileShortcutId);
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileShortcut.getToFileEntryId());
            this._checkFileEntry(fileEntry, httpServletRequest);
            return fileEntry;
        }
        if (pathArray.length == 2) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)pathArray[1], (long)groupId);
            this._checkFileEntry(fileEntry, httpServletRequest);
            return fileEntry;
        }
        if (_PATH_SEPARATOR_FILE_ENTRY.equals(pathArray[0])) {
            FileEntry fileEntry = WebServerServlet._resolveFileEntry(httpServletRequest, pathArray);
            if (fileEntry == null) {
                throw new NoSuchFileEntryException("No file entry found for friendly URL " + Arrays.toString(pathArray));
            }
            this._checkFileEntry(fileEntry, httpServletRequest);
            return fileEntry;
        }
        if (pathArray.length == 3) {
            long groupId = GetterUtil.getLong((String)pathArray[0]);
            long folderId = GetterUtil.getLong((String)pathArray[1]);
            String fileName = HttpComponentsUtil.decodeURL((String)pathArray[2]);
            if (fileName.contains("?")) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            try {
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByFileName((long)groupId, (long)folderId, (String)fileName);
                this._checkFileEntry(fileEntry, httpServletRequest);
                return fileEntry;
            }
            catch (NoSuchFileEntryException noSuchFileEntryException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchFileEntryException);
                }
                FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)fileName);
                this._checkFileEntry(fileEntry, httpServletRequest);
                return fileEntry;
            }
        }
        long groupId = GetterUtil.getLong((String)pathArray[0]);
        String uuid = pathArray[3];
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
        this._checkFileEntry(fileEntry, httpServletRequest);
        return fileEntry;
    }

    private PermissionChecker _getPermissionChecker(HttpServletRequest httpServletRequest) throws Exception {
        User user = PortalUtil.getUser((HttpServletRequest)httpServletRequest);
        if (user == null) {
            user = UserLocalServiceUtil.getGuestUser((long)PortalUtil.getCompanyId((HttpServletRequest)httpServletRequest));
        }
        return PermissionCheckerFactoryUtil.create((User)user);
    }

    private String _getPortletId(FileEntry fileEntry, HttpServletRequest httpServletRequest) throws Exception {
        if (fileEntry.isInTrash()) {
            int status = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"status", (int)0);
            if (status != 8) {
                throw new NoSuchFileEntryException();
            }
            return PortletProviderUtil.getPortletId((String)"com.liferay.trash.model.TrashEntry", (PortletProvider.Action)PortletProvider.Action.VIEW);
        }
        Group group = GroupLocalServiceUtil.getGroup((long)fileEntry.getGroupId());
        if (!group.isStagingGroup()) {
            return null;
        }
        return PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
    }

    private boolean _processCompanyInactiveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long companyId) throws IOException {
        if (companyId == 0L || PortalInstances.isCompanyActive(companyId)) {
            return false;
        }
        InactiveRequestHandler inactiveRequestHandler = (InactiveRequestHandler)_inactiveRequestHandlerSnapshot.get();
        inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, "this-instance-is-inactive-please-contact-the-administrator");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Processed company inactive request");
        }
        return true;
    }
}

