/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xml;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProvider;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Entity;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.Text;
import com.liferay.portal.kernel.xml.XMLSchema;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.AttributeImpl;
import com.liferay.portal.xml.DocumentFactory;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.portal.xml.ElementImpl;
import com.liferay.portal.xml.EntityImpl;
import com.liferay.portal.xml.NamespaceImpl;
import com.liferay.portal.xml.NodeImpl;
import com.liferay.portal.xml.NodeList;
import com.liferay.portal.xml.ProcessingInstructionImpl;
import com.liferay.portal.xml.QNameImpl;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.portal.xml.TextImpl;
import com.liferay.portal.xml.XPathImpl;
import com.liferay.util.xml.XMLSafeReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class SAXReaderImpl
implements com.liferay.portal.kernel.xml.SAXReader {
    private final DocumentFactory _documentFactory = DocumentFactory.getInstance();
    private boolean _secure;
    private SecureXMLFactoryProvider _secureXMLFactoryProvider = new SecureXMLFactoryProviderImpl();

    public static List<Attribute> toNewAttributes(List<org.dom4j.Attribute> oldAttributes) {
        ArrayList<AttributeImpl> newAttributes = new ArrayList<AttributeImpl>(oldAttributes.size());
        for (org.dom4j.Attribute oldAttribute : oldAttributes) {
            newAttributes.add(new AttributeImpl(oldAttribute));
        }
        return new NodeList(newAttributes, oldAttributes);
    }

    public static List<Element> toNewElements(List<org.dom4j.Element> oldElements) {
        ArrayList<ElementImpl> newElements = new ArrayList<ElementImpl>(oldElements.size());
        for (org.dom4j.Element oldElement : oldElements) {
            newElements.add(new ElementImpl(oldElement));
        }
        return new NodeList(newElements, oldElements);
    }

    public static List<com.liferay.portal.kernel.xml.Namespace> toNewNamespaces(List<Namespace> oldNamespaces) {
        ArrayList<NamespaceImpl> newNamespaces = new ArrayList<NamespaceImpl>(oldNamespaces.size());
        for (Namespace oldNamespace : oldNamespaces) {
            newNamespaces.add(new NamespaceImpl(oldNamespace));
        }
        return new NodeList(newNamespaces, oldNamespaces);
    }

    public static List<Node> toNewNodes(List<org.dom4j.Node> oldNodes) {
        ArrayList<NodeImpl> newNodes = new ArrayList<NodeImpl>(oldNodes.size());
        for (org.dom4j.Node oldNode : oldNodes) {
            if (oldNode instanceof org.dom4j.Element) {
                newNodes.add(new ElementImpl((org.dom4j.Element)oldNode));
                continue;
            }
            newNodes.add(new NodeImpl(oldNode));
        }
        return new NodeList(newNodes, oldNodes);
    }

    public static List<com.liferay.portal.kernel.xml.ProcessingInstruction> toNewProcessingInstructions(List<ProcessingInstruction> oldProcessingInstructions) {
        ArrayList<ProcessingInstructionImpl> newProcessingInstructions = new ArrayList<ProcessingInstructionImpl>(oldProcessingInstructions.size());
        for (ProcessingInstruction oldProcessingInstruction : oldProcessingInstructions) {
            newProcessingInstructions.add(new ProcessingInstructionImpl(oldProcessingInstruction));
        }
        return new NodeList(newProcessingInstructions, oldProcessingInstructions);
    }

    public static List<org.dom4j.Attribute> toOldAttributes(List<Attribute> newAttributes) {
        ArrayList<org.dom4j.Attribute> oldAttributes = new ArrayList<org.dom4j.Attribute>(newAttributes.size());
        for (Attribute newAttribute : newAttributes) {
            AttributeImpl newAttributeImpl = (AttributeImpl)newAttribute;
            oldAttributes.add(newAttributeImpl.getWrappedAttribute());
        }
        return oldAttributes;
    }

    public static List<org.dom4j.Node> toOldNodes(List<Node> newNodes) {
        ArrayList<org.dom4j.Node> oldNodes = new ArrayList<org.dom4j.Node>(newNodes.size());
        for (Node newNode : newNodes) {
            NodeImpl newNodeImpl = (NodeImpl)newNode;
            oldNodes.add(newNodeImpl.getWrappedNode());
        }
        return oldNodes;
    }

    public static List<ProcessingInstruction> toOldProcessingInstructions(List<com.liferay.portal.kernel.xml.ProcessingInstruction> newProcessingInstructions) {
        ArrayList<ProcessingInstruction> oldProcessingInstructions = new ArrayList<ProcessingInstruction>(newProcessingInstructions.size());
        for (com.liferay.portal.kernel.xml.ProcessingInstruction newProcessingInstruction : newProcessingInstructions) {
            ProcessingInstructionImpl newProcessingInstructionImpl = (ProcessingInstructionImpl)newProcessingInstruction;
            oldProcessingInstructions.add(newProcessingInstructionImpl.getWrappedProcessingInstruction());
        }
        return oldProcessingInstructions;
    }

    public Attribute createAttribute(Element element, QName qName, String value) {
        ElementImpl elementImpl = (ElementImpl)element;
        QNameImpl qNameImpl = (QNameImpl)qName;
        return new AttributeImpl(this._documentFactory.createAttribute(elementImpl.getWrappedElement(), qNameImpl.getWrappedQName(), value));
    }

    public Attribute createAttribute(Element element, String name, String value) {
        ElementImpl elementImpl = (ElementImpl)element;
        return new AttributeImpl(this._documentFactory.createAttribute(elementImpl.getWrappedElement(), name, value));
    }

    public Document createDocument() {
        return new DocumentImpl(this._documentFactory.createDocument());
    }

    public Document createDocument(Element rootElement) {
        ElementImpl rootElementImpl = (ElementImpl)rootElement;
        return new DocumentImpl(this._documentFactory.createDocument(rootElementImpl.getWrappedElement()));
    }

    public Document createDocument(String encoding) {
        return new DocumentImpl(this._documentFactory.createDocument(encoding));
    }

    public Element createElement(QName qName) {
        QNameImpl qNameImpl = (QNameImpl)qName;
        return new ElementImpl(this._documentFactory.createElement(qNameImpl.getWrappedQName()));
    }

    public Element createElement(String name) {
        return new ElementImpl(this._documentFactory.createElement(name));
    }

    public Entity createEntity(String name, String text) {
        return new EntityImpl(this._documentFactory.createEntity(name, text));
    }

    public com.liferay.portal.kernel.xml.Namespace createNamespace(String uri) {
        return new NamespaceImpl(Namespace.get((String)uri));
    }

    public com.liferay.portal.kernel.xml.Namespace createNamespace(String prefix, String uri) {
        return new NamespaceImpl(this._documentFactory.createNamespace(prefix, uri));
    }

    public com.liferay.portal.kernel.xml.ProcessingInstruction createProcessingInstruction(String target, Map<String, String> data) {
        ProcessingInstruction processingInstruction = this._documentFactory.createProcessingInstruction(target, data);
        if (processingInstruction == null) {
            return null;
        }
        return new ProcessingInstructionImpl(processingInstruction);
    }

    public com.liferay.portal.kernel.xml.ProcessingInstruction createProcessingInstruction(String target, String data) {
        ProcessingInstruction processingInstruction = this._documentFactory.createProcessingInstruction(target, data);
        if (processingInstruction == null) {
            return null;
        }
        return new ProcessingInstructionImpl(processingInstruction);
    }

    public QName createQName(String localName) {
        return new QNameImpl(this._documentFactory.createQName(localName));
    }

    public QName createQName(String localName, com.liferay.portal.kernel.xml.Namespace namespace) {
        NamespaceImpl namespaceImpl = (NamespaceImpl)namespace;
        return new QNameImpl(this._documentFactory.createQName(localName, namespaceImpl.getWrappedNamespace()));
    }

    public Text createText(String text) {
        return new TextImpl(this._documentFactory.createText(text));
    }

    public com.liferay.portal.kernel.xml.XPath createXPath(String xPathExpression) {
        return this.createXPath(xPathExpression, null);
    }

    public com.liferay.portal.kernel.xml.XPath createXPath(String xPathExpression, Map<String, String> namespaceContextMap) {
        return new XPathImpl(this._documentFactory.createXPath(xPathExpression), namespaceContextMap);
    }

    public com.liferay.portal.kernel.xml.XPath createXPath(String xPathExpression, String prefix, String namespace) {
        return this.createXPath(xPathExpression, HashMapBuilder.put((Object)prefix, (Object)namespace).build());
    }

    public Document read(File file) throws DocumentException {
        return this.read(file, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document read(File file, boolean validate) throws DocumentException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)SAXReaderImpl.class.getClassLoader());){
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(file));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException documentException) {
            throw new DocumentException(documentException.getMessage(), (Throwable)documentException);
        }
    }

    public Document read(InputStream inputStream) throws DocumentException {
        return this.read(inputStream, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document read(InputStream inputStream, boolean validate) throws DocumentException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)SAXReaderImpl.class.getClassLoader());){
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(inputStream));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException documentException) {
            throw new DocumentException(documentException.getMessage(), (Throwable)documentException);
        }
    }

    public Document read(Reader reader) throws DocumentException {
        return this.read(reader, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document read(Reader reader, boolean validate) throws DocumentException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)SAXReaderImpl.class.getClassLoader());){
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(reader));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException documentException) {
            throw new DocumentException(documentException.getMessage(), (Throwable)documentException);
        }
    }

    public Document read(String xml) throws DocumentException {
        return this.read((Reader)new XMLSafeReader(xml));
    }

    public Document read(String xml, boolean validate) throws DocumentException {
        return this.read((Reader)new XMLSafeReader(xml), validate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document read(String xml, XMLSchema xmlSchema) throws DocumentException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)SAXReaderImpl.class.getClassLoader());){
            SAXReader saxReader = this.getSAXReader(xmlSchema);
            XMLSafeReader reader = new XMLSafeReader(xml);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read((Reader)reader));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException documentException) {
            throw new DocumentException(documentException.getMessage(), (Throwable)documentException);
        }
    }

    public Document read(URL url) throws DocumentException {
        return this.read(url, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document read(URL url, boolean validate) throws DocumentException {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)SAXReaderImpl.class.getClassLoader());){
            SAXReader saxReader = this.getSAXReader(validate);
            DocumentImpl documentImpl = new DocumentImpl(saxReader.read(url));
            return documentImpl;
        }
        catch (org.dom4j.DocumentException documentException) {
            throw new DocumentException(documentException.getMessage(), (Throwable)documentException);
        }
    }

    public Document readURL(String url) throws DocumentException, MalformedURLException {
        return this.read(new URL(url), false);
    }

    public Document readURL(String url, boolean validate) throws DocumentException, MalformedURLException {
        return this.read(new URL(url), validate);
    }

    public List<Node> selectNodes(String xPathFilterExpression, List<Node> nodes) {
        XPath xPath = this._documentFactory.createXPath(xPathFilterExpression);
        return SAXReaderImpl.toNewNodes(xPath.selectNodes(SAXReaderImpl.toOldNodes(nodes)));
    }

    public List<Node> selectNodes(String xPathFilterExpression, Node node) {
        NodeImpl nodeImpl = (NodeImpl)node;
        XPath xPath = this._documentFactory.createXPath(xPathFilterExpression);
        return SAXReaderImpl.toNewNodes(xPath.selectNodes((Object)nodeImpl.getWrappedNode()));
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public void setSecureXMLFactoryProvider(SecureXMLFactoryProvider secureXMLFactoryProvider) {
        this._secureXMLFactoryProvider = secureXMLFactoryProvider;
    }

    public void sort(List<Node> nodes, String xPathExpression) {
        XPath xPath = this._documentFactory.createXPath(xPathExpression);
        xPath.sort(SAXReaderImpl.toOldNodes(nodes));
    }

    public void sort(List<Node> nodes, String xPathExpression, boolean distinct) {
        XPath xPath = this._documentFactory.createXPath(xPathExpression);
        xPath.sort(SAXReaderImpl.toOldNodes(nodes), distinct);
    }

    protected SAXReader getSAXReader(boolean validate) {
        if (!PropsValues.XML_VALIDATION_ENABLED) {
            validate = false;
        }
        return SAXReaderFactory.getSAXReader(this._secureXMLFactoryProvider.newXMLReader(), validate, this._secure);
    }

    protected SAXReader getSAXReader(XMLSchema xmlSchema) {
        boolean validate = true;
        if (!PropsValues.XML_VALIDATION_ENABLED) {
            validate = false;
        }
        return SAXReaderFactory.getSAXReader(this._secureXMLFactoryProvider.newXMLReader(), xmlSchema, validate, this._secure);
    }
}

