/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portlet.internal.PortletContextImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.servlet.ServletContext;

public class PortletContextFactoryUtil {
    private static final Map<String, Map<String, PortletContext>> _pool = new ConcurrentHashMap<String, Map<String, PortletContext>>();

    public static PortletContext create(Portlet portlet, ServletContext servletContext) {
        Object portletContext;
        Map<String, PortletContext> portletContexts = _pool.get(portlet.getRootPortletId());
        if (portletContexts == null) {
            portletContexts = new ConcurrentHashMap<String, PortletContext>();
            _pool.put(portlet.getRootPortletId(), portletContexts);
        }
        if ((portletContext = portletContexts.get(portlet.getPortletId())) != null && PortletContextFactoryUtil._isSamePortletDeployedStatus(portlet, portletContext)) {
            return portletContext;
        }
        PortletApp portletApp = portlet.getPortletApp();
        if (!portlet.isUndeployedPortlet() && portletApp.isWARFile()) {
            servletContext = portletApp.getServletContext();
        }
        portletContext = new PortletContextImpl(portlet, servletContext);
        portletContexts.put(portlet.getPortletId(), (PortletContext)portletContext);
        return portletContext;
    }

    public static void destroy(Portlet portlet) {
        _pool.remove(portlet.getRootPortletId());
    }

    private static boolean _isSamePortletDeployedStatus(Portlet portlet, PortletContext portletContext) {
        LiferayPortletContext liferayPortletContext = (LiferayPortletContext)portletContext;
        Portlet existingPortlet = liferayPortletContext.getPortlet();
        return existingPortlet != null && portlet.isUndeployedPortlet() == existingPortlet.isUndeployedPortlet();
    }
}

