/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.webdav;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.webdav.BaseResourceImpl;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import java.io.InputStream;

public class DLFileEntryResourceImpl
extends BaseResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryResourceImpl.class);

    public DLFileEntryResourceImpl(WebDAVRequest webDAVRequest, FileEntry fileEntry, boolean appendPath) {
        super(webDAVRequest.getRootPath() + webDAVRequest.getPath(), DLFileEntryResourceImpl._getName(fileEntry, appendPath), DLFileEntryResourceImpl._getName(fileEntry, true), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getSize());
        this.setModel(fileEntry);
        this.setClassName(DLFileEntry.class.getName());
        this.setPrimaryKey(fileEntry.getPrimaryKey());
    }

    public InputStream getContentAsStream() throws WebDAVException {
        FileEntry fileEntry = this.getModel();
        try {
            FileVersion fileVersion = fileEntry.getLatestFileVersion();
            return fileVersion.getContentStream(true);
        }
        catch (Exception exception) {
            throw new WebDAVException((Throwable)exception);
        }
    }

    public String getContentType() {
        FileEntry fileEntry = this.getModel();
        try {
            FileVersion fileVersion = fileEntry.getLatestFileVersion();
            return fileVersion.getMimeType();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return fileEntry.getMimeType();
        }
    }

    public Lock getLock() {
        FileEntry fileEntry = this.getModel();
        return fileEntry.getLock();
    }

    public FileEntry getModel() {
        return (FileEntry)super.getModel();
    }

    public long getSize() {
        FileEntry fileEntry = this.getModel();
        try {
            FileVersion fileVersion = fileEntry.getLatestFileVersion();
            return fileVersion.getSize();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return fileEntry.getSize();
        }
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isLocked() {
        FileEntry fileEntry = this.getModel();
        try {
            return fileEntry.hasLock();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return false;
        }
    }

    private static String _getName(FileEntry fileEntry, boolean appendPath) {
        if (appendPath) {
            return DLWebDAVUtil.escapeRawTitle(fileEntry.getFileName());
        }
        return "";
    }
}

