/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.internal.FilterConfigImpl;
import java.io.Closeable;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.HeaderFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class InvokerFilterContainerImpl
implements Closeable,
InvokerFilterContainer {
    public static final InvokerFilterContainer EMPTY_INVOKER_FILTER_CONTAINER = new EmptyInvokerFilterContainer();
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterContainerImpl.class);
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final List<ServiceRegistrationTuple> _serviceRegistrationTuples = new CopyOnWriteArrayList<ServiceRegistrationTuple>();
    private final ServiceTrackerMap<Class<? extends javax.portlet.filter.PortletFilter>, List<javax.portlet.filter.PortletFilter>> _serviceTrackerMap;

    public InvokerFilterContainerImpl(Portlet portlet, final PortletContext portletContext) throws PortletException {
        String rootPortletId = portlet.getRootPortletId();
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, javax.portlet.filter.PortletFilter.class, (String)("(javax.portlet.name=" + rootPortletId + ")"), (serviceReference, emitter) -> {
            javax.portlet.filter.PortletFilter portletFilter = (javax.portlet.filter.PortletFilter)this._bundleContext.getService(serviceReference);
            Set lifecycles = (Set)serviceReference.getProperty("filter.lifecycles");
            if (portletFilter instanceof ActionFilter && this._isDeclaredLifecycle("ACTION_PHASE", lifecycles)) {
                emitter.emit(ActionFilter.class);
            }
            if (portletFilter instanceof EventFilter && this._isDeclaredLifecycle("EVENT_PHASE", lifecycles)) {
                emitter.emit(EventFilter.class);
            }
            if (portletFilter instanceof HeaderFilter && this._isDeclaredLifecycle("HEADER_PHASE", lifecycles)) {
                emitter.emit(HeaderFilter.class);
            }
            if (portletFilter instanceof RenderFilter && this._isDeclaredLifecycle("RENDER_PHASE", lifecycles)) {
                emitter.emit(RenderFilter.class);
            }
            if (portletFilter instanceof ResourceFilter && this._isDeclaredLifecycle("RESOURCE_PHASE", lifecycles)) {
                emitter.emit(ResourceFilter.class);
            }
            this._bundleContext.ungetService(serviceReference);
        }, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<javax.portlet.filter.PortletFilter, javax.portlet.filter.PortletFilter>(){

            public javax.portlet.filter.PortletFilter addingService(ServiceReference<javax.portlet.filter.PortletFilter> serviceReference) {
                javax.portlet.filter.PortletFilter portletFilter = (javax.portlet.filter.PortletFilter)InvokerFilterContainerImpl.this._bundleContext.getService(serviceReference);
                boolean preinitializedFilter = GetterUtil.getBoolean((Object)serviceReference.getProperty("preinitialized.filter"));
                if (!preinitializedFilter) {
                    String filterName = GetterUtil.getString((Object)serviceReference.getProperty("service.id"), (String)ClassUtil.getClassName((Object)portletFilter));
                    HashMap<String, String> params = new HashMap<String, String>();
                    for (String key : serviceReference.getPropertyKeys()) {
                        if (!key.startsWith("javax.portlet.init-param.")) continue;
                        params.put(key.substring("javax.portlet.init-param.".length()), GetterUtil.getString((Object)serviceReference.getProperty(key)));
                    }
                    FilterConfigImpl filterConfig = new FilterConfigImpl(filterName, portletContext, params);
                    try {
                        portletFilter.init((FilterConfig)filterConfig);
                    }
                    catch (PortletException portletException) {
                        _log.error((Throwable)portletException);
                        InvokerFilterContainerImpl.this._bundleContext.ungetService(serviceReference);
                        return null;
                    }
                }
                return portletFilter;
            }

            public void modifiedService(ServiceReference<javax.portlet.filter.PortletFilter> serviceReference, javax.portlet.filter.PortletFilter portletFilter) {
            }

            public void removedService(ServiceReference<javax.portlet.filter.PortletFilter> serviceReference, javax.portlet.filter.PortletFilter portletFilter) {
                InvokerFilterContainerImpl.this._bundleContext.ungetService(serviceReference);
                boolean preinitializedFilter = GetterUtil.getBoolean((Object)serviceReference.getProperty("preinitialized.filter"));
                if (preinitializedFilter) {
                    return;
                }
                portletFilter.destroy();
            }
        });
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"javax.portlet.name", (Object)rootPortletId).put((Object)"preinitialized.filter", (Object)Boolean.TRUE).build();
        Map portletFilters = portlet.getPortletFilters();
        for (Map.Entry entry : portletFilters.entrySet()) {
            PortletFilter portletFilterModel = (PortletFilter)entry.getValue();
            javax.portlet.filter.PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(javax.portlet.filter.PortletFilter.class, (Object)portletFilter, (Dictionary)HashMapDictionaryBuilder.putAll((Dictionary)properties).put((Object)"filter.lifecycles", (Object)portletFilterModel.getLifecycles()).build());
            ServiceRegistrationTuple serviceRegistrationTuple = new ServiceRegistrationTuple(portletFilterModel, (ServiceRegistration<javax.portlet.filter.PortletFilter>)serviceRegistration);
            this._serviceRegistrationTuples.add(serviceRegistrationTuple);
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
            for (String portletFilterClassName : PropsValues.PORTLET_FILTERS_SYSTEM) {
                PortletFilterImpl portletFilterModel = new PortletFilterImpl(portletFilterClassName, portletFilterClassName, Collections.emptySet(), Collections.emptyMap(), portlet.getPortletApp());
                javax.portlet.filter.PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(javax.portlet.filter.PortletFilter.class, (Object)portletFilter, (Dictionary)properties);
                this._serviceRegistrationTuples.add(new ServiceRegistrationTuple(portletFilterModel, (ServiceRegistration<javax.portlet.filter.PortletFilter>)serviceRegistration));
            }
        }
    }

    @Override
    public void close() {
        for (ServiceRegistrationTuple serviceRegistrationTuple : this._serviceRegistrationTuples) {
            PortletFilterFactory.destroy(serviceRegistrationTuple.getPortletFilterModel());
            ServiceRegistration<javax.portlet.filter.PortletFilter> serviceRegistration = serviceRegistrationTuple.getServiceRegistration();
            serviceRegistration.unregister();
        }
        this._serviceRegistrationTuples.clear();
        this._serviceTrackerMap.close();
    }

    public List<ActionFilter> getActionFilters() {
        return this._getPortletFilters(ActionFilter.class);
    }

    public List<EventFilter> getEventFilters() {
        return this._getPortletFilters(EventFilter.class);
    }

    public List<HeaderFilter> getHeaderFilters() {
        return this._getPortletFilters(HeaderFilter.class);
    }

    public List<RenderFilter> getRenderFilters() {
        return this._getPortletFilters(RenderFilter.class);
    }

    public List<ResourceFilter> getResourceFilters() {
        return this._getPortletFilters(ResourceFilter.class);
    }

    private <T extends javax.portlet.filter.PortletFilter> List<T> _getPortletFilters(Class<T> clazz) {
        List portletFilters = (List)this._serviceTrackerMap.getService(clazz);
        if (portletFilters == null) {
            return Collections.emptyList();
        }
        return portletFilters;
    }

    private boolean _isDeclaredLifecycle(String lifecycle, Set<String> lifecycles) {
        if (lifecycles == null || lifecycles.isEmpty()) {
            return true;
        }
        return lifecycles.contains(lifecycle);
    }

    private static class ServiceRegistrationTuple {
        private final PortletFilter _portletFilterModel;
        private final ServiceRegistration<javax.portlet.filter.PortletFilter> _serviceRegistration;

        public ServiceRegistrationTuple(PortletFilter portletFilterModel, ServiceRegistration<javax.portlet.filter.PortletFilter> serviceRegistration) {
            this._portletFilterModel = portletFilterModel;
            this._serviceRegistration = serviceRegistration;
        }

        public PortletFilter getPortletFilterModel() {
            return this._portletFilterModel;
        }

        public ServiceRegistration<javax.portlet.filter.PortletFilter> getServiceRegistration() {
            return this._serviceRegistration;
        }
    }

    private static class EmptyInvokerFilterContainer
    implements Closeable,
    InvokerFilterContainer {
        private EmptyInvokerFilterContainer() {
        }

        @Override
        public void close() {
        }

        public List<ActionFilter> getActionFilters() {
            return Collections.emptyList();
        }

        public List<EventFilter> getEventFilters() {
            return Collections.emptyList();
        }

        public List<HeaderFilter> getHeaderFilters() {
            return Collections.emptyList();
        }

        public List<RenderFilter> getRenderFilters() {
            return Collections.emptyList();
        }

        public List<ResourceFilter> getResourceFilters() {
            return Collections.emptyList();
        }
    }
}

