/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.ratings.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import com.liferay.ratings.kernel.service.RatingsEntryLocalServiceUtil;
import com.liferay.ratings.kernel.service.persistence.RatingsEntryPersistence;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;

public abstract class RatingsEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements IdentifiableOSGiService,
RatingsEntryLocalService {
    @BeanReference(type=RatingsEntryLocalService.class)
    protected RatingsEntryLocalService ratingsEntryLocalService;
    @BeanReference(type=RatingsEntryPersistence.class)
    protected RatingsEntryPersistence ratingsEntryPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(RatingsEntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public RatingsEntry addRatingsEntry(RatingsEntry ratingsEntry) {
        ratingsEntry.setNew(true);
        return (RatingsEntry)this.ratingsEntryPersistence.update((BaseModel)ratingsEntry);
    }

    @Transactional(enabled=false)
    public RatingsEntry createRatingsEntry(long entryId) {
        return this.ratingsEntryPersistence.create(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public RatingsEntry deleteRatingsEntry(long entryId) throws PortalException {
        return this.ratingsEntryPersistence.remove(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public RatingsEntry deleteRatingsEntry(RatingsEntry ratingsEntry) {
        return (RatingsEntry)this.ratingsEntryPersistence.remove((BaseModel)ratingsEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.ratingsEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(RatingsEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.ratingsEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.ratingsEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.ratingsEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.ratingsEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.ratingsEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public RatingsEntry fetchRatingsEntry(long entryId) {
        return this.ratingsEntryPersistence.fetchByPrimaryKey(entryId);
    }

    public RatingsEntry fetchRatingsEntryByUuidAndCompanyId(String uuid, long companyId) {
        return this.ratingsEntryPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public RatingsEntry getRatingsEntry(long entryId) throws PortalException {
        return this.ratingsEntryPersistence.findByPrimaryKey(entryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ratingsEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(RatingsEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ratingsEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(RatingsEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.ratingsEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(RatingsEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<RatingsEntry>(){

            public void performAction(RatingsEntry ratingsEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ratingsEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)RatingsEntry.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.ratingsEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement RatingsEntryLocalServiceImpl#deleteRatingsEntry(RatingsEntry) to avoid orphaned data");
        }
        return this.ratingsEntryLocalService.deleteRatingsEntry((RatingsEntry)persistedModel);
    }

    public BasePersistence<RatingsEntry> getBasePersistence() {
        return this.ratingsEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.ratingsEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public RatingsEntry getRatingsEntryByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.ratingsEntryPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<RatingsEntry> getRatingsEntries(int start, int end) {
        return this.ratingsEntryPersistence.findAll(start, end);
    }

    public int getRatingsEntriesCount() {
        return this.ratingsEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public RatingsEntry updateRatingsEntry(RatingsEntry ratingsEntry) {
        return (RatingsEntry)this.ratingsEntryPersistence.update((BaseModel)ratingsEntry);
    }

    public RatingsEntryLocalService getRatingsEntryLocalService() {
        return this.ratingsEntryLocalService;
    }

    public void setRatingsEntryLocalService(RatingsEntryLocalService ratingsEntryLocalService) {
        this.ratingsEntryLocalService = ratingsEntryLocalService;
    }

    public RatingsEntryPersistence getRatingsEntryPersistence() {
        return this.ratingsEntryPersistence;
    }

    public void setRatingsEntryPersistence(RatingsEntryPersistence ratingsEntryPersistence) {
        this.ratingsEntryPersistence = ratingsEntryPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public void afterPropertiesSet() {
        RatingsEntryLocalServiceUtil.setService((RatingsEntryLocalService)this.ratingsEntryLocalService);
    }

    public void destroy() {
        RatingsEntryLocalServiceUtil.setService(null);
    }

    public String getOSGiServiceIdentifier() {
        return RatingsEntryLocalService.class.getName();
    }

    public CTPersistence<RatingsEntry> getCTPersistence() {
        return this.ratingsEntryPersistence;
    }

    public Class<RatingsEntry> getModelClass() {
        return RatingsEntry.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<RatingsEntry>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.ratingsEntryPersistence);
    }

    protected String getModelClassName() {
        return RatingsEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.ratingsEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

