/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portlet.social.service.base.SocialRequestServiceBaseImpl;
import com.liferay.social.kernel.model.SocialRequest;

public class SocialRequestServiceImpl
extends SocialRequestServiceBaseImpl {
    public SocialRequest updateRequest(long requestId, int status, ThemeDisplay themeDisplay) throws PortalException {
        this._check(this.getPermissionChecker(), requestId, "UPDATE");
        return this.socialRequestLocalService.updateRequest(requestId, status, themeDisplay);
    }

    private void _check(PermissionChecker permissionChecker, long requestId, String actionId) throws PortalException {
        if (!this._contains(permissionChecker, requestId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, SocialRequest.class.getName(), requestId, new String[]{actionId});
        }
    }

    private boolean _contains(PermissionChecker permissionChecker, long requestId, String actionId) throws PortalException {
        if (permissionChecker.isOmniadmin()) {
            return true;
        }
        if (actionId.equals("UPDATE")) {
            SocialRequest request = this.socialRequestLocalService.getSocialRequest(requestId);
            if (permissionChecker.getUserId() == request.getReceiverUserId()) {
                return true;
            }
        }
        return false;
    }
}

