/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ImageResolutionException;
import com.liferay.portal.kernel.image.CMYKImageTool;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.module.framework.ModuleFrameworkUtil;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.launch.Framework;

public class ImageToolUtil {
    private static final Log _log = LogFactoryUtil.getLog(ImageToolUtil.class);
    private static final Snapshot<CMYKImageTool> _cmykImageToolSnapshot = new Snapshot(ImageToolUtil.class, CMYKImageTool.class);
    private static Image _defaultCompanyLogo;
    private static Image _defaultOrganizationLogo;
    private static Image _defaultSpacer;
    private static Image _defaultUserFemalePortrait;
    private static Image _defaultUserMalePortrait;
    private static Image _defaultUserPortrait;
    private static final FileImpl _fileImpl;

    public static Future<RenderedImage> convertCMYKtoRGB(byte[] bytes, String type) {
        CMYKImageTool cmykImageTool = (CMYKImageTool)_cmykImageToolSnapshot.get();
        return cmykImageTool.convertCMYKtoRGB(bytes, type);
    }

    public static BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), type);
        Graphics2D graphics2D = targetImage.createGraphics();
        graphics2D.drawRenderedImage(sourceImage, null);
        graphics2D.dispose();
        return targetImage;
    }

    public static RenderedImage crop(RenderedImage renderedImage, int height, int width, int x, int y) {
        Rectangle rectangle = new Rectangle(x, y, width, height);
        Rectangle croppedRectangle = rectangle.intersection(new Rectangle(renderedImage.getWidth(), renderedImage.getHeight()));
        BufferedImage bufferedImage = ImageToolUtil.getBufferedImage(renderedImage);
        return bufferedImage.getSubimage(croppedRectangle.x, croppedRectangle.y, croppedRectangle.width, croppedRectangle.height);
    }

    public static void encodeGIF(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        ImageIO.write(renderedImage, "gif", outputStream);
    }

    public static void encodeWBMP(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = ImageToolUtil.getBufferedImage(renderedImage);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int type = sampleModel.getDataType();
        if (bufferedImage.getType() != 12 || type < 0 || type > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            BufferedImage binaryImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            Graphics graphics = binaryImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            renderedImage = binaryImage;
        }
        if (!ImageIO.write(renderedImage, "wbmp", outputStream)) {
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(ImageToolUtil._toMultiByte(bufferedImage.getWidth()));
            outputStream.write(ImageToolUtil._toMultiByte(bufferedImage.getHeight()));
            Raster data = bufferedImage.getData();
            DataBuffer dataBuffer = data.getDataBuffer();
            int size = dataBuffer.getSize();
            for (int i = 0; i < size; ++i) {
                outputStream.write((byte)dataBuffer.getElem(i));
            }
        }
    }

    public static RenderedImage flipHorizontal(RenderedImage renderedImage) {
        BufferedImage bufferedImage = ImageToolUtil.getBufferedImage(renderedImage);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public static RenderedImage flipVertical(RenderedImage renderedImage) {
        BufferedImage bufferedImage = ImageToolUtil.getBufferedImage(renderedImage);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, -1.0);
        affineTransform.translate(0.0, -bufferedImage.getHeight());
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, null);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public static BufferedImage getBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>();
        Object[] keys = renderedImage.getPropertyNames();
        if (!ArrayUtil.isEmpty((Object[])keys)) {
            for (Object key : keys) {
                properties.put(key, renderedImage.getProperty((String)key));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), properties);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }

    public static byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ImageToolUtil.write(renderedImage, contentType, (OutputStream)unsyncByteArrayOutputStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static Image getDefaultCompanyLogo() {
        if (_defaultCompanyLogo != null) {
            return _defaultCompanyLogo;
        }
        ClassLoader classLoader = ImageToolUtil.class.getClassLoader();
        try {
            InputStream inputStream = null;
            String imageDefaultCompanyLogo = PropsUtil.get("image.default.company.logo");
            int index = imageDefaultCompanyLogo.indexOf(59);
            if (index == -1) {
                inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.company.logo"));
            } else {
                String bundleIdString = imageDefaultCompanyLogo.substring(0, index);
                int bundleId = GetterUtil.getInteger((String)bundleIdString, (int)-1);
                String name = imageDefaultCompanyLogo.substring(index + 1);
                if (bundleId < 0) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Fallback to portal class loader because of invalid bundle ID " + bundleIdString));
                    }
                    inputStream = classLoader.getResourceAsStream(name);
                } else {
                    Framework framework = ModuleFrameworkUtil.getFramework();
                    BundleContext bundleContext = framework.getBundleContext();
                    Bundle bundle = bundleContext.getBundle((long)bundleId);
                    if (bundle != null) {
                        URL url = bundle.getResource(name);
                        inputStream = url.openStream();
                    }
                }
            }
            if (inputStream == null) {
                _log.error((Object)"Default company logo is not available");
            }
            _defaultCompanyLogo = ImageToolUtil.getImage(inputStream);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to configure the default company logo: " + exception.getMessage()));
        }
        return _defaultCompanyLogo;
    }

    public static Image getDefaultOrganizationLogo() {
        if (_defaultOrganizationLogo != null) {
            return _defaultOrganizationLogo;
        }
        ClassLoader classLoader = ImageToolUtil.class.getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.organization.logo"));
            if (inputStream == null) {
                _log.error((Object)"Default organization logo is not available");
            }
            _defaultOrganizationLogo = ImageToolUtil.getImage(inputStream);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to configure the default organization logo: " + exception.getMessage()));
        }
        return _defaultOrganizationLogo;
    }

    public static Image getDefaultSpacer() {
        if (_defaultSpacer != null) {
            return _defaultSpacer;
        }
        ClassLoader classLoader = ImageToolUtil.class.getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.spacer"));
            if (inputStream == null) {
                _log.error((Object)"Default spacer is not available");
            }
            _defaultSpacer = ImageToolUtil.getImage(inputStream);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to configure the default spacer: " + exception.getMessage()));
        }
        return _defaultSpacer;
    }

    public static Image getDefaultUserFemalePortrait() {
        if (_defaultUserFemalePortrait != null) {
            return _defaultUserFemalePortrait;
        }
        ClassLoader classLoader = ImageToolUtil.class.getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.female.portrait"));
            if (inputStream == null) {
                _log.error((Object)"Default user female portrait is not available");
            }
            _defaultUserFemalePortrait = ImageToolUtil.getImage(inputStream);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to configure the default user female portrait: " + exception.getMessage()));
        }
        return _defaultUserFemalePortrait;
    }

    public static Image getDefaultUserMalePortrait() {
        if (_defaultUserMalePortrait != null) {
            return _defaultUserMalePortrait;
        }
        ClassLoader classLoader = ImageToolUtil.class.getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.male.portrait"));
            if (inputStream == null) {
                _log.error((Object)"Default user male portrait is not available");
            }
            _defaultUserMalePortrait = ImageToolUtil.getImage(inputStream);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to configure the default user male portrait: " + exception.getMessage()));
        }
        return _defaultUserMalePortrait;
    }

    public static Image getDefaultUserPortrait() {
        if (_defaultUserPortrait != null) {
            return _defaultUserPortrait;
        }
        ClassLoader classLoader = ImageToolUtil.class.getClassLoader();
        try {
            InputStream inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.portrait"));
            if (inputStream == null) {
                _log.error((Object)"Default user portrait is not available");
            }
            _defaultUserPortrait = ImageToolUtil.getImage(inputStream);
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to configure the default user portrait: " + exception.getMessage()));
        }
        return _defaultUserPortrait;
    }

    public static Image getImage(byte[] bytes) throws ImageResolutionException, IOException {
        if (bytes == null) {
            return null;
        }
        ImageBag imageBag = ImageToolUtil.read(bytes);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        if (renderedImage == null) {
            throw new IOException("Unable to decode image");
        }
        int size = bytes.length;
        ImageImpl image = new ImageImpl();
        image.setCompanyId(CompanyThreadLocal.getCompanyId());
        image.setType(imageBag.getType());
        image.setHeight(renderedImage.getHeight());
        image.setWidth(renderedImage.getWidth());
        image.setSize(size);
        image.setTextObj(bytes);
        return image;
    }

    public static Image getImage(File file) throws ImageResolutionException, IOException {
        return ImageToolUtil.getImage(_fileImpl.getBytes(file));
    }

    public static Image getImage(InputStream inputStream) throws ImageResolutionException, IOException {
        return ImageToolUtil.getImage(_fileImpl.getBytes(inputStream, -1, true));
    }

    public static Image getImage(InputStream inputStream, boolean cleanUpStream) throws ImageResolutionException, IOException {
        return ImageToolUtil.getImage(_fileImpl.getBytes(inputStream, -1, cleanUpStream));
    }

    public static boolean isNullOrDefaultSpacer(byte[] bytes) {
        return ArrayUtil.isEmpty((byte[])bytes) || Arrays.equals(bytes, ImageToolUtil.getDefaultSpacer().getTextObj());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageBag read(byte[] bytes) throws ImageResolutionException, IOException {
        String formatName = null;
        ImageInputStream imageInputStream = null;
        LinkedList<ImageReader> imageReaders = new LinkedList<ImageReader>();
        BufferedImage renderedImage = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            while (renderedImage == null && iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                imageReaders.offer(imageReader);
                try {
                    imageReader.setInput(imageInputStream);
                    int height = imageReader.getHeight(0);
                    int width = imageReader.getWidth(0);
                    if (PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT > 0L && (long)height > PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT || PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH > 0L && (long)width > PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH) {
                        throw new ImageResolutionException(StringBundler.concat((Object[])new Object[]{"Image's dimensions (", height, " px high and ", width, " px wide) exceed max dimensions (", PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT, " px high and ", PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH, " px wide)"}));
                    }
                    renderedImage = imageReader.read(0);
                }
                catch (IOException | ArrayIndexOutOfBoundsException exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)exception);
                    continue;
                }
                formatName = StringUtil.toLowerCase((String)imageReader.getFormatName());
            }
            if (renderedImage == null) {
                throw new IOException("Unsupported image type");
            }
        }
        finally {
            while (!imageReaders.isEmpty()) {
                ImageReader imageReader = (ImageReader)imageReaders.poll();
                imageReader.dispose();
            }
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        String type = "jpg";
        if (formatName.contains("bmp")) {
            type = "bmp";
        } else if (formatName.contains("gif")) {
            type = "gif";
        } else if (formatName.contains("jpeg") || StringUtil.equalsIgnoreCase((String)type, (String)"jpeg")) {
            type = "jpg";
        } else if (formatName.contains("png")) {
            type = "png";
        } else if (formatName.contains("tiff")) {
            type = "tiff";
        } else {
            throw new IllegalArgumentException(type + " is not supported");
        }
        return new ImageBag(renderedImage, type);
    }

    public static ImageBag read(File file) throws ImageResolutionException, IOException {
        return ImageToolUtil.read(_fileImpl.getBytes(file));
    }

    public static ImageBag read(InputStream inputStream) throws ImageResolutionException, IOException {
        return ImageToolUtil.read(_fileImpl.getBytes(inputStream));
    }

    public static RenderedImage rotate(RenderedImage renderedImage, int degrees) {
        BufferedImage bufferedImage = ImageToolUtil.getBufferedImage(renderedImage);
        int imageWidth = bufferedImage.getWidth();
        int imageHeight = bufferedImage.getHeight();
        double radians = Math.toRadians(degrees);
        double absoluteSin = Math.abs(Math.sin(radians));
        double absoluteCos = Math.abs(Math.cos(radians));
        int rotatedImageWidth = (int)Math.floor((double)imageWidth * absoluteCos + (double)imageHeight * absoluteSin);
        int rotatedImageHeight = (int)Math.floor((double)imageHeight * absoluteCos + (double)imageWidth * absoluteSin);
        BufferedImage rotatedBufferedImage = new BufferedImage(rotatedImageWidth, rotatedImageHeight, bufferedImage.getType());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rotatedImageWidth / 2, rotatedImageHeight / 2);
        affineTransform.rotate(radians);
        affineTransform.translate(imageWidth / -2, imageHeight / -2);
        Graphics2D graphics2D = rotatedBufferedImage.createGraphics();
        graphics2D.drawImage(bufferedImage, affineTransform, null);
        graphics2D.dispose();
        return rotatedBufferedImage;
    }

    public static RenderedImage scale(RenderedImage renderedImage, int width) {
        if (width <= 0) {
            return renderedImage;
        }
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        double factor = (double)width / (double)imageWidth;
        int scaledHeight = (int)Math.round(factor * (double)imageHeight);
        int scaledWidth = width;
        return ImageToolUtil._scale(renderedImage, scaledHeight, scaledWidth);
    }

    public static RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        if (maxHeight == 0) {
            maxHeight = imageHeight;
        }
        if (maxWidth == 0) {
            maxWidth = imageWidth;
        }
        if (imageHeight <= maxHeight && imageWidth <= maxWidth) {
            return renderedImage;
        }
        double factor = Math.min((double)maxHeight / (double)imageHeight, (double)maxWidth / (double)imageWidth);
        int scaledHeight = Math.max(1, (int)Math.round(factor * (double)imageHeight));
        int scaledWidth = Math.max(1, (int)Math.round(factor * (double)imageWidth));
        return ImageToolUtil._scale(renderedImage, scaledHeight, scaledWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(RenderedImage renderedImage, String contentType, OutputStream outputStream) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(contentType);
        if (!iterator.hasNext()) {
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(renderedImage);
            iterator = ImageIO.getImageWriters(imageTypeSpecifier, contentType);
        }
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
            try {
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(renderedImage);
                return;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
            finally {
                imageWriter.dispose();
                imageOutputStream.flush();
            }
        }
        throw new IOException("No image writer is available for image type");
    }

    private static RenderedImage _scale(RenderedImage renderedImage, int scaledHeight, int scaledWidth) {
        int startWidth;
        BufferedImage originalBufferedImage = ImageToolUtil.getBufferedImage(renderedImage);
        int type = originalBufferedImage.getType();
        if (type == 13 || type == 0) {
            type = 2;
        }
        BufferedImage scaledBufferedImage = new BufferedImage(scaledWidth, scaledHeight, type);
        int originalHeight = originalBufferedImage.getHeight();
        int originalWidth = originalBufferedImage.getWidth();
        if (scaledHeight * 2 >= originalHeight && scaledWidth * 2 >= originalWidth) {
            Graphics2D scaledGraphics2D = scaledBufferedImage.createGraphics();
            scaledGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            scaledGraphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            scaledGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            scaledGraphics2D.drawImage(originalBufferedImage, 0, 0, scaledWidth, scaledHeight, null);
            scaledGraphics2D.dispose();
            return scaledBufferedImage;
        }
        BufferedImage tempBufferedImage = new BufferedImage(originalWidth, originalHeight, scaledBufferedImage.getType());
        Graphics2D tempGraphics2D = tempBufferedImage.createGraphics();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        tempGraphics2D.setRenderingHints(renderingHints);
        ColorModel originalColorModel = originalBufferedImage.getColorModel();
        if (originalColorModel.hasAlpha()) {
            tempGraphics2D.setComposite(AlphaComposite.Src);
        }
        int startHeight = scaledHeight;
        for (startWidth = scaledWidth; startHeight < originalHeight && startWidth < originalWidth; startHeight *= 2, startWidth *= 2) {
        }
        originalHeight = startHeight / 2;
        originalWidth = startWidth / 2;
        tempGraphics2D.drawImage(originalBufferedImage, 0, 0, originalWidth, originalHeight, null);
        while (originalHeight >= scaledHeight * 2 && originalWidth >= scaledWidth * 2) {
            if ((originalHeight /= 2) < scaledHeight) {
                originalHeight = scaledHeight;
            }
            if ((originalWidth /= 2) < scaledWidth) {
                originalWidth = scaledWidth;
            }
            tempGraphics2D.drawImage(tempBufferedImage, 0, 0, originalWidth, originalHeight, 0, 0, originalWidth * 2, originalHeight * 2, null);
        }
        tempGraphics2D.dispose();
        Graphics2D scaledGraphics2D = scaledBufferedImage.createGraphics();
        scaledGraphics2D.drawImage(tempBufferedImage, 0, 0, scaledWidth, scaledHeight, 0, 0, originalWidth, originalHeight, null);
        scaledGraphics2D.dispose();
        return scaledBufferedImage;
    }

    private static byte[] _toMultiByte(int intValue) {
        int numBits = 32;
        for (int mask = Integer.MIN_VALUE; mask != 0 && (intValue & mask) == 0; mask >>>= 1) {
            --numBits;
        }
        int numBitsLeft = numBits;
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        for (int b = 0; b <= maxIndex; ++b) {
            multiBytes[b] = (byte)(intValue >>> (maxIndex - b) * 7 & 0x7F);
            if (b == maxIndex) continue;
            int n = b;
            multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
        }
        return multiBytes;
    }

    static {
        _fileImpl = FileImpl.getInstance();
        ImageIO.setUseCache(PropsValues.IMAGE_IO_USE_DISK_CACHE);
    }
}

