/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserConstants;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.ContactLocalServiceUtil;
import com.liferay.portal.kernel.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PasswordPolicyLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.WebsiteLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ContactImpl;
import com.liferay.portal.model.impl.UserBaseImpl;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.users.admin.kernel.util.UserInitialsGeneratorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public class UserImpl
extends UserBaseImpl {
    private static final boolean _HAS_USERS_PROFILE_FRIENDLY_URL = Validator.isNotNull((String)PropsValues.USERS_PROFILE_FRIENDLY_URL);
    private static final Contact _NULL_CONTACT = new ContactImpl();
    private static final Log _log = LogFactoryUtil.getLog(UserImpl.class);
    private Contact _contact;
    private long[] _groupIds;
    private Locale _locale;
    private long[] _organizationIds;
    private boolean _passwordModified;
    private PasswordPolicy _passwordPolicy;
    private String _passwordUnencrypted;
    private long[] _roleIds;
    private long[] _teamIds;
    private TimeZone _timeZone;
    private long[] _userGroupIds;

    public Contact fetchContact() {
        if (this._contact == _NULL_CONTACT) {
            return null;
        }
        if (this._contact == null) {
            Contact contact = ContactLocalServiceUtil.fetchContact((long)this.getContactId());
            this._contact = contact == null ? _NULL_CONTACT : contact;
        }
        return this._contact;
    }

    public String fetchPortraitURL(ThemeDisplay themeDisplay) {
        Contact contact = this.fetchContact();
        if (contact == null) {
            return "";
        }
        return UserConstants.getPortraitURL((String)themeDisplay.getPathImage(), (boolean)contact.isMale(), (long)this.getPortraitId(), (String)this.getUserUuid());
    }

    public List<Address> getAddresses() {
        return AddressLocalServiceUtil.getAddresses((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public List<Group> getAllGroups() throws PortalException {
        return ListUtil.concat((List[])new List[]{this.getGroups(), this.getInheritedGroups(), this.getInheritedSiteGroups(), this.getOrganizationsGroups(), this.getSiteGroups()});
    }

    public List<Role> getAllRoles() throws PortalException {
        return ListUtil.concat((List[])new List[]{this.getInheritedRoles(), this.getInheritedSiteRoles(), this.getOrganizationsRoles(), this.getRoles(), this.getSiteRoles()});
    }

    public Date getBirthday() throws PortalException {
        return this.getContact().getBirthday();
    }

    public String getCompanyMx() throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.getMx();
    }

    public Contact getContact() throws PortalException {
        if (this._contact == null || this._contact == _NULL_CONTACT) {
            this._contact = ContactLocalServiceUtil.getContact((long)this.getContactId());
        }
        return this._contact;
    }

    @Deprecated
    public String getDigest(String password) {
        return DigesterUtil.digestHex((String)"MD5", (String[])new String[]{String.valueOf(this.getUserId()), "PortalRealm", password});
    }

    public String getDisplayEmailAddress() {
        String emailAddress = super.getEmailAddress();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isFake(emailAddress)) {
            emailAddress = "";
        }
        return emailAddress;
    }

    public String getDisplayURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getDisplayURL(themeDisplay, false);
    }

    public String getDisplayURL(ThemeDisplay themeDisplay, boolean privateLayout) throws PortalException {
        if (this.isGuestUser() || themeDisplay == null) {
            return "";
        }
        String profileFriendlyURL = this.getProfileFriendlyURL();
        if (profileFriendlyURL != null) {
            return PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)StringBundler.concat((String[])new String[]{themeDisplay.getPortalURL(), PortalUtil.getPathContext(), profileFriendlyURL}));
        }
        Group group = this.getGroup();
        return group.getDisplayURL(themeDisplay, privateLayout);
    }

    public List<EmailAddress> getEmailAddresses() {
        return EmailAddressLocalServiceUtil.getEmailAddresses((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public boolean getFemale() throws PortalException {
        return !this.getMale();
    }

    @AutoEscape
    public String getFullName() {
        return this.getFullName(false, false);
    }

    @AutoEscape
    public String getFullName(boolean usePrefix, boolean useSuffix) {
        Contact contact;
        Contact contact2;
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        long prefixListTypeId = 0L;
        if (usePrefix && (contact2 = this.fetchContact()) != null) {
            prefixListTypeId = contact2.getPrefixListTypeId();
        }
        long suffixListTypeId = 0L;
        if (useSuffix && (contact = this.fetchContact()) != null) {
            suffixListTypeId = contact.getSuffixListTypeId();
        }
        return fullNameGenerator.getLocalizedFullName(this.getFirstName(), this.getMiddleName(), this.getLastName(), this.getLocale(), prefixListTypeId, suffixListTypeId);
    }

    public Group getGroup() {
        return GroupLocalServiceUtil.fetchUserGroup((long)this.getCompanyId(), (long)this.getUserId());
    }

    public long getGroupId() {
        Group group = this.getGroup();
        return group.getGroupId();
    }

    public long[] getGroupIds() {
        if (this._groupIds == null) {
            this._groupIds = UserLocalServiceUtil.getGroupPrimaryKeys((long)this.getUserId());
        }
        return this._groupIds;
    }

    public List<Group> getGroups() {
        return GroupLocalServiceUtil.getUserGroups((long)this.getUserId());
    }

    public List<Group> getInheritedGroups() throws PortalException {
        return GroupLocalServiceUtil.getUserGroupsGroups(this.getUserGroups());
    }

    public List<Role> getInheritedRoles() throws PortalException {
        HashSet roles = new HashSet();
        for (Group group2 : ListUtil.filter(this.getAllGroups(), group -> RoleLocalServiceUtil.hasGroupRoles((long)group.getGroupId()))) {
            roles.addAll(RoleLocalServiceUtil.getGroupRoles((long)group2.getGroupId()));
        }
        return ListUtil.fromCollection(roles);
    }

    public List<Group> getInheritedSiteGroups() throws PortalException {
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(GroupLocalServiceUtil.getUserGroupsRelatedGroups(this.getUserGroups()));
        groups.addAll(this._getOrganizationRelatedGroups());
        return ListUtil.fromCollection(groups);
    }

    public List<Role> getInheritedSiteRoles() {
        return TransformUtil.transform((Collection)UserGroupGroupRoleLocalServiceUtil.getUserGroupGroupRolesByUser((long)this.getUserId()), UserGroupGroupRole::getRole);
    }

    public String getInitials() {
        String initials = UserInitialsGeneratorUtil.getInitials((User)this);
        if (initials == null) {
            String firstInitial = StringUtil.shorten((String)this.getFirstName(), (int)1);
            String lastInitial = StringUtil.shorten((String)this.getLastName(), (int)1);
            initials = StringUtil.toUpperCase((String)firstInitial.concat(lastInitial));
        }
        return initials;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getLogin() throws PortalException {
        String login = null;
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        String authType = company.getAuthType();
        if (authType.equals("emailAddress")) {
            login = this.getEmailAddress();
        } else if (authType.equals("screenName")) {
            login = this.getScreenName();
        } else if (authType.equals("userId")) {
            login = String.valueOf(this.getUserId());
        }
        return login;
    }

    public boolean getMale() throws PortalException {
        return this.getContact().getMale();
    }

    public List<Group> getMySiteGroups() throws PortalException {
        return this.getMySiteGroups(null, -1);
    }

    public List<Group> getMySiteGroups(int max) throws PortalException {
        return this.getMySiteGroups(null, max);
    }

    public List<Group> getMySiteGroups(String[] classNames, int max) throws PortalException {
        return GroupServiceUtil.getUserSitesGroups((long)this.getUserId(), (String[])classNames, (int)max);
    }

    public long[] getOrganizationIds() throws PortalException {
        if (this._organizationIds == null) {
            this._organizationIds = UserLocalServiceUtil.getOrganizationPrimaryKeys((long)this.getUserId());
        }
        return this._organizationIds;
    }

    public long[] getOrganizationIds(boolean includeAdministrative) throws PortalException {
        if (!includeAdministrative) {
            return this.getOrganizationIds();
        }
        return OrganizationLocalServiceUtil.getUserOrganizationIds((long)this.getUserId(), (boolean)true);
    }

    public List<Organization> getOrganizations() throws PortalException {
        return this.getOrganizations(false, false);
    }

    public List<Organization> getOrganizations(boolean includeAdministrative) throws PortalException {
        return this.getOrganizations(includeAdministrative, false);
    }

    public List<Organization> getOrganizations(boolean includeAdministrative, boolean includeParentOrganizations) throws PortalException {
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId(), (boolean)includeAdministrative);
        if (includeParentOrganizations) {
            organizations.addAll(this._getParentOrganizations(organizations));
        }
        return organizations;
    }

    public List<Group> getOrganizationsGroups() throws PortalException {
        return GroupLocalServiceUtil.getOrganizationsGroups(this.getOrganizations(false, !PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT));
    }

    public List<Role> getOrganizationsRoles() throws PortalException {
        return TransformUtil.transform((Collection)ListUtil.filter(this.getUserGroupRoles(), UserGroupRole::hasOrganizationRole), UserGroupRole::getRole);
    }

    @Override
    public String getOriginalEmailAddress() {
        return (String)this.getColumnOriginalValue("emailAddress");
    }

    public boolean getPasswordModified() {
        return this._passwordModified;
    }

    public PasswordPolicy getPasswordPolicy() throws PortalException {
        if (this._passwordPolicy == null) {
            this._passwordPolicy = PasswordPolicyLocalServiceUtil.getPasswordPolicyByUser((User)this);
        }
        return this._passwordPolicy;
    }

    public String getPasswordUnencrypted() {
        return this._passwordUnencrypted;
    }

    public List<Phone> getPhones() {
        return PhoneLocalServiceUtil.getPhones((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public String getPortraitURL(ThemeDisplay themeDisplay) throws PortalException {
        return UserConstants.getPortraitURL((String)themeDisplay.getPathImage(), (boolean)this.isMale(), (long)this.getPortraitId(), (String)this.getUserUuid());
    }

    public int getPrivateLayoutsPageCount() throws PortalException {
        return LayoutLocalServiceUtil.getLayoutsCount((User)this, (boolean)true);
    }

    public int getPublicLayoutsPageCount() throws PortalException {
        return LayoutLocalServiceUtil.getLayoutsCount((User)this, (boolean)false);
    }

    public Set<String> getReminderQueryQuestions() throws PortalException {
        TreeSet<String> questions = new TreeSet<String>();
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)this.getUserId());
        for (Organization organization : organizations) {
            Set organizationQuestions = organization.getReminderQueryQuestions(this.getLanguageId());
            if (organizationQuestions.isEmpty()) {
                for (Organization parentOrganization = organization.getParentOrganization(); organizationQuestions.isEmpty() && parentOrganization != null; parentOrganization = parentOrganization.getParentOrganization()) {
                    organizationQuestions = parentOrganization.getReminderQueryQuestions(this.getLanguageId());
                }
            }
            questions.addAll(organizationQuestions);
        }
        if (questions.isEmpty()) {
            Set defaultQuestions = SetUtil.fromArray((Object[])PrefsPropsUtil.getStringArray((long)this.getCompanyId(), (String)"users.reminder.queries.questions", (String)","));
            questions.addAll(defaultQuestions);
        }
        return questions;
    }

    public long[] getRoleIds() {
        if (this._roleIds == null) {
            this._roleIds = UserLocalServiceUtil.getRolePrimaryKeys((long)this.getUserId());
        }
        return this._roleIds;
    }

    public List<Role> getRoles() {
        return RoleLocalServiceUtil.getUserRoles((long)this.getUserId());
    }

    public List<Group> getSiteGroups() throws PortalException {
        return this.getSiteGroups(false);
    }

    public List<Group> getSiteGroups(boolean includeAdministrative) throws PortalException {
        return GroupLocalServiceUtil.getUserSitesGroups((long)this.getUserId(), (boolean)includeAdministrative);
    }

    public List<Role> getSiteRoles() throws PortalException {
        return TransformUtil.transform((Collection)ListUtil.filter(this.getUserGroupRoles(), UserGroupRole::hasSiteRole), UserGroupRole::getRole);
    }

    public long[] getTeamIds() {
        if (this._teamIds == null) {
            this._teamIds = UserLocalServiceUtil.getTeamPrimaryKeys((long)this.getUserId());
        }
        return this._teamIds;
    }

    public List<Team> getTeams() {
        return TeamLocalServiceUtil.getUserTeams((long)this.getUserId());
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    public Date getUnlockDate() throws PortalException {
        return this.getUnlockDate(this.getPasswordPolicy());
    }

    public Date getUnlockDate(PasswordPolicy passwordPolicy) {
        Date lockoutDate = this.getLockoutDate();
        return new Date(lockoutDate.getTime() + passwordPolicy.getLockoutDuration() * 1000L);
    }

    public long[] getUserGroupIds() {
        if (this._userGroupIds == null) {
            this._userGroupIds = UserLocalServiceUtil.getUserGroupPrimaryKeys((long)this.getUserId());
        }
        return this._userGroupIds;
    }

    public List<UserGroupRole> getUserGroupRoles() throws PortalException {
        return UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)this.getUserId());
    }

    public List<UserGroup> getUserGroups() {
        return UserGroupLocalServiceUtil.getUserUserGroups((long)this.getUserId());
    }

    public List<Website> getWebsites() {
        return WebsiteLocalServiceUtil.getWebsites((long)this.getCompanyId(), (String)Contact.class.getName(), (long)this.getContactId());
    }

    public boolean hasCompanyMx() throws PortalException {
        return this.hasCompanyMx(this.getEmailAddress());
    }

    public boolean hasCompanyMx(String emailAddress) throws PortalException {
        if (Validator.isNull((String)emailAddress)) {
            return false;
        }
        Company company = CompanyLocalServiceUtil.getCompanyById((long)this.getCompanyId());
        return company.hasCompanyMx(emailAddress);
    }

    public boolean hasMySites() throws PortalException {
        if (this.isGuestUser()) {
            return false;
        }
        if ((PrefsPropsUtil.getBoolean((long)this.getCompanyId(), (String)"layout.user.private.layouts.enabled") || PrefsPropsUtil.getBoolean((long)this.getCompanyId(), (String)"layout.user.public.layouts.enabled")) && this.getUserId() == PrincipalThreadLocal.getUserId()) {
            return true;
        }
        List<Group> groups = this.getMySiteGroups(1);
        return !groups.isEmpty();
    }

    public boolean hasOrganization() {
        return OrganizationLocalServiceUtil.hasUserOrganizations((long)this.getUserId());
    }

    public boolean hasPrivateLayouts() throws PortalException {
        return LayoutLocalServiceUtil.hasLayouts((User)this, (boolean)true);
    }

    public boolean hasPublicLayouts() throws PortalException {
        return LayoutLocalServiceUtil.hasLayouts((User)this, (boolean)false);
    }

    public boolean hasReminderQuery() {
        return Validator.isNotNull((String)this.getReminderQueryQuestion()) && Validator.isNotNull((String)this.getReminderQueryAnswer());
    }

    public boolean isActive() {
        return this.getStatus() == 0;
    }

    @Deprecated
    public boolean isDefaultUser() {
        return this.isGuestUser();
    }

    public boolean isEmailAddressComplete() {
        if (this.isGuestUser()) {
            return true;
        }
        return !Validator.isNull((String)this.getEmailAddress()) && (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED || !Validator.isNull((String)this.getDisplayEmailAddress()));
    }

    public boolean isEmailAddressVerificationComplete() {
        if (this.isGuestUser() || this.isEmailAddressVerified() || this.isServiceAccountUser()) {
            return true;
        }
        boolean emailAddressVerificationRequired = false;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            emailAddressVerificationRequired = company.isStrangersVerify();
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return !emailAddressVerificationRequired;
    }

    public boolean isFemale() throws PortalException {
        return this.getFemale();
    }

    public boolean isGuestUser() {
        return this.getType() == 0;
    }

    public boolean isMale() throws PortalException {
        return this.getMale();
    }

    public boolean isOnDemandUser() {
        return this.getType() == 4;
    }

    public boolean isPasswordModified() {
        return this._passwordModified;
    }

    public boolean isPasswordResetRequired() {
        return !this.isGuestUser() && this.isPasswordReset() && !this.isServiceAccountUser();
    }

    public boolean isReminderQueryComplete() {
        if (this.isGuestUser() || this.isOnDemandUser()) {
            return true;
        }
        return !PrefsPropsUtil.getBoolean((long)this.getCompanyId(), (String)"users.reminder.queries.enabled", (boolean)PropsValues.USERS_REMINDER_QUERIES_ENABLED) || !Validator.isNull((String)this.getReminderQueryQuestion()) && !Validator.isNull((String)this.getReminderQueryAnswer());
    }

    public boolean isServiceAccountUser() {
        return this.getType() == 2 || this.getType() == 3;
    }

    public boolean isSetupComplete() {
        if (this.isGuestUser()) {
            return true;
        }
        return this.isEmailAddressComplete() && this.isEmailAddressVerificationComplete() && !this._isRequirePasswordReset() && this.isReminderQueryComplete() && this.isTermsOfUseComplete();
    }

    public boolean isTermsOfUseComplete() {
        if (this.isGuestUser() || this.isAgreedToTermsOfUse()) {
            return true;
        }
        boolean termsOfUseRequired = PrefsPropsUtil.getBoolean((long)this.getCompanyId(), (String)"terms.of.use.required", (boolean)PropsValues.TERMS_OF_USE_REQUIRED);
        return !termsOfUseRequired;
    }

    public void setContact(Contact contact) {
        this._contact = contact;
    }

    @Override
    @Deprecated
    public void setDigest(String digest) {
        super.setDigest(digest);
    }

    public void setGroupIds(long[] groupIds) {
        this._groupIds = groupIds;
    }

    @Override
    public void setLanguageId(String languageId) {
        this._locale = this.isGuestUser() ? LocaleUtil.fromLanguageId((String)languageId, (boolean)false) : LocaleUtil.fromLanguageId((String)languageId);
        super.setLanguageId(LocaleUtil.toLanguageId((Locale)this._locale));
    }

    public void setOrganizationIds(long[] organizationIds) {
        this._organizationIds = organizationIds;
    }

    public void setPasswordModified(boolean passwordModified) {
        this._passwordModified = passwordModified;
    }

    public void setPasswordUnencrypted(String passwordUnencrypted) {
        this._passwordUnencrypted = passwordUnencrypted;
    }

    public void setRoleIds(long[] roleIds) {
        this._roleIds = roleIds;
    }

    public void setTeamIds(long[] teamIds) {
        this._teamIds = teamIds;
    }

    @Override
    public void setTimeZoneId(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            TimeZone defaultTimeZone = TimeZoneUtil.getDefault();
            timeZoneId = defaultTimeZone.getID();
        }
        this._timeZone = TimeZoneUtil.getTimeZone((String)timeZoneId);
        super.setTimeZoneId(timeZoneId);
    }

    public void setUserGroupIds(long[] userGroupIds) {
        this._userGroupIds = userGroupIds;
    }

    protected String getProfileFriendlyURL() {
        if (!_HAS_USERS_PROFILE_FRIENDLY_URL) {
            return null;
        }
        String normalizedScreenName = FriendlyURLNormalizerUtil.normalize((String)this.getScreenName());
        return StringUtil.replace((String)PropsValues.USERS_PROFILE_FRIENDLY_URL, (String[])new String[]{"${liferay:screenName}", "${liferay:userId}"}, (String[])new String[]{HtmlUtil.escapeURL((String)normalizedScreenName), String.valueOf(this.getUserId())});
    }

    private List<Group> _getOrganizationRelatedGroups() throws PortalException {
        List<Organization> organizations = this.getOrganizations(false, !PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT);
        if (organizations.isEmpty()) {
            return Collections.emptyList();
        }
        return GroupLocalServiceUtil.getOrganizationsRelatedGroups(organizations);
    }

    private List<Organization> _getParentOrganizations(List<Organization> organizations) throws PortalException {
        ArrayList<Organization> parentOrganizations = new ArrayList<Organization>();
        for (Organization organization : organizations) {
            Organization parentOrganization = organization.getParentOrganization();
            if (parentOrganization == null || organizations.contains(parentOrganization)) continue;
            parentOrganizations.add(parentOrganization);
        }
        return parentOrganizations;
    }

    private boolean _isRequirePasswordReset() {
        return this.isPasswordReset() && (this._passwordPolicy == null || this._passwordPolicy.isChangeable());
    }
}

