/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.registry;

import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.repository.registry.RepositoryDefiner;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.repository.registry.RepositoryClassDefinition;
import com.liferay.portal.repository.registry.RepositoryClassDefinitionCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class RepositoryClassDefinitionCatalogImpl
implements CacheRegistryItem,
RepositoryClassDefinitionCatalog {
    private final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private final Map<Long, Map<String, RepositoryClassDefinition>> _externalRepositoryClassDefinitions = new ConcurrentHashMap<Long, Map<String, RepositoryClassDefinition>>();
    private final Map<Long, Map<String, RepositoryClassDefinition>> _repositoryClassDefinitions = new ConcurrentHashMap<Long, Map<String, RepositoryClassDefinition>>();
    private ServiceTracker<RepositoryDefiner, ServiceRegistration<RepositoryFactory>> _serviceTracker;

    public void afterPropertiesSet() {
        this._serviceTracker = new ServiceTracker(this._bundleContext, RepositoryDefiner.class, (ServiceTrackerCustomizer)new RepositoryDefinerServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    @Override
    public Iterable<RepositoryClassDefinition> getExternalRepositoryClassDefinitions(long companyId) {
        Collection<RepositoryClassDefinition> externalRepositoryClassDefinitions = this._getSystemExternalRepositoryData(Map::values);
        Map<String, RepositoryClassDefinition> companyRepositoryClassDefinitions = this._externalRepositoryClassDefinitions.get(companyId);
        if (companyRepositoryClassDefinitions != null) {
            externalRepositoryClassDefinitions.addAll(companyRepositoryClassDefinitions.values());
        }
        return externalRepositoryClassDefinitions;
    }

    @Override
    public Collection<String> getExternalRepositoryClassNames(long companyId) {
        Collection<String> externalRepositoryClassNames = this._getSystemExternalRepositoryData(Map::keySet);
        Map<String, RepositoryClassDefinition> companyRepositoryClassDefinitions = this._externalRepositoryClassDefinitions.get(companyId);
        if (companyRepositoryClassDefinitions != null) {
            externalRepositoryClassNames.addAll(companyRepositoryClassDefinitions.keySet());
        }
        return externalRepositoryClassNames;
    }

    public String getRegistryName() {
        Class<?> clazz = this.getClass();
        return clazz.getName();
    }

    @Override
    public RepositoryClassDefinition getRepositoryClassDefinition(long companyId, String className) {
        Map<String, RepositoryClassDefinition> companyRepositoryClassDefinitions = this._repositoryClassDefinitions.get(companyId);
        if (companyRepositoryClassDefinitions == null) {
            return this._getSystemRepositoryClassDefinition(className);
        }
        RepositoryClassDefinition repositoryClassDefinition = companyRepositoryClassDefinitions.get(className);
        if (repositoryClassDefinition == null) {
            return this._getSystemRepositoryClassDefinition(className);
        }
        return repositoryClassDefinition;
    }

    public void invalidate() {
        for (Map<String, RepositoryClassDefinition> companyRepositoryClassDefinitions : this._repositoryClassDefinitions.values()) {
            for (RepositoryClassDefinition repositoryClassDefinition : companyRepositoryClassDefinitions.values()) {
                repositoryClassDefinition.invalidateCache();
            }
        }
    }

    private <T> Collection<T> _getSystemExternalRepositoryData(Function<Map<String, RepositoryClassDefinition>, Collection<T>> function) {
        Map<String, RepositoryClassDefinition> systemRepositoryClassDefinitions = this._externalRepositoryClassDefinitions.get(0L);
        if (systemRepositoryClassDefinitions == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(function.apply(systemRepositoryClassDefinitions));
    }

    private RepositoryClassDefinition _getSystemRepositoryClassDefinition(String className) {
        Map<String, RepositoryClassDefinition> systemRepositoryClassDefinitions = this._repositoryClassDefinitions.get(0L);
        if (systemRepositoryClassDefinitions == null) {
            return null;
        }
        return systemRepositoryClassDefinitions.get(className);
    }

    private class RepositoryDefinerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<RepositoryDefiner, ServiceRegistration<RepositoryFactory>> {
        private RepositoryDefinerServiceTrackerCustomizer() {
        }

        public ServiceRegistration<RepositoryFactory> addingService(ServiceReference<RepositoryDefiner> serviceReference) {
            Map companyRepositoryClassDefinitions;
            long companyId = GetterUtil.getLong((Object)serviceReference.getProperty("companyId"));
            RepositoryDefiner repositoryDefiner = (RepositoryDefiner)RepositoryClassDefinitionCatalogImpl.this._bundleContext.getService(serviceReference);
            String className = repositoryDefiner.getClassName();
            RepositoryClassDefinition repositoryClassDefinition = RepositoryClassDefinition.fromRepositoryDefiner(repositoryDefiner);
            if (repositoryDefiner.isExternalRepository()) {
                companyRepositoryClassDefinitions = RepositoryClassDefinitionCatalogImpl.this._externalRepositoryClassDefinitions.computeIfAbsent(companyId, key -> new ConcurrentHashMap());
                companyRepositoryClassDefinitions.put(className, repositoryClassDefinition);
            }
            companyRepositoryClassDefinitions = RepositoryClassDefinitionCatalogImpl.this._repositoryClassDefinitions.computeIfAbsent(companyId, key -> new ConcurrentHashMap());
            companyRepositoryClassDefinitions.put(className, repositoryClassDefinition);
            return RepositoryClassDefinitionCatalogImpl.this._bundleContext.registerService(RepositoryFactory.class, (Object)repositoryClassDefinition, MapUtil.singletonDictionary((Object)"class.name", (Object)className));
        }

        public void modifiedService(ServiceReference<RepositoryDefiner> serviceReference, ServiceRegistration<RepositoryFactory> serviceRegistration) {
        }

        public void removedService(ServiceReference<RepositoryDefiner> serviceReference, ServiceRegistration<RepositoryFactory> serviceRegistration) {
            RepositoryClassDefinitionCatalogImpl.this._bundleContext.ungetService(serviceReference);
            ServiceReference repositoryFactoryServiceReference = serviceRegistration.getReference();
            long companyId = GetterUtil.getLong((Object)repositoryFactoryServiceReference.getProperty("companyId"));
            String className = (String)repositoryFactoryServiceReference.getProperty("class.name");
            Map companyExternalRepositoryClassDefinitions = (Map)RepositoryClassDefinitionCatalogImpl.this._externalRepositoryClassDefinitions.get(companyId);
            companyExternalRepositoryClassDefinitions.remove(className);
            Map companyRepositoryClassDefinitions = (Map)RepositoryClassDefinitionCatalogImpl.this._repositoryClassDefinitions.get(companyId);
            companyRepositoryClassDefinitions.remove(className);
            serviceRegistration.unregister();
        }
    }
}

