/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceCache;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.BaseTemplateResourceCache;
import com.liferay.portal.template.TemplateResourceParser;
import org.osgi.framework.BundleContext;

public abstract class BaseTemplateResourceLoader
implements TemplateResourceLoader {
    private static final Log _log = LogFactoryUtil.getLog(BaseTemplateResourceLoader.class);
    private String _name;
    private ServiceTrackerList<TemplateResourceParser> _serviceTrackerList;
    private TemplateResourceCache _templateResourceCache;

    public void clearCache() {
        this._templateResourceCache.clear();
    }

    public void clearCache(String templateId) {
        this._templateResourceCache.remove(templateId);
    }

    public void destroy() {
        this._serviceTrackerList.close();
    }

    public String getName() {
        return this._name;
    }

    public TemplateResource getTemplateResource(String templateId) {
        if (!this._templateResourceCache.isEnabled()) {
            return this._loadFromParser(templateId);
        }
        TemplateResource templateResource = this._templateResourceCache.getTemplateResource(templateId);
        if (templateResource == BaseTemplateResourceCache.DUMMY_TEMPLATE_RESOURCE) {
            return null;
        }
        if (templateResource == null) {
            templateResource = this._loadFromParser(templateId);
            this._templateResourceCache.put(templateId, templateResource);
        }
        return templateResource;
    }

    public boolean hasTemplateResource(String templateId) {
        TemplateResource templateResource = this.getTemplateResource(templateId);
        return templateResource != null;
    }

    protected void init(BundleContext bundleContext, String name, TemplateResourceCache templateResourceCache) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException("Template resource loader name is null");
        }
        this._name = name;
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, TemplateResourceParser.class, (String)("(lang.type=" + this._name + ")"));
        this._templateResourceCache = templateResourceCache;
    }

    private TemplateResource _loadFromParser(String templateId) {
        for (TemplateResourceParser templateResourceParser : this._serviceTrackerList) {
            try {
                TemplateResource templateResource;
                if (!templateResourceParser.isTemplateResourceValid(templateId, this.getName()) || (templateResource = templateResourceParser.getTemplateResource(templateId)) == null) continue;
                return templateResource;
            }
            catch (TemplateException templateException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse template ", templateId, " with parser ", templateResourceParser}), (Throwable)templateException);
            }
        }
        return null;
    }
}

