/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ReleaseConstants;
import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeVersionTreeMap;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.util.PortalUpgradeProcessRegistry;
import com.liferay.portal.upgrade.v7_3_x.PortalUpgradeProcessRegistryImpl;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;

public class PortalUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(PortalUpgradeProcess.class);
    private static final DCLSingleton<PortalReleaseDTO> _currentPortalReleaseDTODCLSingleton = new DCLSingleton();
    private static final Version _initialSchemaVersion = new Version(0, 1, 0);
    private static final UpgradeVersionTreeMap _upgradeVersionTreeMap = new UpgradeVersionTreeMap(){
        {
            this.put(_initialSchemaVersion, (UpgradeProcess)new DummyUpgradeProcess());
        }
    };

    public static void createPortalRelease(Connection connection) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"insert into Release_ (releaseId, createDate, ", "modifiedDate, servletContextName, schemaVersion, ", "buildNumber, buildDate, verified, testString) values (", 1L, ", ?, ?, ?, ?, ?, ?, ?, ?)"}));){
            Date date = new Date(System.currentTimeMillis());
            preparedStatement.setDate(1, date);
            preparedStatement.setDate(2, date);
            preparedStatement.setString(3, "portal");
            Version schemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
            preparedStatement.setString(4, String.valueOf(schemaVersion));
            preparedStatement.setInt(5, ReleaseInfo.getBuildNumber());
            java.util.Date buildDate = ReleaseInfo.getBuildDate();
            preparedStatement.setDate(6, new Date(buildDate.getTime()));
            preparedStatement.setBoolean(7, false);
            preparedStatement.setString(8, ReleaseConstants.TEST_STRING);
            preparedStatement.executeUpdate();
            _currentPortalReleaseDTODCLSingleton.destroy(null);
            _currentPortalReleaseDTODCLSingleton.getSingleton(() -> new PortalReleaseDTO(schemaVersion, ReleaseInfo.getBuildNumber(), buildDate, 0, ReleaseConstants.TEST_STRING));
        }
    }

    public static java.util.Date getCurrentBuildDate(Connection connection) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        if (portalReleaseDTO == PortalReleaseDTO._NULL_INSTANCE) {
            return null;
        }
        return portalReleaseDTO._buildDate;
    }

    public static int getCurrentBuildNumber(Connection connection) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        if (portalReleaseDTO == PortalReleaseDTO._NULL_INSTANCE) {
            return 0;
        }
        return portalReleaseDTO._buildNumber;
    }

    public static Version getCurrentSchemaVersion(Connection connection) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        if (portalReleaseDTO == PortalReleaseDTO._NULL_INSTANCE) {
            return new Version(0, 0, 0);
        }
        return portalReleaseDTO._schemaVersion;
    }

    public static int getCurrentState(Connection connection) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        if (portalReleaseDTO == PortalReleaseDTO._NULL_INSTANCE) {
            throw new IllegalArgumentException("No Release exists with the primary key 1");
        }
        return portalReleaseDTO._state;
    }

    public static String getCurrentTestString(Connection connection) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        if (portalReleaseDTO == PortalReleaseDTO._NULL_INSTANCE) {
            return null;
        }
        return portalReleaseDTO._testString;
    }

    public static Version getLatestSchemaVersion() {
        return (Version)_upgradeVersionTreeMap.lastKey();
    }

    public static SortedMap<Version, UpgradeProcess> getPendingUpgradeProcesses(Version schemaVersion) {
        return _upgradeVersionTreeMap.tailMap((Object)schemaVersion, false);
    }

    public static Version getRequiredSchemaVersion() {
        NavigableSet reverseSchemaVersions = _upgradeVersionTreeMap.descendingKeySet();
        Iterator iterator = reverseSchemaVersions.iterator();
        Version requiredSchemaVersion = (Version)iterator.next();
        while (iterator.hasNext()) {
            Version nextSchemaVersion = (Version)iterator.next();
            if (requiredSchemaVersion.getMajor() != nextSchemaVersion.getMajor() || requiredSchemaVersion.getMinor() != nextSchemaVersion.getMinor()) break;
            if (requiredSchemaVersion.getMicro() == nextSchemaVersion.getMicro()) continue;
            requiredSchemaVersion = nextSchemaVersion;
        }
        return requiredSchemaVersion;
    }

    public static boolean hasPortalRelease(Connection connection) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        return portalReleaseDTO != PortalReleaseDTO._NULL_INSTANCE;
    }

    public static boolean isInLatestSchemaVersion(Connection connection) throws SQLException {
        Version latestSchemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
        return latestSchemaVersion.equals((Object)PortalUpgradeProcess.getCurrentSchemaVersion(connection));
    }

    public static boolean isInRequiredSchemaVersion(Connection connection) throws SQLException {
        Version currentSchemaVersion = PortalUpgradeProcess.getCurrentSchemaVersion(connection);
        Version requiredSchemaVersion = PortalUpgradeProcess.getRequiredSchemaVersion();
        int result = requiredSchemaVersion.compareTo(currentSchemaVersion);
        return result == 0 || result < 0 && requiredSchemaVersion.getMajor() == currentSchemaVersion.getMajor();
    }

    public static boolean supportsRetry(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("select buildNumber from Release_ where servletContextName = ?");){
            preparedStatement.setString(1, "portal");
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    if (resultSet.getInt("buildNumber") >= 7100) {
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return false;
    }

    public static void updateBuildInfo(Connection connection) throws SQLException {
        java.util.Date buildDate = ReleaseInfo.getBuildDate();
        PortalUpgradeProcess._updateRelease(connection, "buildNumber = ?, buildDate = ?", (UnsafeConsumer<PreparedStatement, SQLException>)((UnsafeConsumer)preparedStatement -> {
            preparedStatement.setInt(1, ReleaseInfo.getParentBuildNumber());
            preparedStatement.setDate(2, new Date(buildDate.getTime()));
        }), portalReleaseDTO -> new PortalReleaseDTO(((PortalReleaseDTO)portalReleaseDTO)._schemaVersion, ReleaseInfo.getParentBuildNumber(), buildDate, ((PortalReleaseDTO)portalReleaseDTO)._state, ((PortalReleaseDTO)portalReleaseDTO)._testString));
    }

    public static void updateSchemaVersion(Connection connection, Version newSchemaVersion) throws SQLException {
        PortalUpgradeProcess._updateRelease(connection, "schemaVersion = ?", (UnsafeConsumer<PreparedStatement, SQLException>)((UnsafeConsumer)preparedStatement -> preparedStatement.setString(1, newSchemaVersion.toString())), portalReleaseDTO -> new PortalReleaseDTO(newSchemaVersion, ((PortalReleaseDTO)portalReleaseDTO)._buildNumber, ((PortalReleaseDTO)portalReleaseDTO)._buildDate, ((PortalReleaseDTO)portalReleaseDTO)._state, ((PortalReleaseDTO)portalReleaseDTO)._testString));
    }

    public static void updateState(Connection connection, int state) throws SQLException {
        PortalUpgradeProcess._updateRelease(connection, "modifiedDate = ?, state_ = ?", (UnsafeConsumer<PreparedStatement, SQLException>)((UnsafeConsumer)preparedStatement -> {
            preparedStatement.setDate(1, new Date(System.currentTimeMillis()));
            preparedStatement.setInt(2, state);
        }), portalReleaseDTO -> new PortalReleaseDTO(((PortalReleaseDTO)portalReleaseDTO)._schemaVersion, ((PortalReleaseDTO)portalReleaseDTO)._buildNumber, ((PortalReleaseDTO)portalReleaseDTO)._buildDate, state, ((PortalReleaseDTO)portalReleaseDTO)._testString));
    }

    public void upgrade() throws UpgradeException {
        long start = System.currentTimeMillis();
        String message = "Completed upgrade process ";
        try {
            try (Connection connection = this.getConnection();){
                this.connection = connection;
                if (_log.isInfoEnabled()) {
                    String info = "Upgrading " + ClassUtil.getClassName((Object)((Object)this));
                    _log.info((Object)info);
                }
                this.doUpgrade();
            }
            this.connection = null;
        }
        catch (Exception exception) {
            try {
                message = "Failed upgrade process ";
                throw new UpgradeException((Throwable)exception);
            }
            catch (Throwable throwable) {
                this.connection = null;
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{message, ClassUtil.getClassName((Object)((Object)this)), " in ", System.currentTimeMillis() - start, " ms"}));
                }
                throw throwable;
            }
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{message, ClassUtil.getClassName((Object)((Object)this)), " in ", System.currentTimeMillis() - start, " ms"}));
        }
    }

    protected void doUpgrade() throws Exception {
        this._initializeRelease(this.connection);
        for (Version pendingSchemaVersion : this.getPendingSchemaVersions(PortalUpgradeProcess.getCurrentSchemaVersion(this.connection))) {
            this.upgrade((UpgradeProcess)_upgradeVersionTreeMap.get((Object)pendingSchemaVersion));
            PortalUpgradeProcess.updateSchemaVersion(this.connection, pendingSchemaVersion);
        }
        this.clearIndexesCache();
    }

    protected Set<Version> getPendingSchemaVersions(Version fromSchemaVersion) {
        NavigableMap pendingUpgradeProcesses = _upgradeVersionTreeMap.tailMap((Object)fromSchemaVersion, false);
        return pendingUpgradeProcesses.keySet();
    }

    private static PortalReleaseDTO _getCurrentPortalReleaseDTO(Connection connection) throws SQLException {
        return (PortalReleaseDTO)_currentPortalReleaseDTODCLSingleton.getSingleton(() -> {
            try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select schemaVersion, buildNumber, ", "buildDate, state_, testString from Release_ ", "where releaseId = ", 1L}));
                 ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return PortalReleaseDTO._NULL_INSTANCE;
                Date buildDate = resultSet.getDate("buildDate");
                PortalReleaseDTO portalReleaseDTO = new PortalReleaseDTO(Version.parseVersion((String)resultSet.getString("schemaVersion")), resultSet.getInt("buildNumber"), buildDate != null ? new java.util.Date(buildDate.getTime()) : null, resultSet.getInt("state_"), resultSet.getString("testString"));
                return portalReleaseDTO;
            }
            catch (SQLException sqlException) {
                ReflectionUtil.throwException((Throwable)sqlException);
            }
            return PortalReleaseDTO._NULL_INSTANCE;
        });
    }

    private static void _registerUpgradeProcesses(PortalUpgradeProcessRegistry ... portalUpgradeProcessRegistries) {
        for (PortalUpgradeProcessRegistry portalUpgradeProcessRegistry : portalUpgradeProcessRegistries) {
            portalUpgradeProcessRegistry.registerUpgradeProcesses(_upgradeVersionTreeMap);
        }
    }

    private static void _updateRelease(Connection connection, String sqlSetClause, UnsafeConsumer<PreparedStatement, SQLException> consumer, Function<PortalReleaseDTO, PortalReleaseDTO> function) throws SQLException {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"update Release_ set ", sqlSetClause, " where releaseId = ", 1L}));){
            consumer.accept((Object)preparedStatement);
            if (preparedStatement.executeUpdate() > 0) {
                _currentPortalReleaseDTODCLSingleton.destroy(null);
                _currentPortalReleaseDTODCLSingleton.getSingleton(() -> (PortalReleaseDTO)function.apply(portalReleaseDTO));
            }
        }
    }

    private void _initializeRelease(Connection connection) throws Exception {
        PortalReleaseDTO portalReleaseDTO = PortalUpgradeProcess._getCurrentPortalReleaseDTO(connection);
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"update Release_ set schemaVersion = ?, buildNumber = ? ", "where releaseId = ", 1L, " and buildNumber < ?"}));){
            preparedStatement.setString(1, _initialSchemaVersion.toString());
            preparedStatement.setInt(2, 7100);
            preparedStatement.setInt(3, 7100);
            if (preparedStatement.executeUpdate() > 0) {
                _currentPortalReleaseDTODCLSingleton.destroy(null);
                _currentPortalReleaseDTODCLSingleton.getSingleton(() -> new PortalReleaseDTO(_initialSchemaVersion, portalReleaseDTO._buildNumber, portalReleaseDTO._buildDate, portalReleaseDTO._state, portalReleaseDTO._testString));
            }
        }
    }

    static {
        PortalUpgradeProcess._registerUpgradeProcesses(new com.liferay.portal.upgrade.v7_1_x.PortalUpgradeProcessRegistryImpl(), new com.liferay.portal.upgrade.v7_2_x.PortalUpgradeProcessRegistryImpl(), new PortalUpgradeProcessRegistryImpl(), new com.liferay.portal.upgrade.v7_4_x.PortalUpgradeProcessRegistryImpl());
    }

    private static class PortalReleaseDTO {
        private static final PortalReleaseDTO _NULL_INSTANCE = new PortalReleaseDTO(null, 0, null, -1, null);
        private final java.util.Date _buildDate;
        private final int _buildNumber;
        private final Version _schemaVersion;
        private final int _state;
        private final String _testString;

        private PortalReleaseDTO(Version schemaVersion, int buildNumber, java.util.Date buildDate, int state, String testString) {
            this._schemaVersion = schemaVersion;
            this._buildNumber = buildNumber;
            this._buildDate = buildDate;
            this._state = state;
            this._testString = testString;
        }
    }
}

