/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Objects;

public class UpgradeJournal
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeJournal.class);

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select id_, content from JournalArticle");
             ResultSet resultSet = preparedStatement1.executeQuery();
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");){
            while (resultSet.next()) {
                String upgradedContent;
                long id = resultSet.getLong("id_");
                String content = resultSet.getString("content");
                if (Objects.equals(content, upgradedContent = this._upgradeContent(id, content))) continue;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Fixing invalid content in journal article " + id));
                }
                preparedStatement2.setString(1, upgradedContent);
                preparedStatement2.setLong(2, id);
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private String _upgradeContent(long id, String content) throws Exception {
        if (!content.contains("<dynamic-content") && !content.contains("</dynamic-content>")) {
            return content;
        }
        content = HtmlUtil.unescape((String)content);
        content = StringUtil.replace((String)content, (String[])new String[]{"<dynamic-content>", "</dynamic-content>"}, (String[])new String[]{"<dynamic-content><![CDATA[", "]]></dynamic-content>"});
        content = StringUtil.replace((String)content, (String[])new String[]{"<dynamic-content><![CDATA[<![CDATA[", "]]>]]></dynamic-content>"}, (String[])new String[]{"<dynamic-content><![CDATA[", "]]></dynamic-content>"});
        content = content.replaceAll("<dynamic-content id=\"([0-9]+)\">", "<dynamic-content id=\"$1\"><![CDATA[");
        content = content.replaceAll("<dynamic-content id=\"([0-9]+)\"><!\\[CDATA\\[<!\\[CDATA\\[", "<dynamic-content id=\"$1\"><![CDATA[");
        for (String languageId : PropsValues.LOCALES) {
            content = StringUtil.replace((String)content, (String)("<dynamic-content language-id=\"" + languageId + "\">"), (String)("<dynamic-content language-id=\"" + languageId + "\"><![CDATA["));
            content = StringUtil.replace((String)content, (String)("<dynamic-content language-id=\"" + languageId + "\"><![CDATA[<![CDATA["), (String)("<dynamic-content language-id=\"" + languageId + "\"><![CDATA["));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Upgraded dynamic content: " + content));
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Journal article ", String.valueOf(id), " has invalid content due to: ", exception.getMessage()}));
        }
        return content;
    }
}

